<?php
checkSuperAdmin();
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);
?>

<title><?php echo SITE_NAME; ?> - Bounce Rules Management</title>
</head>

<body id="page-top">

<!-- Page Wrapper -->
<div id="wrapper">

    <?php include_once("nav_wrapper_admin.php"); ?>

    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column">

        <!-- Main Content -->
        <div id="content">

            <!-- Topbar -->
            <nav class="navbar navbar-expand navbar-light topbar mb-4 static-top shadow">

                <!-- Sidebar Toggle (Topbar) -->
                <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
                    <i class="fa fa-bars"></i>
                </button>



                <!-- Topbar Navbar -->
                <ul class="navbar-nav ml-auto">



                    <div class="topbar-divider d-none d-sm-block"></div>

                    <!-- Nav Item - User Information -->
                    <li class="nav-item dropdown no-arrow">
                        <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <span class="mr-2 d-none d-lg-inline text-white small"><?php echo $member['firstname'].' '.$member['lastname']; ?></span>
                        </a>
                        <!-- Dropdown - User Information -->
                        <div class="dropdown-menu dropdown-menu-right shadow animated--grow-in" aria-labelledby="userDropdown">
                            <a class="dropdown-item" href="<?php echo $root; ?>/settings">
                                <i class="fas fa-cogs fa-sm fa-fw mr-2 text-gray-400"></i>
                                Settings
                            </a>
                            <div class="dropdown-divider"></div>
                            <a class="dropdown-item" href="<?php echo $root; ?>/?logout=1">
                                <i class="fas fa-sign-out-alt fa-sm fa-fw mr-2 text-gray-400"></i>
                                Logout
                            </a>
                        </div>
                    </li>

                </ul>

            </nav>
            <!-- End of Topbar -->

            <!-- Begin Page Content -->
            <div class="container-fluid">

                <!-- Page Heading -->
                <div class="float-left">
                    <h1 class="h3 mb-4 text-gray-800">Bouncerules Management</h1>
                </div>
                <div class="float-right" style="margin-right: 10vw;">

                </div>
                <div class="clearfix"></div>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card shadow mb-4">
                            <div class="card-header bg-dark py-3">
                                <div class="float-left">
                                    <h6 class="m-0 font-weight-bold text-white">Bouncerules Management</h6>
                                </div>
                                <div class="clearfix"></div>
                            </div>
                            <?php

                            if(isset($_POST['action'])){
                                if($_POST['action']=='bounce_save'){
                                    $bounce_data = array(
                                        $_POST['filter_text'],
                                        $_POST['bounce_type']
                                    );
                                    $q = $pdo->prepare('INSERT INTO `bouncerules` (filter_text,bounce_type) VALUES (?,?)');
                                    $q->execute($bounce_data);

                                    echo '
                      <div class="alert alert-success" role="alert">
                        New bouncerules was successfully added!
                      </div>
                      ';
                                }elseif($_POST['action']=='bounce_update'){
                                    $bounce_data = array(
                                        $_POST['edit_filter_text'],
                                        $_POST['edit_bounce_type'],
                                        $_POST['bounce_id']
                                    );
                                    $q = $pdo->prepare('UPDATE `bouncerules` SET `filter_text`=?,`bounce_type`=?  WHERE `id`=?');
                                    $q->execute($bounce_data);

                                    echo '<div class="alert alert-success">
                       Bouncerules was successfully updated.
                      </div>';
                                }elseif($_POST['action']=='bouncerules_delete'){
                                    $q = $pdo->prepare('DELETE FROM `bouncerules` WHERE `id`=?');
                                    $q->execute(array($_POST['hid']));
                                    echo '<div style="margin-bottom:2rem;">';
                                    echo '<div class="alert alert-success" role="alert"> Bouncerules was successfully deleted</div></div>';
                                }
                            }

                            ?>
                            <div class="card-body">
                                <button class="btn btn-primary" style="margin-top: 15px;" data-toggle="modal" data-target="#addHelp">Add New</button>
                                <?php
                                $q = $pdo->prepare('SELECT id,filter_text ,bounce_type FROM `bouncerules` ORDER by id DESC');
                                $q->execute();
                                ?>
                                <?php if($q->rowcount()>0){ ?>
                                <br/><br/>
                                <table class="table admin-help-datatable datatable">
                                    <thead class="bg-default text-dark">
                                    <tr>
                                        <th scope="col" style="width: 70%;">FILTER TEXT</th>
                                        <th scope="col">BOUNCE TYPE</th>
                                        <th scope="col">ACTION</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php foreach ($q as $row) { ?>
                                        <tr>
                                            <td scope="col"><?php echo $row['filter_text']; ?></td>
                                            <td scope="col"><?php echo $row['bounce_type']; ?></td>
                                            <td scope="col">
                                                <div class="dropdown">
                                                    <button class="btn btn-primary dropdown-toggle" type="button" data-toggle="dropdown">Action
                                                        <span class="caret"></span></button>
                                                    <ul class="dropdown-menu">
                                                        <li>
                                                            <a href="javascript:void(0)" class="btn btn-danger btn-sm btn-help-delete dropdown-item" data-key="<?php echo $row['id']; ?>" title="Delete"><i class="fas fa-trash-alt"></i> Delete</a>
                                                        </li>
                                                        <li>
                                                            <a href="javascript:void(0);" class="btn btn-info btn-sm dropdown-item" data-toggle="modal" data-target="#editHelp<?php echo $row['id']; ?>" title="Edit"><i class="fas fa-pencil-alt"></i> Edit</a>
                                                    </ul>
                                                </div>

                                                <!-- Modal for Edituser -->
                                                <div class="modal fade" id="editHelp<?php echo $row['id']; ?>" tabindex="-1" role="dialog" aria-labelledby="editHelpLabel" aria-hidden="true">
                                                    <div class="modal-dialog modal-lg" role="document" style="margin-top: 10vw;">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 class="modal-title" id="addIMAPLabel">Edit Bouncerules</h5>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <form action="" method="post">
                                                                <div class="modal-body">
                                                                    <input type="hidden" name="bounce_id" value="<?php echo $row['id']; ?>" />
                                                                    <div class="row">
                                                                        <div class="col-md-12">
                                                                            <label style="display: block; margin-top: 10px;">Page Name: *</label>
                                                                            <input type="text" name="edit_filter_text" value="<?php echo $row['filter_text']; ?>" class="form-control">
                                                                        </div>
                                                                    </div>
                                                                    <div class="row">
                                                                        <div class="col-md-12">
                                                                            <label style="display: block; margin-top: 10px;">Content: *</label>
                                                                            <select id="edit_bounce_type" name="edit_bounce_type" class="form-control">
                                                                                <option <?php if($row['bounce_type']=='soft'){?> selected <?php }?> value="soft"><?php echo "Soft Bounce"; ?></option>
                                                                                <option <?php if($row['bounce_type']=='hard'){?> selected <?php }?> value="hard"><?php echo "Hard Bounce"; ?></option>
                                                                                <option <?php if($row['bounce_type']=='auto_reply'){?> selected <?php }?> value="auto_reply"><?php echo "Auto Reply"; ?></option>
                                                                            </select>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="modal-footer">
                                                                    <button type="submit" class="btn btn-primary" name="action" value="bounce_update">Update</button>
                                                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <?php } ?>

                        <!-- Modal Add -->
                        <div class="modal fade" id="addHelp" tabindex="-1" role="dialog" aria-labelledby="addHelpLabel" aria-hidden="true">
                            <div class="modal-dialog modal-lg" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="addHelpLabel">Add Bouncerules</h5>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <form action="" method="post">
                                        <div class="modal-body">
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <label style="display: block; margin-top: 10px;"> Filter text: *</label>
                                                    <input type="text" name="filter_text" class="form-control">
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <label style="display: block; margin-top: 10px;">Bounce Type: *</label>
                                                    <select id="bounce_type" name="bounce_type" class="form-control">
                                                        <option value="soft"><?php echo "Soft Bounce"; ?></option>
                                                        <option value="hard"><?php echo "Hard Bounce"; ?></option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="submit" class="btn btn-primary" name="action" value="bounce_save">Save</button>
                                            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <!-- Modal Delete Confirmation -->
                        <div class="modal fade modal-enhanced modal-danger" id="modalDeleteConfirmation" tabindex="-1" role="dialog" aria-labelledby="modalDeleteConfirmationlabel" aria-hidden="true">
                            <div class="modal-dialog modal-md" role="document">
                                <form action="#" method="post">
                                    <input type="hidden" value="" name="hid" class="hid">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title"><i class="far fa-trash-alt"></i> Delete Bouncerules</h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <div class="modal-body">
                                            <div class="autoreply-selected-msg">Delete selected bounce filter?</div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-default" data-dismiss="modal">No</button>
                                                <button type="submit" class="btn btn-danger" name="action" value="bouncerules_delete">Yes</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>

                    </div>

                </div>

            </div>
            <!-- /.container-fluid -->

        </div>
        <!-- End of Main Content -->



        <!-- Footer -->
        <footer class="sticky-footer bg-white">
            <div class="container my-auto">
                <div class="copyright text-center my-auto">
                    <span>Copyright &copy; <?php echo date('Y'); ?></span>
                </div>
            </div>
        </footer>
        <!-- End of Footer -->

    </div>
    <!-- End of Content Wrapper -->

</div>
<!-- End of Page Wrapper -->

<!-- Scroll to Top Button-->
<a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
</a>

<script>
    $(function(){
        $(".btn-help-delete").click(function(){
            var hid = $(this).attr("data-key");
            $(".hid").val(hid);
            $("#modalDeleteConfirmation").modal('show');
        });
    });
</script>
