<?php
require_once 'config.php';
require_once 'functions.php';
require_once 'ApiMailClickConvert.php';

$lists = $pdo->prepare("SELECT id,member_id  FROM `lists` WHERE verification = 0"); //Unverified status
$lists->execute();

foreach($lists as $list)
{
    $prospect = $pdo->prepare('SELECT * FROM `prospect` WHERE `list_id`= ?');
    $prospect->execute(array($list['id']));
    $prospect_record = $prospect->fetch(PDO::FETCH_ASSOC);
    if(!empty($prospect_record))
    {
        if($prospect_record['status'] == 'pending')
        {
            continue;
        }
    }
    //  $q = $pdo->prepare('SELECT * FROM `members` WHERE id = ?');
    //  $q->execute(array($list['member_id']));
    //  $member = $q->fetch(PDO::FETCH_ASSOC);
    $contacts = $pdo->prepare("SELECT email,firstName,lastName,status FROM `contacts` WHERE `list_id` =?"); //Unverified status
    $contacts->execute(array($list['id']));

    if( $contacts->rowcount() > 0 ){

        // if($member['cleaning_credits'] >= $contacts->rowCount())
        // {
        //     $q = $pdo->prepare('UPDATE `members` SET cleaning_credits = ? WHERE id = ?');
        //     $q->execute(array($member['cleaning_credits'] - $contacts->rowCount() , $list['member_id']));
        // }else{
        //     continue;
        // }

        $file = 'csv/automailer_list_' . $list['id'] . '.csv';
        $csv_handler = fopen($file,'w');

        $csv = "firstname,lastname,email \n";
        fwrite ($csv_handler,$csv);

        foreach( $contacts as $contact ){
            $csv = $contact['firstName'] . "," . $contact['lastName'] . "," . $contact['email'] . "\n";
            fwrite ($csv_handler,$csv);
        }


        fclose ($csv_handler);

        $url = $root.'/'.$file;

        $mailClick = new ApiMailClickConvert();
        $mailClickResponse = $mailClick->uploadlistbyurl($url);
        if( $mailClickResponse->listid > 0 ){
            //Insert list id
            $data_mail_click_list = array(
                NULL,
                $list['member_id'],
                $mailClickResponse->importid,
                $mailClickResponse->listid,
                $list['id'],
                $mailClickResponse->status,
                0,
                0,
                time()
            );
            $q = $pdo->prepare('INSERT INTO `mail_click_convert_list` VALUES (?,?,?,?,?,?,?,?,?)');
            $q->execute($data_mail_click_list);

        }
    }

    $q = $pdo->prepare('UPDATE `lists` SET `verification`=? WHERE `id`=?');
    $q->execute(array(1,  $list['id']));
}

?>