<?php
error_reporting(0);

require_once('Hashid/vendor/autoload.php');

$start = (int) $_POST['start'];
$end   = (int) $_POST['length'];
$sort  = htmlspecialchars($_POST['order'][0]['dir'],ENT_QUOTES);
$sort_col = htmlspecialchars($_POST['order'][0]['column'],ENT_QUOTES);
$_POST['search']['value'] = htmlspecialchars($_POST['search']['value'],ENT_QUOTES);

switch ($sort_col) {
    case 1:
        $col_name = 'name';
        break;
    default:
        $col_name = 'date_created';
        break;
}
$q = $pdo->prepare('SELECT * FROM `members` WHERE `id`=? LIMIT 1');
$q->execute(array($_SESSION['id']));
$member = $q->fetch(PDO::FETCH_ASSOC);

$q = $pdo->prepare('SELECT COUNT(id) FROM `lists` WHERE `member_id`=?');
$q->execute(array($member['id']));
$total_records = $q->fetchColumn();

$custom_query = '';
if(isset($_SESSION['list_filter']['date_from']) && isset($_SESSION['list_filter']['date_to'])){
    $date_from = date("Y-m-d",strtotime($_SESSION['list_filter']['date_from']));
    $date_from = $date_from . " " . "00:00:00";

    $date_to = date("Y-m-d",strtotime($_SESSION['list_filter']['date_to']));
    $date_to = $date_to . " " . "23:59:59";

    $custom_query = "(date_created >= '" . $date_from . "' AND date_created <= '" .$date_to. "')";
}

if( $_POST['search']['value'] != '' ){
    if( $custom_query != '' ){
        $q = $pdo->prepare('SELECT * FROM `lists` WHERE `member_id`=? AND ' .$custom_query. ' AND (name LIKE "%'.$_POST['search']['value'].'%")  ORDER BY '.$col_name.' ' .$sort. ' LIMIT '.$start.','.$end);
    }else{
        $q = $pdo->prepare('SELECT * FROM `lists` WHERE `member_id`=? AND (name LIKE "%'.$_POST['search']['value'].'%")  ORDER BY '.$col_name.' ' .$sort. ' LIMIT '.$start.','.$end);
    }


}else{
    if( $custom_query != '' ){
        $q = $pdo->prepare('SELECT * FROM `lists` WHERE `member_id`=? AND ' .$custom_query. ' ORDER BY '.$col_name.' ' .$sort. ' LIMIT '.$start.','.$end);
    }else{
        $q = $pdo->prepare('SELECT * FROM `lists` WHERE `member_id`=? ORDER BY '.$col_name.' ' .$sort. ' LIMIT '.$start.','.$end);
    }
}

$q->execute(array($member['id']));
$lists = $q->fetchAll();

//Roles
$roles = $pdo->prepare('SELECT * FROM `user_roles` WHERE `member_id`=?');
$roles->execute(array($member['id']));

$hdr_list_roles = array();
foreach( $roles as $role ){
    $hdr_list_roles[$role['module']] = $role['action'];
}

$list_roles = array();
if( array_key_exists('list', $hdr_list_roles) ){
    $list_roles = json_decode($hdr_list_roles['list']);
}

//Copy list
$q = $pdo->prepare('SELECT id,stripe_status,parent_id FROM `members` WHERE `id`=? LIMIT 1');
$q->execute(array($_SESSION['id']));
$member = $q->fetch(PDO::FETCH_ASSOC);

//end copy list

$array_key = 0;
$dt_data = array();

foreach( $lists as $list ){

    //Total contacts
    $contacts = $pdo->prepare("SELECT COUNT(id) AS total FROM `contacts` WHERE `list_id` =?");
    $contacts->execute(array($list['id']));
    $totalContacts = $contacts->fetch(PDO::FETCH_ASSOC);

    $data = $pdo->prepare('SELECT `list_id`,`status` FROM `mail_click_convert_list` WHERE `automailer_list_id`=? ORDER BY `id` DESC');
    $data->execute(array($list['id']));
    $mailClick = $data->fetch(PDO::FETCH_ASSOC);

    $bad_list = $pdo->prepare('SELECT count(*) as total FROM `contacts` WHERE `list_id`=? AND `status` > 1');
    $bad_list->execute(array($list['id']));

    $badlistCount = $bad_list->fetch(PDO::FETCH_ASSOC);

    $good_list = $pdo->prepare('SELECT count(*) as total  FROM `contacts` WHERE `list_id`=? AND `status` = 1');
    $good_list->execute(array($list['id']));

    $goodlistCount = $good_list->fetch(PDO::FETCH_ASSOC);

    $hashids = new Hashids\Hashids();
    $eid = $hashids->encode($list['id']);

    $list_name =  '<a data-encode="'.$eid.'" id="anchor_list_name_'.$list['id'].'" href="'.$root.'/list/'.$eid.'">'.$list['name'].'</a>';

    $mailclick_status = "<span class='text-danger'>Unverified<span>";
    $processing = false;
    if( $mailClick ){
        $mailclick_status = "<span class='text-success'>".$mailClick['status']."<span>";
        if($mailClick['status'] == "Processing"){
            $processing = true;
        }
    }

    $data = $pdo->prepare('SELECT * FROM `csv_files` WHERE `list_id`=? ');
    $data->execute(array($list['id']));
    $csv_file = $data->fetch(PDO::FETCH_ASSOC);

    if($csv_file > 0)
    {
        if($csv_file['status']=="pending")
        {
            $mailclick_status = "<span style='color:black'>Uploading<span>";
        }
    }

    $data = $pdo->prepare('SELECT * FROM `prospect` WHERE `list_id`=? ');
    $data->execute(array($list['id']));
    $prospect = $data->fetch(PDO::FETCH_ASSOC);

    if($prospect > 0)
    {
        if($prospect['status']=="pending")
        {
            $mailclick_status = "<span style='color:black'>Processing<span>";
        }
    }

    $delete_action = '';
    if( in_array("delete", $list_roles)  || $member['account_type'] == 0 ){
        $delete_action = '<a href="javascript:void(0);" class="btn btn-default btn-sm btn-list-delete" data-key="'.$list['id'].'"><i class="fas fa-trash-alt"></i></a>';
    }

    $edit_action = '';
    if( in_array("add", $list_roles)  || $member['account_type'] == 0 ){
        $edit_action = '<div class="edit_btn name list-row-'.$list['id'].'" data-key="'.$list['id'].'"  attr-list-id="'.$list['id'].'" attr-list-name="'.$list['name'].'" style="display:inline-block;"><a href="javascript:void(0);" class="btn btn-default btn-sm" attr-edit-list data-key="'.$list['id'].'"><i class="far fa-edit"></i></a></div>';
    }

    $duplicate_action = '<a href="javascript:void(0);" class="btn btn-default btn-sm btn-list-duplicate" data-text="'.$list['name'].'" data-key="'.$list['id'].'"><i class="fas fa-copy"></i></a>';

    $disable = "";
    if($processing){
        $disable = "disabled";
    }

    $checkbox = '<input type="checkbox" '. $disable .'  name="mailClickList[]" data-contacts="'.$list['total_contacts'].'" value="'.$list['id'].'" class="checkbox list-check-row-data" />';
    $action = $delete_action . '' . $duplicate_action . ' ' . $edit_action;
    if( $list['date_created'] != '' ){
        $date_created = date("d-m-Y",strtotime($list['date_created']));
    }else{
        $date_created = '---';
    }
    $list_data = array(
        //$checkbox,
        $list_name,
        $totalContacts['total'],
        $goodlistCount['total'],
        $badlistCount['total'],
        $mailclick_status,
        $date_created,
        $action
    );

    $dt_data[$array_key] = $list_data;

    $array_key++;
}

echo json_encode(array('data' => $dt_data,'recordsTotal' => $total_records, 'recordsFiltered' => $total_records));
?>