<?php

include 'config.php';
require(dirname(__file__) . '/PhpExcel/Classes/PHPExcel.php');


// Create new PHPExcel object
PHPExcel_Settings::setZipClass(PHPExcel_Settings::PCLZIP);
$objPHPExcel = new PHPExcel();
$objPHPExcel->getProperties()->setCreator("Automailer");

$BStyle = array(
    'borders' => array(
        'allborders' => array(
            'style' => PHPExcel_Style_Border::BORDER_THIN
        )
    )
);

//HEADER
$objPHPExcel->setActiveSheetIndex(0);
$objPHPExcel->getActiveSheet()->setCellValue('A1', "Unsubscribe List");
$objPHPExcel->getActiveSheet()->mergeCells('A1:D1');

$i=3;

$unsubscribe_mails = $pdo->prepare('SELECT id,member_id,campaign_id, email, date_created  FROM `unsubscribed_emails` WHERE `member_id`=?');
$unsubscribe_mails->execute(array($_POST['member_id']));

$i++;

$objPHPExcel->getActiveSheet()->setCellValue('A'.$i, 'Campaign');
$objPHPExcel->getActiveSheet()->setCellValue('B'.$i, 'First name');
$objPHPExcel->getActiveSheet()->setCellValue('C'.$i, 'Last name');
$objPHPExcel->getActiveSheet()->setCellValue('D'.$i, 'Email');
$objPHPExcel->getActiveSheet()->setCellValue('E'.$i, 'Date Unsubscribe');
$objPHPExcel->getActiveSheet()->getStyle('A'.$i.':E'.$i)->applyFromArray($BStyle);

$objPHPExcel->getActiveSheet()
    ->getStyle('A'.$i.':E'.$i)
    ->getFill()
    ->setFillType(PHPExcel_Style_Fill::FILL_SOLID)
    ->getStartColor()
    ->setRGB('cccccc')
;
$i++;

foreach ($unsubscribe_mails as $unsubscribe_mail) {

    $campaigns = $pdo->prepare('SELECT id,member_id,list,name FROM `campaigns` WHERE `id`=? LIMIT 1');
    $campaigns->execute(array($unsubscribe_mail['campaign_id']));
    $campaign = $campaigns->fetch(PDO::FETCH_ASSOC);


    $contacts = $pdo->prepare('SELECT firstName,lastName,email,list_id FROM `contacts` WHERE `list_id`=? AND `email`=? LIMIT 1');
    $contacts->execute(array($campaign['list'], $unsubscribe_mail['email'] ));
    $contact = $contacts->fetch(PDO::FETCH_ASSOC);


    $objPHPExcel->getActiveSheet()->setCellValue('A'.$i, $campaign['name']);
    $objPHPExcel->getActiveSheet()->setCellValue('B'.$i, $contact['firstName']);
    $objPHPExcel->getActiveSheet()->setCellValue('C'.$i, $contact['lastName']);
    $objPHPExcel->getActiveSheet()->setCellValue('D'.$i, $contact['email']);
    $objPHPExcel->getActiveSheet()->setCellValue('E'.$i, date('m/d/Y h:i A',$unsubscribe_mail['date_created']));
    $objPHPExcel->getActiveSheet()->getStyle('A'.$i.':E'.$i)->applyFromArray($BStyle);

    $i++;

}

$i++;
// Rename sheet
$objPHPExcel->getActiveSheet()->setTitle('Unsubscribe');


// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);
$filename = "Unsubscribe_report.xlsx";

ob_clean();
//call the function in the controller with $output_type = F and $file with complete path to the file, to generate the file in the server for example attach to email
// Redirect output to a client's web browser (Excel2007)
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="'.$filename.'"');
header('Cache-Control: max-age=0');
$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
$objWriter->save('php://output');
?>