<?php
//exit();
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use PhpImap\Mailbox;
use PhpImap\Exceptions\ConnectionException;
define("IN_CRONTAB",1);
require_once dirname(__FILE__) . '/config.php';
require_once dirname(__FILE__) . '/functions.php';
require_once dirname(__FILE__) . '/PHPMailer/autoload.php';
require_once dirname(__FILE__) . '/php-imap/autoload.php';
require_once dirname(__FILE__) . '/email_verifier/verify_email.php'; 

error_reporting(E_ALL);
ini_set('display_errors', 1);
set_time_limit(900);

echo 'Running Cron Bounce Check';
$script_time_start = microtime(true);
$mail = new PHPMailer();
$mail->getSMTPInstance()->Timelimit = PHPMAILER_TIMEOUT;

//Marked email if replied
$date = date("Y-m-d");
$default_followup_date = defaultFollowupDate($date);

$q = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `replied`=? AND `bounced`=? AND `is_verified`=? LIMIT 10');
$q->execute(array(0,0,0));

foreach ($q as $row) {
	$verifyEmail = new VerifyEmail();
	$verifyEmail->setStreamTimeoutWait(MAILVERIFY_TIMEOUT);
	$verifyEmail->Debug= TRUE; 
	$verifyEmail->Debugoutput= 'html'; 
	$verifyEmail->setEmailFrom('jeniel.mangahis@gmail.com');
	$email = $row['to_email']; 

	if($verifyEmail->check($email)){ 
		$is_bounced = 0;
	}else{
		$is_bounced = 1;
	}

	$bouncedMail = $pdo->prepare('UPDATE `sent_mails` SET `last_activity`=?, `bounced`=?, `is_verified`=1 WHERE `id`=?');
	$bouncedMail->execute(array(time(), $is_bounced, $row['id']));
}


$time_end = microtime(true);
$time = $time_end - $script_time_start;

echo ' End Cron Bounce Check: - Time Taken: ' . $time . '<br>';