<?php
$q = $pdo->prepare('SELECT * FROM `members` WHERE `id`=?');
$q->execute(array($_POST['mid']));
$row = $q->fetch(PDO::FETCH_ASSOC);

//Roles
$roles = $pdo->prepare('SELECT * FROM `user_roles` WHERE `member_id`=?');
$roles->execute(array($_POST['mid']));
$list_roles = array();
foreach( $roles as $role ){
    $list_roles[$role['module']] = $role['action'];
}
?>
<div class="row">
    <div class="col-md-5">
        <div class="form-group">
            <input type="text" name="edit_firstname" class="form-control" value="<?php echo $row['fname']; ?>">
            <label>First Name:*</label>
        </div>
    </div>

    <div class="col-md-5">
        <div class="form-group">
            <input type="text" name="edit_lastname" class="form-control" value="<?php echo $row['lname']; ?>">
            <label>Last Name:*</label>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-4">
        <div class="form-group">
            <input type="email" name="edit_email" class="form-control" value="<?php echo $row['email']; ?>">
            <label>Email:*</label>
        </div>
    </div>
</div>
<h4 style="margin-bottom:20px;">Roles</h4>
<div class="row">
    <div class="col-md-6">
        <div class="form-group">
            <select class="form-control edit-sub-account-type" data-key="<?php echo $row['id']; ?>" name="sub_account_type">
                <option value="1" <?php echo( $row['account_type'] == 1 ? 'selected="selected"' : '' ); ?>>User</option>
                <option value="0" <?php echo( $row['account_type'] == 0 ? 'selected="selected"' : '' ); ?>>Admin</option>
            </select>
            <label>Sub Account Type:*</label>
        </div>
    </div>
</div>
<?php
$css_roles = '';
if( $row['account_type'] == 0 ){
    $css_roles = "display:none;";
}
?>

<div class="user-roles user-roles-<?php echo $row['id']; ?>" style="<?php echo $css_roles; ?>">
    <div class="row">
        <div class="col-md-3">
            <h3>LIST</h3>
            <?php
            $roles_list     = json_decode($list_roles['list']);
            $roles_template = json_decode($list_roles['template']);
            $roles_campaign = json_decode($list_roles['campaign']);
            $roles_leads    = json_decode($list_roles['leads']);
            $roles_settings = json_decode($list_roles['settings']);
            $roles_exclusions = json_decode($list_roles['exclusions']);
            ?>
            <ul class="roles-list">
                <li>
                    <div class="custom-control custom-checkbox">
                        <input <?php echo( in_array('view', $roles_list) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input" id="listView<?= $row['id']; ?>" name="roles[list][view]">
                        <label class="custom-control-label" for="listView<?= $row['id']; ?>">Can View</label>
                    </div>
                </li>
                <li>
                    <div class="custom-control custom-checkbox">
                        <input <?php echo( in_array('add', $roles_list) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input" id="listAdd<?= $row['id']; ?>" name="roles[list][add]">
                        <label class="custom-control-label" for="listAdd<?= $row['id']; ?>">Can Add</label>
                    </div>
                </li>
                <li>
                    <div class="custom-control custom-checkbox">
                        <input <?php echo( in_array('edit', $roles_list) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input" id="listEdit<?= $row['id']; ?>" name="roles[list][edit]">
                        <label class="custom-control-label" for="listEdit<?= $row['id']; ?>">Can Edit</label>
                    </div>
                </li>
                <li>
                    <div class="custom-control custom-checkbox">
                        <input <?php echo( in_array('delete', $roles_list) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input" id="listDelete<?= $row['id']; ?>" name="roles[list][delete]">
                        <label class="custom-control-label" for="listDelete<?= $row['id']; ?>">Can Delete</label>
                    </div>
                </li>
            </ul>
        </div>

        <div class="col-md-3">
            <h3>TEMPLATE</h3>
            <ul class="roles-list">
                <li>
                    <div class="custom-control custom-checkbox">
                        <input <?php echo( in_array('view', $roles_template) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input" id="templateView<?= $row['id']; ?>" name="roles[template][view]">
                        <label class="custom-control-label" for="templateView<?= $row['id']; ?>">Can View</label>
                    </div>
                </li>
                <li>
                    <div class="custom-control custom-checkbox">
                        <input <?php echo( in_array('add', $roles_template) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input" id="templateAdd<?= $row['id']; ?>" name="roles[template][add]">
                        <label class="custom-control-label" for="templateAdd<?= $row['id']; ?>">Can Add</label>
                    </div>
                </li>
                <li>
                    <div class="custom-control custom-checkbox">
                        <input <?php echo( in_array('edit', $roles_template) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input" id="templateEdit<?= $row['id']; ?>" name="roles[template][edit]">
                        <label class="custom-control-label" for="templateEdit<?= $row['id']; ?>">Can Edit</label>
                    </div>
                </li>
                <li>
                    <div class="custom-control custom-checkbox">
                        <input <?php echo( in_array('delete', $roles_template) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input" id="templateDelete<?= $row['id']; ?>" name="roles[template][delete]">
                        <label class="custom-control-label" for="templateDelete<?= $row['id']; ?>">Can Delete</label>
                    </div>
                </li>
            </ul>
        </div>

        <div class="col-md-3">
            <h3>CAMPAIGN</h3>
            <ul class="roles-list">
                <li>
                    <div class="custom-control custom-checkbox">
                        <input <?php echo( in_array('view', $roles_campaign) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input" id="campaignView<?= $row['id']; ?>" name="roles[campaign][view]">
                        <label class="custom-control-label" for="campaignView<?= $row['id']; ?>">Can View</label>
                    </div>
                </li>
                <li>
                    <div class="custom-control custom-checkbox">
                        <input <?php echo( in_array('start', $roles_campaign) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input" id="campaignStart<?= $row['id']; ?>" name="roles[campaign][start]">
                        <label class="custom-control-label" for="campaignStart<?= $row['id']; ?>">Can Start Campaign</label>
                    </div>
                </li>
                <li>
                    <div class="custom-control custom-checkbox">
                        <input <?php echo( in_array('edit', $roles_campaign) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input" id="campaignEdit<?= $row['id']; ?>" name="roles[campaign][edit]">
                        <label class="custom-control-label" for="campaignEdit<?= $row['id']; ?>">Can Edit Existing Campaign</label>
                    </div>
                </li>
            </ul>
        </div>

        <div class="col-md-3">
            <h3>LEADS</h3>
            <ul class="roles-list">
                <li>
                    <div class="custom-control custom-checkbox">
                        <input <?php echo( in_array('view', $roles_leads) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input" id="leadsView<?= $row['id']; ?>" name="roles[leads][view]">
                        <label class="custom-control-label" for="leadsView<?= $row['id']; ?>">Can View</label>
                    </div>
                </li>
                <li>
                    <div class="custom-control custom-checkbox">
                        <input <?php echo( in_array('change_status', $roles_leads) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input" id="leadsChangeStatus<?= $row['id']; ?>" name="roles[leads][change_status]">
                        <label class="custom-control-label" for="leadsChangeStatus<?= $row['id']; ?>">Can Change status</label>
                    </div>
                </li>
                <li>
                    <div class="custom-control custom-checkbox">
                        <input <?php echo( in_array('reply', $roles_leads) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input" id="leadsReply<?= $row['id']; ?>" name="roles[leads][reply]">
                        <label class="custom-control-label" for="leadsReply<?= $row['id']; ?>">Can Reply</label>
                    </div>
                </li>
            </ul>
        </div>

        <div class="col-md-3">
            <h3>SETTINGS</h3>
            <ul class="roles-list settings-role">
                <li>
                    <div class="custom-control custom-checkbox">
                        <input <?php echo( in_array('update_name', $roles_settings) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input" id="settingsUpdateName<?= $row['id']; ?>" name="roles[settings][update_name]">
                        <label class="custom-control-label" for="settingsUpdateName<?= $row['id']; ?>">Can Update Name</label>
                    </div>
                </li>
                <li>
                    <div class="custom-control custom-checkbox">
                        <input <?php echo( in_array('update_password', $roles_settings) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input" id="settingsChangePassword<?= $row['id']; ?>" name="roles[settings][update_password]">
                        <label class="custom-control-label" for="settingsChangePassword<?= $row['id']; ?>">Can Update Password</label>
                    </div>
                </li>
                <li>
                    <div class="custom-control custom-checkbox">
                        <input <?php echo( in_array('update_signature', $roles_settings) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input" id="settingsChangeSignature<?= $row['id']; ?>" name="roles[settings][update_signature]">
                        <label class="custom-control-label" for="settingsChangeSignature<?= $row['id']; ?>">Can Update Signature</label>
                    </div>
                </li>
                <li>
                    <div class="custom-control custom-checkbox">
                        <input <?php echo( in_array('update_timezone', $roles_settings) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input" id="settingsUpdateTimezoe<?= $row['id']; ?>" name="roles[settings][update_timezone]">
                        <label class="custom-control-label" for="settingsUpdateTimezoe<?= $row['id']; ?>">Can Update Timezone</label>
                    </div>
                </li>
                <li>
                    <div class="custom-control custom-checkbox">
                        <input <?php echo( in_array('change_sending_speed', $roles_settings) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input" id="settingsChangeSendingSpeed<?= $row['id']; ?>" name="roles[settings][change_sending_speed]">
                        <label class="custom-control-label" for="settingsChangeSendingSpeed<?= $row['id']; ?>">Can Change Sending Speed</label>
                    </div>
                </li>
            </ul>
        </div>

        <div class="col-md-3">
            <h3>EXCLUSIONS</h3>
            <ul class="roles-list">
                <li>
                    <div class="custom-control custom-checkbox">
                        <input <?php echo( in_array('view', $roles_exclusions) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input" id="exclusionsView<?= $row['id']; ?>" name="roles[exclusions][view]">
                        <label class="custom-control-label" for="exclusionsView<?= $row['id']; ?>">Can View</label>
                    </div>
                </li>
                <li>
                    <div class="custom-control custom-checkbox">
                        <input <?php echo( in_array('manage', $roles_exclusions) ? 'checked = "checked"' : '' ); ?> type="checkbox" class="custom-control-input" id="exclusionsManage<?= $row['id']; ?>" name="roles[exclusions][manage]">
                        <label class="custom-control-label" for="exclusionsManage<?= $row['id']; ?>">Can Manage Exclusions</label>
                    </div>
                </li>
            </ul>
        </div>
    </div>
</div>