  <title><?php echo SITE_NAME; ?> - Campaigns</title>
  <link rel="stylesheet" href="<?php echo $root; ?>/trumbowyg/plugins/colors/ui/trumbowyg.colors.css">
  <link rel="stylesheet" href="<?php echo $root; ?>/trumbowyg/plugins/emoji/ui/trumbowyg.emoji.css">
</head>

<body id="page-top">
  <!-- Page Wrapper -->
  <div id="wrapper">

    <?php include_once("nav_wrapper.php"); ?>
    
    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column">

      <!-- Main Content -->
      <div id="content">

        <!-- Topbar Navbar -->
        <?php include_once("nav/right_nav.php"); ?>

        <!-- Begin Page Content -->
        <div class="container-fluid dashboard">
          
          <!-- Panel Tab -->
          <div class="panel-tab">          
              <ul class="tab-nav">
                <li class="tab-active-nav"><a href="<?php echo $root."/active-campaigns"; ?>">Active Campaigns</a></li>
                <li><a href="<?php echo $root."/inactive-campaigns"; ?>">Inactive Campaigns</a></li>
              </ul>
          </div>

          <!-- Page Heading -->
          <div class="panel-header">
            <div class="float-left">
              <h1 class="panel-title">Campaigns</h1>
            </div>
            <div class="float-left">
              <form class="search-form">
                <i class="fas fa-search"></i>
                <input type="text" placeholder="Search" name="">
              </form>
            </div>
            <div class="clearfix"></div>
          </div>
          

          <div class="row">

            <div class="col-sm-12">

              <?php
              if(isset($_GET['remove']))
              {
                $q = $pdo->prepare('DELETE FROM `campaigns` WHERE `id`=? AND `member_id`=? LIMIT 1');
                $q->execute(array($_GET['remove'], $_SESSION['id']));
                header('Location: '.$root.'/campaigns');
                exit();
              }
              ?>

              <?php
              if(isset($_SEO[2]) && $_SEO[2] !== 'activate' && $_SEO[2] !== 'deactivate')
              {                
                switch ($_SEO[2]) {
                  case 'create':                  
                  if(isset($_POST['name']))
                  {
                    ?>
                    <h5>Please review your campaign</h5>
                    <nav aria-label="breadcrumb">
                      <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#">Configure Campaign</a></li>
                        <li class="breadcrumb-item"><a href="#">Choose Recipients</a></li>
                        <li class="breadcrumb-item"><a href="#">Compose Emails</a></li>
                        <li class="breadcrumb-item"><a href="#">Preview</a></li>
                        <li class="breadcrumb-item"><a href="#">Activate</a></li>
                      </ol>
                    </nav>
                    <?php
                    $name = $_POST['name'];

                    switch ($_POST['stop_at']) {
                      case 'reply':
                        $stop_at = json_encode(array(
                          'type' => 'reply'
                        ));
                        break;
                      
                      default:
                        $stop_at = json_encode(array(
                          'type' => 'finish'
                        ));
                        break;
                    }

                    $q = $pdo->prepare('SELECT * FROM `lists` WHERE `id`=?');
                    $q->execute(array($_POST['list']));
                    $list = $q->fetch(PDO::FETCH_ASSOC);


                    if(strpos($_POST['send_with'], 'smtp') !== false)
                    {
                      $id = str_replace('smtp:', '', $_POST['send_with']);
                      $q = $pdo->prepare('SELECT * FROM `smtp` WHERE `id`=?');
                      $q->execute(array($id));
                      $data = $q->fetch(PDO::FETCH_ASSOC);
                      $send_with = 'SMTP - '.$data['from_email'].' - '.$data['server'];
                      $send_server = 'smtp';
                    }
                    else
                    {
                      $id = str_replace('gmail:', '', $_POST['send_with']);
                      $q = $pdo->prepare('SELECT * FROM `gmail_accounts` WHERE `id`=?');
                      $q->execute(array($id));
                      $data = $q->fetch(PDO::FETCH_ASSOC);
                      $send_with = 'Gmail - '.$data['email'];
                      $send_server = 'gmail';
                    }

                    $emails = array();

                    foreach ($_POST['subject'] as $key => $value) {
                      if(!empty($_POST['days_after'][$key]))
                      {
                        $time = @strtotime('+'.$_POST['days_after'][$key].' days');
                      }
                      else
                      {
                        $time = time();
                      }

                      if(!empty($_POST['datetime'][$key]))
                      {
                        $emails[] = array(
                          'subject'=>$value,
                          'body'=>$_POST['body'][$key],
                          'time'=>@strtotime($_POST['datetime'][$key]),
                          'email_number'=>@$_POST['email_number'][$key],
                          'trigger'=>@$_POST['trigger'][$key],
                          'link'=>@$_POST['link'][$key],
                          'send_id'=>$id,
                          'send_server'=>$send_server,
                          'days_after'=>0,
                          'days_after_time' =>0,
                          'send_weekend' =>@$_POST['send_weekend'][$key]
                        );
                      }
                      else
                      {
                        $emails[] = array(
                          'subject'=>$value,
                          'body'=>$_POST['body'][$key],
                          'time'=>$time,
                          'email_number'=>@$_POST['email_number'][$key],
                          'trigger'=>@$_POST['trigger'][$key],
                          'link'=>@$_POST['link'][$key],
                          'send_id'=>$id,
                          'send_server'=>$send_server,
                          'days_after'=>@$_POST['days_after'][$key],
                          'days_after_time' =>@$_POST['days_after_time'][$key],
                          'send_weekend' =>@$_POST['send_weekend'][$key]
                        );
                      }
                      $time = '';
                    }

                    $q = $pdo->prepare('INSERT INTO `campaigns` (name,list,sending_account,bcc,emails,replies,opens,bounces,created,status,data,stop_at,member_id,trigger_date) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)');
                    $result = $q->execute(array(
                      $name,
                      $list['id'],
                      $send_server.':'.$id,
                      $_POST['bcc'],
                      0,
                      0,
                      0,
                      0,
                      time(),
                      CAMPAIGN_STATUS_PAUSED,
                      json_encode($emails),
                      $stop_at,
                      $member['id'],
                      '',
                    ));
                    $campaign_id = $pdo->lastInsertId();
                    ?>
                    <div class="card shadow mb-4">
                      <div class="card-header bg-dark py-3">
                        <h4 class="m-0 font-weight-bold text-white">Preview</h4>
                      </div>
                      <div class="card-body">
                        <?php
                        echo '<h5>Campaign name: '.$name.'</h5>';
                        echo '<h5>List: '.$list['name'].' - '.$list['total_contacts'] .' contacts</h5>';
                        echo '<h5>Sending account: '.$send_with.'</h5>';
                        ?>
                      </div>
                    </div>
                    <?php

                    $i = 1;
                    foreach ($emails as $email) {

                      echo '
                      <div class="card shadow mb-4">
                        <div class="card-header bg-dark py-3">
                          <h6 class="m-0 font-weight-bold text-white">Email '.$i.': '.$email['subject'].' ';
                          if(!empty($email['trigger']))
                          {
                            if(!empty($email['days_after']) & $email['days_after']>0)
                            {
                              echo ' - Trigger: '.$email['days_after'].' days after if email '.$email['email_number'].' '.str_replace('has_click', 'has a link click on '.$email['link'], $email['trigger']);
                            }
                            else
                            {
                              echo ' - Trigger: on '.date('F jS, Y h:i A', $email['time']).' if email '.$email['email_number'].' '.str_replace('has_click', 'has a link click on '.$email['link'], $email['trigger']);
                            }
                          }
                          echo '</h6>
                        </div>
                        <div class="card-body">
                        '.$email['body'].'
                        </div>
                        </div>
                      ';

                      $i++;

                    }

                    ?>
                    <form id="activate-campaign" method="post">
                    <div class="card shadow mb-4">
                      <div class="card-header bg-dark py-3">
                        <h6 class="m-0 font-weight-bold text-white">Set Date and Time to Activate Campaign</h6>
                      </div>
                      <div class="card-body">
                        <div class="input-group date" id="" data-target-input="nearest">
                            <input type="text" name="trigger_date" id="trigger-date" class="form-control default-datepicker" placeholder="Select Date" required="" />
                            <div class="input-group-append" data-target="#trigger-date">
                                <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                            </div>
                        </div>
                        <br />
                        <div class="input-group date" id="" data-target-input="nearest">
                            <input type="text" name="trigger_time" id="trigger-time" class="form-control default-timepicker" placeholder="Select Time" required="" />
                            <div class="input-group-append" data-target="#trigger-time">
                                <div class="input-group-text"><i class="fa fa-clock"></i></div>
                            </div>
                        </div>
                        <br />
                        <input type="hidden" name="campaign_id" id="activate_campaign_id" value="<?php echo $campaign_id; ?>">
                        <input type="hidden" name="timezone" value="<?php echo $member['timezone']; ?>">
                        <button type="submit" class="btn btn-primary btn-lg btn-activate-campaign">Activate Campaign</button>
                        <button type="button" class="btn btn-primary btn-lg btn-add-time-now">Time Now</button>
                      </div>
                    </div>
                    </form>
                    <?php

                  }
                  else
                  {

                    ?>
                    <h5>Create a new campaign</h5>
                    <nav aria-label="breadcrumb">
                      <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a class="campaign_step1" href="javascript:void(0);" >Configure Campaign</a></li>
                        <li class="breadcrumb-item"><a class="campaign_step2" href="javascript:void(0);" >Choose Recipients</a></li>
                        <li class="breadcrumb-item"><a class="campaign_step3" href="javascript:void(0);" >Compose Emails</a></li>
                        <li class="breadcrumb-item"><a class="campaign_step3" href="javascript:void(0);" >Preview</a></li>
                        <li class="breadcrumb-item"><a class="campaign_step3" href="javascript:void(0);" >Activate</a></li>
                      </ol>
                    </nav>

                    <form action="" method="post">
                      <div class="card shadow mb-4" id="step_1">
                        <div class="card-header bg-dark py-3">
                          <h6 class="m-0 font-weight-bold text-white">Configure Campaign</h6>
                        </div>
                        <div class="card-body">
                          <label style="display: block; margin-top: 10px;">Name</label>
                          <input type="text" name="name" class="form-control" placeholder="Name of this campaign" autocomplete="off">
                          <label style="display: block; margin-top: 10px;">Sending account</label>
                          <select name="send_with" id="send_with" class="form-control">
                            <?php
                            $q = $pdo->prepare('SELECT * FROM `gmail_accounts` WHERE `member_id`=?');
                            $q->execute(array($member['id']));
                            foreach ($q as $row) {
                              echo '<option value="gmail:'.$row['id'].'">Gmail: '.$row['email'].'</option>';
                            }
                            ?>
                            <?php
                            $q = $pdo->prepare('SELECT * FROM `smtp` WHERE `member_id`=?');
                            $q->execute(array($member['id']));
                            foreach ($q as $row) {
                              echo '<option value="smtp:'.$row['id'].'">SMTP: '.$row['from_email'].' - '.$row['server'].'</option>';
                            }
                            ?>
                          </select>
                          <label style="display: block; margin-top: 10px;">BCC <small>(optional) - If you fill out this field all emails sent from this campaign will be sent to this email address too.</small></label>
                          <input type="text" name="bcc" class="form-control" placeholder="BCC Email" autocomplete="off"><br />

                          <label style="display: block; margin-top: 10px;">Stop sending emails to a contact when:</label>
                          <select name="stop_at" id="stop_at" class="form-control">
                            <option value="">Campaign is finished</option>
                            <!-- <option value="open">Email has been opened</option> -->
                            <option value="reply">Email has a reply</option>
                          </select>                                                    
                          <br/>
                          <button class="btn btn-primary" type="button" id="to_step_2">Next: Choose Recipients</button>
                          <hr>
                        </div>
                      </div>

                      <div class="card shadow mb-4" id="step_2" style="display: none;">
                        <div class="campaign-smtp-verify-msg"></div>

                        <div class="card-header bg-dark py-3">
                          <h6 class="m-0 font-weight-bold text-white">Choose Recipients</h6>
                        </div>
                        <div class="card-body">
                          <label style="display: block; margin-top: 10px;">Select list</label>
                          <select name="list" class="form-control">
                            <?php
                            $q = $pdo->prepare('SELECT * FROM `lists` WHERE `member_id`=?');
                            $q->execute(array($member['id']));
                            foreach ($q as $row) {



                              echo '<option value="'.$row['id'].'">'.$row['name'].' - '.$row['total_contacts'].' contacts</option>';
                            }
                            ?>
                          </select>
                          <br/>
                          <button class="btn btn-primary" type="button" id="to_step_3">Next: Compose Emails</button>
                          <hr>
                        </div>
                      </div>

                      <div class="card shadow mb-4" id="step_3" style="display: none;">
                        <div class="card-header bg-dark py-3">
                          <h6 class="m-0 font-weight-bold text-white">Email 1</h6>
                        </div>
                        <div class="card-body">
                          <?php
                          $q = $pdo->prepare('SELECT * FROM `templates` WHERE `member_id`=?');
                          $q->execute(array($member['id']));
                          ?>
                          
                          <div class="float-left" style="padding-top: 15px;">
                            <label style="display: block; margin-top: 10px;">Subject</label>
                          </div>                          
                          <div class="clearfix"></div>
                          <input type="text" name="subject[]" class="form-control input-subject-0">
                          <div class="form-check form-check-inline" style="margin-top: 12px;">
                            <input class="form-check-input chk-send-weekend" data-key=0 type="checkbox" id="campaign_send_weekend" value="1">
                            <input class="hidden-chk-value-0" type="hidden" name="send_weekend[]" value="0">
                            <label class="form-check-label" for="campaign_send_weekend">Send emails on weekends</label>
                          </div>
                          <br />
                          <div class="float-left" style="padding-top: 15px;">
                            <label style="display: block; margin-top: 10px;">Body</label>
                            <?php if($q->rowcount()>0){?>
                              <div class="float-left">
                                <a href="javascript:void(0)" class="campaign-toggle-template" data-key="0">Use Template</a>
                                <div class="grp-template-0" style="display: none;">
                                  <table style="margin-top: 10px;">
                                    <tr>
                                      <td>
                                        <select attr-template class="form-control campaign-template-0">
                                          <?php
                                          foreach ($q as $row) {
                                            echo '<option value="'.$row['id'].'">'.$row['name'].'</option>';
                                          }
                                          ?>
                                        </select>
                                      </td>
                                      <td>
                                        <button class="btn-primary btn" data-key="0" type="button" attr-update-template>Use</button>
                                      </td>
                                    </tr>
                                  </table>
                                </div>
                              </div>
                              <div class="clearfix"></div>
                            <?php } ?>                            
                          </div>
                          <div class="float-right">
                            <table style="margin-top: 10px;">
                              <tr>
                                <td>
                                  Add custom field
                                </td>
                                <td>
                                  <select attr-tags class="form-control custom-field"></select>                                  
                                </td>
                                <td>
                                  <select class="form-control subject-content-0">
                                    <option value="content">Add to Content</option>
                                    <option value="subject">Add to Subject</option>
                                  </select>
                                </td>
                                <td>
                                  <button attr-add-tag class="btn btn-primary" data-key=0 type="button">Add</button>
                                </td>
                              </tr>
                            </table>
                          </div>
                          <div class="clearfix"></div>
                          <textarea name="body[]" class="form-control campaign-body-0" rows="7"></textarea>
                          <input type="hidden" name="datetime[]">
                          <input type="hidden" name="days_after[]">
                          <input type="hidden" name="days_after_time[]">
                          <input type="hidden" name="email_number[]" value="1">
                          <input type="hidden" name="trigger[]">
                          <input type="hidden" name="link[]">
                          <br/>
                        </div>
                      </div>

                      <div id="others"></div>

                      <table class="table" id="step_3a" style="display: none;">
                        <tr>
                          <td>
                            <button class="btn btn-dark" type="button" attr-another-email>Add Follow-up or Drip email</button>
                          </td>
                          <td>
                            Follow-ups to your initial message to ensure your recipients engage with your emails.
                          </td>
                        </tr>
                      </table>

                      <div class="card shadow mb-4" id="step_3b" style="display: none;">
                        <div class="card-body text-center">
                          <button class="btn btn-primary btn-lg" type="submit">Preview Campaign</button>
                        </div>
                      </div>
                    </form>

                    <?php
                    }
                    break;
                  
                  default:
                    # code...
                    break;
                }
              }
              else
              {

                if(@$_SEO[2] == 'activate')
                {

                  echo '
                  <div class="alert alert-success" role="alert">
                    A campaign has been successfully activated.
                  </div>
                  ';

                  $q = $pdo->prepare('UPDATE `campaigns` SET `status`= ' . CAMPAIGN_STATUS_RUNNING . ' WHERE `member_id`=? AND `id`=?');
                  $q->execute(array($member['id'], $_GET['id']));

                }

                if(@$_SEO[2] == 'deactivate')
                {                  
                  echo '
                  <div class="alert alert-success" role="alert">
                    A campaign has been successfully deactivated.
                  </div>
                  ';

                  $q = $pdo->prepare('UPDATE `campaigns` SET `status`= ' . CAMPAIGN_STATUS_PAUSED . ' WHERE `member_id`=? AND `id`=?');
                  $q->execute(array($member['id'], $_GET['id']));

                }

                $q = $pdo->prepare('SELECT * FROM `lists` WHERE `member_id`=?');
                $q->execute(array($member['id']));
                if($q->rowcount()<1)
                {
                  echo '
                  <div class="alert alert-warning" role="alert">
                    To start a campaign first <a href="'.$root.'/lists/create">create a list</a> and add some contacts.
                  </div>
                  ';
                }
                //else {
                  //echo '
                  // <div class="card shadow mb-4">
                  //   <div class="card-body">
                  //     Schedule emails, send follow ups, and more...
                  //     <br/>
                  //     <a class="btn btn-primary" style="margin-top: 15px;" href="'.$root.'/new-campaign">Create a new campaign</a>
                  //   </div>
                  // </div>
                  //';
                //}

                ?>

              <div class="row">
                <div class="col-lg-12">
                  <!-- Area Chart -->
                  <!-- <h4>ACTIVE CAMPAIGNS</h4> -->
                  <div class="dataTables_wrapper">

                    <table class="table datatable">
                      <thead>
                        <tr>
                          <th>Name</th>
                          <th>Created</th>
                          <th>Emails</th>
                          <th>Replies</th>
                          <th>Opens</th>
                          <th>Bounces</th>
                          <th>Status</th>
                          <th>Action</th>
                        </tr>
                      </thead>
                      <tbody>
                        <?php
                        if( $member['account_type'] == 1 ){

                          $subAccountEmails = $pdo->prepare('SELECT * FROM `sub_account_emails` WHERE `member_id`=?');
                          $subAccountEmails->execute(array($member['id']));
                          $subAccounts = array();
                          $string_sub_accounts = '';
                          foreach( $subAccountEmails as $s ){
                            $subAccounts[] = "'" . strtolower($s['type'].":".$s['email_id']) . "'"; 
                          }
                          $string_sub_accounts = implode(",", $subAccounts);
                          $q = $pdo->prepare('SELECT * FROM `campaigns` WHERE (`member_id`=? AND `status`=?) OR (`sending_account` IN('.$string_sub_accounts.') AND `status`=?)');
                          $q->execute(array($member['id'], CAMPAIGN_STATUS_RUNNING, CAMPAIGN_STATUS_RUNNING));
                        }else{
                          $q = $pdo->prepare('SELECT * FROM `campaigns` WHERE `member_id`=? AND `status`=? ');
                          $q->execute(array($member['id'], CAMPAIGN_STATUS_RUNNING));
                        }
                        
                        foreach ($q as $row) {

                          $data = $pdo->prepare('SELECT * FROM `lists` WHERE `id`=?');
                          $data->execute(array($row['list']));
                          $list = $data->fetch(PDO::FETCH_ASSOC);

                          $emails = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `campaign_id`=?');
                          $emails->execute(array($row['id']));

                          $opened = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `campaign_id`=? AND `opened`=1');
                          $opened->execute(array($row['id']));

                          $replies = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `campaign_id`=? AND `replied`=1');
                          $replies->execute(array($row['id']));

                          $bounces = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `campaign_id`=? AND `bounced`=1');
                          $bounces->execute(array($row['id']));

                          $trigger_date = "---";
                          if( $row['trigger_date'] > 0 ){
                            $trigger_date = date('M j, Y h:i A', $row['trigger_date']);
                          }

                          if( in_array("edit", $campaign_roles) || $member['account_type'] == 0 ){
                            $edit_action = '<a href="'.$root.'/edit-campaign/'.$row['id'].'/'.seo($row['name']).'">'.$row['name'].'</a>';
                          }else{
                            $edit_action = $row['name'];
                          }

                          echo '
                          <tr>
                            <td>'.$edit_action.'</td>
                            <td>'.date('M j, Y h:i A', $row['created']).'</td>
                            <td>'.$emails->rowcount().'</td>
                            <td>'.$replies->rowcount().'</td>
                            <td>'.$opened->rowcount().'</td>
                            <td>'.$bounces->rowcount().'</td>';
                            if($row['status'] == CAMPAIGN_STATUS_RUNNING){
                               $stats = '<span class="text-success">&bull; Active</span>';
                            }else{
                               $stats = ReturnCampaignStatusText($row['status']);
                            }
                            echo '<td>'.$stats.'</td>
                            <td>

                            

                            <div class="btn-group">
                              <button type="button" class="btn btn-default btn-sm dropdown-toggle no-caret" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fas fa-ellipsis-h"></i></button>
                              <div class="dropdown-menu dropdown-menu-right">
                                <a href="'.$root.'/reports/'.$row['id'].'" class="dropdown-item">Reports</a>
                                ';
                                /*if($row['status'] == 'paused')
                                {
                                  echo '<a href="'.$root.'/campaigns/activate/?id='.$row['id'].'" class="btn btn-success btn-sm mb-2">Activate</a>';
                                }*/
                                if( in_array("start", $campaign_roles) || $member['account_type'] == 0 ){
                                echo '<a href="'.$root.'/campaigns/deactivate/?id='.$row['id'].'" class="dropdown-item text-danger"><i class="fas fa-toggle-off"></i> Deactivate</a>';
                                }
                                echo '
                                <div class="dropdown-divider"></div>
                                <a href="'.$root.'/campaigns/?remove='.$row['id'].'" class="dropdown-item text-danger" onclick="return confirm(\'Confirm deletion of '.$row['name'].'?\')"><i class="fas fa-trash-alt"></i> Delete</a>
                              </div>
                            </div>



                              
                            </td>
                          </tr>
                          ';
                        }
                        ?>
                      </tbody>
                    </table>

                  </div>

                </div>
              </div>

              <div class="row">
                <div class="col-lg-12">
                  <!-- Area Chart -->
                  <h4>INACTIVE CAMPAIGNS</h4>

                  <div class="dataTables_wrapper">

                    <table class="table datatable">
                      <thead>
                        <tr>
                          <th>Name</th>
                          <th>Created</th>
                          <th>Emails</th>
                          <th>Replies</th>
                          <th>Opens</th>
                          <th>Bounces</th>
                          <th>STATUS</th>
                          <th>ACTION</th>
                        </tr>
                      </thead>
                      <tbody>
                        <?php
                        if( $member['account_type'] == 1 ){
                          $subAccountEmails = $pdo->prepare('SELECT * FROM `sub_account_emails` WHERE `member_id`=?');
                          $subAccountEmails->execute(array($member['id']));
                          $subAccounts = array();
                          $string_sub_accounts = '';
                          foreach( $subAccountEmails as $s ){
                            $subAccounts[] = "'" . strtolower($s['type'].":".$s['email_id']) . "'"; 
                          }
                          $string_sub_accounts = implode(",", $subAccounts);
                          $q = $pdo->prepare('SELECT * FROM `campaigns` WHERE (`member_id`=? AND `status`=?) OR (`sending_account` IN('.$string_sub_accounts.') AND `status`=?)');
                          $q->execute(array($member['id'], CAMPAIGN_STATUS_PAUSED, CAMPAIGN_STATUS_PAUSED));

                        }else{
                          $q = $pdo->prepare('SELECT * FROM `campaigns` WHERE `member_id`=? AND `status`=?');
                          $q->execute(array($member['id'], CAMPAIGN_STATUS_PAUSED));
                        }
                        
                        foreach ($q as $row) {

                          $data = $pdo->prepare('SELECT * FROM `lists` WHERE `id`=?');
                          $data->execute(array($row['list']));
                          $list = $data->fetch(PDO::FETCH_ASSOC);

                          $emails = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `campaign_id`=?');
                          $emails->execute(array($row['id']));

                          $opened = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `campaign_id`=? AND `opened`=1');
                          $opened->execute(array($row['id']));

                          $replies = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `campaign_id`=? AND `replied`=1');
                          $replies->execute(array($row['id']));

                          $bounces = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `campaign_id`=? AND `bounced`=1');
                          $bounces->execute(array($row['id']));

                          $trigger_date = "---";
                          if( $row['trigger_date'] > 0 ){
                            $trigger_date = date('M j, Y h:i A', $row['trigger_date']);
                          }

                          echo '
                          <tr>
                            <td><a href="'.$root.'/edit-campaign/'.$row['id'].'/'.seo($row['name']).'">'.$row['name'].'</a></td>
                            <td>'.date('M j, Y h:i A', $row['created']).'</td>
                            <td>'.$emails->rowcount().'</td>
                            <td>'.$replies->rowcount().'</td>
                            <td>'.$opened->rowcount().'</td>
                            <td>'.$bounces->rowcount().'</td>';
                            if($row['status'] == CAMPAIGN_STATUS_RUNNING){
                               $stats = '<span class="text-success">&bull; Active</span>';
                            }else{
                               $stats = ReturnCampaignStatusText($row['status']);
                            }
                            echo '<td>'.$stats.'</td>
                            <td>
                            <div class="btn-group">
                              <button type="button" class="btn btn-default btn-sm dropdown-toggle no-caret" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="fas fa-ellipsis-h"></i></button>
                              <div class="dropdown-menu dropdown-menu-right">
                                <a href="'.$root.'/reports/'.$row['id'].'" class="dropdown-item">Reports</a>
                                ';
                                if($row['status'] == CAMPAIGN_STATUS_PAUSED)
                                {
                                  if( in_array("start", $campaign_roles) || $member['account_type'] == 0 ){
                                    echo '<a href="'.$root.'/campaigns/activate/?id='.$row['id'].'" class="dropdown-item text-success"><i class="fas fa-toggle-on"></i> Activate</a>';
                                  }
                                }
                                echo '

                                <div class="dropdown-divider"></div>
                                <a href="'.$root.'/campaigns/?remove='.$row['id'].'" class="dropdown-item text-danger" onclick="return confirm(\'Confirm deletion of '.$row['name'].'?\')"><i class="fas fa-trash-alt"></i> Delete</a>
                              </div>
                            </div>
                            </td>
                          </tr>
                          ';
                        }
                        ?>
                      </tbody>
                    </table>

                  </div>
                </div>
              </div>
                <?php
              }
              ?>

            </div>

          </div>

        </div>
        <!-- /.container-fluid -->

      </div>
      <!-- End of Main Content -->

      <!-- Footer -->
      <footer class="sticky-footer bg-white">
        <div class="container my-auto">
          <div class="copyright text-center my-auto">
            <span>Copyright &copy; <?php echo date('Y'); ?></span>
          </div>
        </div>
      </footer>
      <!-- End of Footer -->

    </div>
    <!-- End of Content Wrapper -->

  </div>
  <!-- End of Page Wrapper -->

  <!-- Scroll to Top Button-->
  <a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
  </a>