<title><?php echo SITE_NAME; ?> - Dashboard</title>
<style>
    .list-smtp-error th{
        font-size: 15px;
    }
    .list-smtp-error td{
        font-size: 14px;
    }
</style>
</head>

<body id="page-top">
<!-- Page Wrapper -->
<div id="wrapper">

    <?php include_once("nav_wrapper.php"); ?>

    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column">

        <!-- Main Content -->
        <div id="content">

            <!-- Topbar Navbar -->
            <?php include_once("nav/right_nav.php"); ?>


            <!-- End of Topbar -->

            <!-- Begin Page Content -->
            <div class="container-fluid dashboard">

                <!-- Page Heading -->
                <h1 class="panel-title float-left">Dashboard</h1>
                <div class="float-right">
                    <a class="btn btn-light btn-sm" href="<?php echo $root; ?>/dashboard/?chart=today">Today</a>
                    <a class="btn btn-light btn-sm" href="<?php echo $root; ?>/dashboard/?chart=last_7">Last 7 days</a>
                    <a class="btn btn-light btn-sm" href="<?php echo $root; ?>/dashboard/?chart=last_14">Last 14 days</a>
                    <a class="btn btn-light btn-sm" href="<?php echo $root; ?>/dashboard/?chart=last_30">Last 30 days</a>
                    <a class="btn btn-light btn-sm" href="<?php echo $root; ?>/dashboard">View All</a>
                </div>
                <div class="clearfix"></div>
                <?php
                date_default_timezone_set($member['timezone']);
                if( isset($_POST['stat_counter_date_from']) && isset($_POST['stat_counter_date_to']) ){
                    $date_from = strtotime($_POST['stat_counter_date_from']);
                    $date_to   = strtotime($_POST['stat_counter_date_to']);

                    $emails = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `member_id`=? AND `last_activity`>=? AND `last_activity`<=?');
                    $emails->execute(array($member['id'], $date_from, $date_to));

                    $opened = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `member_id`=? AND `opened`=1 AND `last_activity`>=? AND `last_activity`<=?');
                    $opened->execute(array($member['id'], $date_from, $date_to));

                    $replies = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `member_id`=? AND `replied`=1 AND `last_activity`>=? AND `last_activity`<=? AND `id` NOT IN (SELECT `sent_mail_id` FROM auto_replies WHERE `member_id`=?)');
                    $replies->execute(array($member['id'], $date_from, $date_to, $member['id']));

                    $bounced = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `member_id`=? AND `bounced`=1 AND `last_activity`>=? AND `last_activity`<=?');
                    $bounced->execute(array($member['id'], $date_from, $date_to));

                    $clicks  = $pdo->prepare('SELECT m.id, m.identifier, m.link FROM (`links_clicked` as m)
                    LEFT JOIN sent_mails as s ON (s.identifier = m.identifier) WHERE s.member_id =? AND `last_activity`>=? AND `last_activity`<=?' );
                    $clicks->execute(array($member['id'], $date_from, $date_to));
                    $click_count = $clicks->rowcount();

                    $stat_counter_date = date("F j, Y", $date_from) . ' to ' . date("F j, Y", $date_to);

                }else{
                    if( isset($_GET['chart']) ){

                        switch ($_GET['chart']) {
                            case 'last_7':
                                $date_from = strtotime("-7 days");
                                $stat_counter_date = date("F j, Y",strtotime("-7 days"));
                                break;
                            case 'last_14':
                                $date_from = strtotime("-14 days");
                                $stat_counter_date = date("F j, Y",strtotime("-14 days"));
                                break;
                            case 'last_30':
                                $date_from = strtotime("-30 days");
                                $stat_counter_date = date("F j, Y",strtotime("-30 days"));
                                break;
                            case 'today':
                                $date_from = strtotime(date("Y-m-d"));
                                //$stat_counter_date = date("F j, Y",strtotime("-30 days"));
                                break;
                            default:
                                $date_from = strtotime(date("Y-m-d"));
                                $stat_counter_date = date("F j, Y");
                                break;
                        }

                        $date_to   = strtotime(date("Y-m-d H:i:s"));
                        $emails = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `member_id`=? AND `last_activity`>=?');
                        $emails->execute(array($member['id'], $date_from));

                        $opened = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `member_id`=? AND `opened`=1 AND `last_activity`>=? AND `last_activity`<=?');
                        $opened->execute(array($member['id'], $date_from, $date_to));

                        $replies = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `member_id`=? AND `replied`=1 AND `last_activity`>=? AND `last_activity`<=? AND `id` NOT IN (SELECT `sent_mail_id` FROM auto_replies WHERE `member_id`=?)');
                        $replies->execute(array($member['id'], $date_from, $date_to, $member['id']));

                        $bounced = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `member_id`=? AND `bounced`=1 AND `last_activity`>=? AND `last_activity`<=?');
                        $bounced->execute(array($member['id'], $date_from, $date_to));

                        $clicks  = $pdo->prepare('SELECT m.id, m.identifier, m.link FROM (`links_clicked` as m)
                        LEFT JOIN sent_mails as s ON (s.identifier = m.identifier) WHERE s.member_id =? AND `last_activity`>=? AND `last_activity`<=?' );
                        $clicks->execute(array($member['id'], $date_from, $date_to));
                        $click_count = $clicks->rowcount();

                    }else{
                        $emails = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `member_id`=?');
                        $emails->execute(array($member['id']));

                        $opened = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `member_id`=? AND `opened`=1');
                        $opened->execute(array($member['id']));

                        $replies = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `member_id`=? AND `replied`=1 AND `id` NOT IN (SELECT `sent_mail_id` FROM auto_replies WHERE `member_id`=?)');
                        $replies->execute(array($member['id'],$member['id']));

                        $bounced = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `member_id`=? AND `bounced`=1');
                        $bounced->execute(array($member['id']));

                        $clicks  = $pdo->prepare('SELECT m.id, m.identifier, m.link FROM (`links_clicked` as m)
                        LEFT JOIN sent_mails as s ON (s.identifier = m.identifier) WHERE s.member_id =?');
                        $clicks->execute(array($member['id']));
                        $click_count = $clicks->rowcount();

                        $stat_counter_date = date("F j, Y");
                    }

                }
                ?>
                <!-- <div class="row">
            <div class="col-lg-12" style="padding-left: 2px;">
              <div class="card shadow mb-4">
                <div class="card-header bg-dark py-3">
                  <div class="float-left">
                    <h6 class="">Stat counter as of <?php echo $stat_counter_date; ?></h6>
                  </div>
                  <div class="float-right">
                    <div class="dropdown">
                        <button class="btn btn-primary dropdown-toggle" type="button" id="drpdwn" data-toggle="dropdown" aria-expanded="true">
                            Show Stat Counter By <span class="caret"></span>
                        </button>
                        <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                            <a class="dropdown-item" href="javascript:void(0);" data-toggle="modal" data-target="#stat-counter-by-date"><i class="fa fa-calendar"></i> Stat Counter By Date</a>
                            <a class="dropdown-item" href="<?php echo $root . "/dashboard"; ?>"><i class="fa fa-calendar"></i> Latest Stat Counter</a>
                        </div>
                    </div>


                  </div>
                  <div class="clearfix"></div>
                </div>
              </div>
            </div>
          </div> -->

                <div class="modal fade" id="stat-counter-by-date" tabindex="-1" role="dialog" aria-labelledby="addLabel" aria-hidden="true">
                    <div class="modal-dialog modal-lg" role="document" style="margin-top: 10vw;">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="addLabel">Stat Counter By Date</h5>
                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                            <div class="modal-body">
                                <form action="" method="post" id="">
                                    <input type="hidden" name="action" value="add">
                                    <div class="modal-add-smtp-msg"></div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <label style="display: block; margin-top: 10px;">Date From: *</label>
                                            <input type="text" name="stat_counter_date_from" required="" placeholder="Select Date" class="form-control default-datepicker">
                                        </div>
                                        <div class="col-md-6">
                                            <label style="display: block; margin-top: 10px;">Date To: *</label>
                                            <input type="text" name="stat_counter_date_to" required="" placeholder="Select Date" class="form-control default-datepicker">
                                        </div>
                                        <div class="col-sm-12">
                                            <br/>
                                            <button type="submit" class="btn btn-primary">Filter</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row cards-row blocks_row">

                    <!-- Earnings (Monthly) Card Example -->
                    <div class="col-xl col-lg-3 col-md-6 col-sm-12 mb-4">
                        <div class="card total-sent">
                            <div class="card-body pt-0">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="label">Total Sent</div>
                                        <div class="h1 mb-0"><?php echo number_format($emails->rowcount()); ?></div>
                                    </div>
                                    <div class="col-auto">
                                        <img src="<?php echo $root; ?>/img/icon-feather-send.svg" width="" height="" alt="">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Earnings (Monthly) Card Example -->
                    <div class="col-xl col-lg-3 col-md-6 col-sm-12 mb-4">
                        <div class="card total-opened">
                            <div class="card-body pt-0">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="label">Total Opened</div>
                                        <div class="h1 mb-0"><?php echo  number_format($opened->rowcount()); ?></div>
                                    </div>
                                    <div class="col-auto">
                                        <img src="<?php echo $root; ?>/img/icon-feather-mail.svg" width="" height="" alt="">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Earnings (Monthly) Card Example -->
                    <div class="col-xl col-lg-3 col-md-6 col-sm-12 mb-4">
                        <div class="card total-opened">
                            <div class="card-body pt-0">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="label">Total Clicks</div>
                                        <div class="h1 mb-0"><?php echo  $click_count; ?></div>
                                    </div>
                                    <div class="col-auto">
                                        <img src="<?php echo $root; ?>/img/icon-feather-mail.svg" width="" height="" alt="">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Earnings (Monthly) Card Example -->
                    <div class="col-xl col-lg-3 col-md-6 col-sm-12 mb-4">
                        <div class="card total-replies">
                            <div class="card-body pt-0">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="label">Total Replies</div>
                                        <div class="h1 mb-0"><?php echo  number_format($replies->rowcount()); ?></div>
                                    </div>
                                    <div class="col-auto">
                                        <img src="<?php echo $root; ?>/img/icon-material-reply-all.svg" width="" height="" alt="">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Earnings (Monthly) Card Example -->
                    <div class="col-xl col-lg-3 col-md-6 col-sm-12 mb-4">
                        <div class="card total-replies">
                            <div class="card-body pt-0">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="label">Bounced</div>
                                        <div class="h1 mb-0"><?php echo  number_format($bounced->rowcount()); ?></div>
                                    </div>
                                    <div class="col-auto">
                                        <img src="<?php echo $root; ?>/img/icon-material-reply-all.svg" width="" height="" alt="">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>



                </div>

                <div class="row widgets-row">


                    <div class="col-lg-8 col-md-6">
                        <!-- Area Chart -->
                        <div class="card shadow mb-4">
                            <div class="card-header bg-dark py-3">
                                <div class="float-left">
                                    <h6 class="">Overview</h6>
                                </div>
                                <!-- <div class="float-right">
                    <a class="btn btn-light btn-sm" href="<?php echo $root; ?>/dashboard/?chart=last_7">Last 7 days</a>
                    <a class="btn btn-light btn-sm" href="<?php echo $root; ?>/dashboard/?chart=last_14">Last 14 days</a>
                    <a class="btn btn-light btn-sm" href="<?php echo $root; ?>/dashboard/?chart=last_30">Last 30 days</a>
                  </div> -->
                                <div class="clearfix"></div>
                            </div>
                            <div class="card-body">
                                <canvas id="overviewChart" width="100%" height="400" style="max-height: 550px;"></canvas>
                                <hr>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-md-6">
                        <div class="card activity-widget">
                            <div class="card-header bg-dark py-3">
                                <div class="float-left">
                                    <h6 class="">Recent activity</h6>
                                </div>
                                <div class="float-right">

                                </div>
                                <div class="clearfix"></div>
                            </div>
                            <div class="card-body" style="max-height: 593px; overflow-y: scroll;">
                                <?php
                                $q = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `member_id`=? ORDER BY `last_activity` DESC LIMIT 50');
                                $q->execute(array($member['id']));
                                foreach ($q as $row) {
                                    $campaigns = $pdo->prepare('SELECT * FROM `campaigns` WHERE `id`=? LIMIT 1');
                                    $campaigns->execute(array($row['campaign_id']));
                                    foreach ($campaigns as $campaign) {
                                        $campaign_name = $campaign['name'];
                                    }
                                    if($row['opened'] == 1)
                                    {
                                        $message = 'Email "'.$row['subject'].'" sent to '.$row['to_email'].' has been opened <span class="blue">'.time_elapsed_string('@'.$row['last_activity']).'</span>';
                                    }

                                    if($row['replied'] == 1)
                                    {

                                        $message = ''.$row['to_email'].' <span> REPLIED </span> to '.$row['subject'].' from campaign '.$campaign_name.' <span class="blue">'.time_elapsed_string('@'.$row['last_activity']).'</span>';

                                        // $message = 'Email "'.$row['subject'].'" sent to '.$row['to_email'].' has been replied to <span class="blue">'.time_elapsed_string('@'.$row['last_activity']).'</span>';
                                    }
                                    if($row['replied'] == 0 && $row['opened'] == 0)
                                    {
                                        $message =  'Email "'.$row['subject'].'" sent to '.$row['to_email'].' from '.$row['from_email'].' <span class="blue">'.time_elapsed_string('@'.$row['last_activity']).'</span>';
                                    }

                                    if($row['bounced'] == 1)
                                    {

                                        $message = ''.$row['to_email'].' <span> BOUNCED </span> to '.$row['subject'].' from campaign '.$campaign_name.' <span class="blue">'.time_elapsed_string('@'.$row['last_activity']).'</span>';

                                    }
                                    echo $message.'<hr/>';
                                }
                                if($q->rowcount()<1)
                                {
                                    echo '<p>No recent activity to display.</p>';
                                }
                                ?>
                            </div>
                        </div>
                    </div>

                </div>
                <?php
                if( isset($_POST['action']) ){

                    if( $_POST['action'] == 'delete-notification-messages' ){
                        // Delete All
                        $q = $pdo->prepare('DELETE FROM `notifications` WHERE `member_id`=? AND `module` = "smtp" ');
                        $q->execute(array($member['id']));

                        echo '
                        <div class="alert alert-success" role="alert">
                          All notification messages has been deleted!
                        </div>
                        ';
                    }
                }

                // This set the notifications to seen
                $q = $pdo->prepare('UPDATE `notifications` SET is_seen =? WHERE  `member_id`=?');
                $q->execute(array(1,$member['id']));

                ?>
                <!-- /.container-fluid -->
                <div class="row widgets-row">
                    <div class="col-lg-12 col-md-12">
                        <!-- Area Chart -->
                        <div class="card shadow mb-4">
                            <div class="card-header bg-dark py-3">
                                <div class="float-left">
                                    <h6 class="">SMTP ERROR <a class="btn-clear-notification btn-info btn" href="javascript:void(0);" style="font-size: 12px;position: relative;top: -6px;padding: 4px;left: 11px;">Clear Notification</a></h1></h6>
                                </div>
                                <div class="clearfix"></div>
                            </div>
                            <div class="card-body">
                                <?php
                                $q = $pdo->prepare('SELECT * FROM `notifications` WHERE `member_id`=? AND `module`=? ORDER BY `date_time` DESC LIMIT 50');
                                $q->execute(array($member['id'],'smtp'));

                                // $logs = array();
                                // foreach ($q as $row) {
                                //     $smtp = json_decode($row['data']);
                                //     $logs[] = array('email' => $smtp->username, 'server' => $smtp->server, 'port' => $smtp->port, 'msg' => $row['message'], 'created' => $row['created']);
                                // }
                                ?>
                                <div class="dataTables_wrapper">

                                    <table class="table datatable">
                                        <thead>
                                        <tr>
                                            <th>MESSAGE</th>
                                            <th>CREATED</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        <?php  foreach ($q as $row) { ?>
                                            <tr>
                                                <td><?php echo $row['description']; ?></td>
                                                <td><?php echo date('m/d/Y h:i A', $row['date_time']); ?></td>
                                            </tr>
                                        <?php } ?>
                                        </tbody>
                                    </table>

                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Modal clear notification confirmation -->
            <div class="modal fade" id="modal-clear-notification" tabindex="-1" role="dialog" aria-labelledby="addLabel" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <form action="" method="post" class="frm-edit-gmail-<?php echo $email['id']; ?>">
                            <div class="modal-body">
                                <h4 class="modal-heading"><i class="fa fa-question"></i> Confirmation</h4>
                                <div class="row">
                                    <div class="col-md-12">
                                        <p>Do you wish to delete all notification messages?</p>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-default" data-dismiss="modal">No</button>
                                    <button type="submit" class="btn btn-danger" name="action" value="delete-notification-messages">Yes</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Modal SMTP notification confirmation -->
            <div class="modal fade modal-danger modal-enhanced" id="modal-smtp-notification" tabindex="-1" role="dialog" aria-labelledby="addLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <form action="" method="post" class="frm-edit-gmail-<?php echo $email['id']; ?>">
                            <div class="modal-body">
                                <h4 class="modal-heading">SMTP Error </h4>
                                <div class="row">
                                    <div class="col-md-12">
                                        <p style="font-size: 14px;">Please check this following email.</p>
                                        <table class="table datatable list-smtp-error">
                                            <thead>
                                            <tr>
                                                <th></th>
                                                <th>Email Account</th>
                                                <th>Date Added</th>

                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php
                                            $q = $pdo->prepare('SELECT * FROM `notifications` WHERE `member_id`=? AND `module`=? ORDER BY `date_time` DESC LIMIT 50');
                                            $q->execute(array($member['id'],'smtp'));

                                            foreach ($q as $row) {
                                                $notification = "";
                                                $to_find  = " -";
                                                $description = strpos($row['description'], $to_find);
                                                if ($description) {
                                                    $notification = strstr($row['description'], $to_find, true);
                                                }
                                                $row_actions = 'What happened?                                This error usually occurs when there is a problem with the connection from Automailer to your email. If you have recently changed your email password, make sure to update it in your Automailer account as well. If you have been experiencing a high bounce rate with your campaigns, your ESP could have temporarily restricted outbound emails from sending out. Please login into your email address directly and check if your outbound sending has been restricted. To re-fresh your connection, you may click on the “re-fresh” option under actions.';
                                                ?>
                                                <tr>
                                                    <td>
                                                        <span class="fa fa-question-circle help-tooltip" data-toggle="tooltip" data-placement="top" data-trigger="hover" data-original-title="<?php echo $row_actions; ?>" title="<?php echo $row_actions; ?>" style="margin-left: 10px;"></span>
                                                    </td>
                                                    <td><span class="help-tooltip" data-toggle="tooltip" data-placement="top" data-trigger="hover" data-original-title="<?php echo $row_actions; ?>" title="<?php echo $row_actions; ?>" style="margin-left: 10px;"><?php echo $notification; ?></span></td>
                                                    <td><?php echo date('m/d/Y h:i A', $row['date_time']); ?></td>

                                                </tr>
                                            <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                                <div class="modal-footer">

                                    <button type="submit" class="btn btn-danger" name="action" value="delete-notification-messages">Clear Notification</button>
                                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

        </div>
        <!-- End of Main Content -->

        <!-- Footer -->
        <footer class="sticky-footer bg-white">
            <div class="container my-auto">
                <div class="copyright text-center my-auto">
                    <span>Copyright &copy; <?php echo date('Y'); ?></span>
                </div>
            </div>
        </footer>
        <!-- End of Footer -->

    </div>
    <!-- End of Content Wrapper -->

</div>
<!-- End of Page Wrapper -->

<!-- Scroll to Top Button-->
<a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
</a>

<script>
    $(function(){
        $(".btn-clear-notification").click(function(){
            $("#modal-clear-notification").modal('show');
        });

        function show_smtp_error(){
            $("#modal-smtp-notification").modal('show');
        }

        <?php
        $q = $pdo->prepare('SELECT * FROM `notifications` WHERE `member_id`=? AND `module`=? ORDER BY `date_time` DESC LIMIT 50');
        $q->execute(array($member['id'],'smtp'));

        if($q->rowcount() > 0){ ?>
        show_smtp_error();
        <?php }
        ?>

    });



</script>