<title><?php echo SITE_NAME; ?> - View List</title>
</head>
<style>
    .dataTables_length, .dataTables_wrapper .dataTables_filter{
        display: block !important;
    }
    .cell-edit{
        color:#858796;
    }
    .cell-edit:hover, .cell-edit:visited, .cell-edit:link, .cell-edit:active
    {
        text-decoration: none;
    }
    .cell-input{
        width: 95% !important;
        height: 26px !important;
    }
    div.dataTables_wrapper div.dataTables_length select {
        width: 49%;
    }
    table.dataTable thead>tr>th.sorting_asc, table.dataTable thead>tr>th.sorting_desc, table.dataTable thead>tr>th.sorting, table.dataTable thead>tr>td.sorting_asc, table.dataTable thead>tr>td.sorting_desc, table.dataTable thead>tr>td.sorting {
        font-size: 14px;
    }
    .dataTables_wrapper .dataTables_scroll div.dataTables_scrollBody>table>thead>tr>th, .dataTables_wrapper .dataTables_scroll div.dataTables_scrollBody>table>thead>tr>td, .dataTables_wrapper .dataTables_scroll div.dataTables_scrollBody>table>tbody>tr>th, .dataTables_wrapper .dataTables_scroll div.dataTables_scrollBody>table>tbody>tr>td{
        font-size: 13px;
    }
    .list-email-duplicate{
        list-style: none;
        margin: 0px;
        padding: 0px;
        margin-left: 31px;
        margin-top: 27px;
    }
    .list-email-duplicate li{
        font-size:18px;
        margin-bottom: 12px;
    }
    .duplicate-email-container{
        margin-bottom: 23px;
        border-bottom: 1px solid;
    }
    .editable-cell{
        background-color: #ffffff;
        border: 1px solid #e3e6f0;
        padding: 5px;
    }
    .error-list{
        padding: 0px;
        font-size: 18px;
        margin: 12px
    }

    .img-duplicate, .img-delete{
        margin: 0 auto;
        display: block;
        height: 127px;
    }
    .hdr-duplicate, .hdr-delete{
        width: 100%;
        text-align: center;
        font-size: 25px;
        margin: 29px 0px;
    }

</style>
<body id="page-top">
<!-- Page Wrapper -->
<div id="wrapper">

    <?php include_once("nav_wrapper.php"); ?>

    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column">

        <!-- Main Content -->
        <div id="content">

            <!-- Topbar Navbar -->
            <?php include_once("nav/right_nav.php"); ?>

            <!-- Begin Page Content -->
            <div class="container-fluid email-accounts dashboard">

                <a class="btn-default btn btn-back btn-sm" href="<?php echo $root.'/lists'; ?>"><i class="fas fa-chevron-left"></i> Back</a>

                <?php
                $error_code  = '';
                $action_msg = '';

                if(isset($_POST['action']) == 'send-list-cleaner'){

                    require_once 'config.php';
                    require_once 'functions.php';
                    require_once 'ApiMailClickConvert.php';

                    $total_sent = 0;

                    $list_id = $_POST['lid'];
                    $contacts = $pdo->prepare("SELECT * FROM `contacts` WHERE list_id = $list_id"); //Unverified status
                    $contacts->execute();

                    if( $contacts->rowcount() > 0 ){
                        $file = 'csv/automailer_list_' . $list_id . '.csv';
                        $csv_handler = fopen($file,'w');

                        $csv = "firstname,lastname,email \n";
                        fwrite ($csv_handler,$csv);

                        foreach( $contacts as $contact ){
                            $csv = $contact['firstName'] . "," . $contact['lastName'] . "," . $contact['email'] . "\n";
                            fwrite ($csv_handler,$csv);
                            $total_sent++;
                        }

                        fclose ($csv_handler);

                        $url = $root. '/'. $file;

                        $mailClick = new ApiMailClickConvert();
                        $mailClickResponse = $mailClick->uploadlistbyurl($url);
                        if( $mailClickResponse->listid > 0 ){
                            //Insert list id
                            $data_mail_click_list = array(
                                NULL,
                                $member['id'],
                                $mailClickResponse->importid,
                                $mailClickResponse->listid,
                                $list_id,
                                $mailClickResponse->status,
                                0,
                                0,
                                time()
                            );
                            $q = $pdo->prepare('INSERT INTO `mail_click_convert_list` VALUES (?,?,?,?,?,?,?,?,?)');
                            $q->execute($data_mail_click_list);
                        }
                    }

                    $credit_to_use = $_POST['credit_to_use'];
                    $remaining_credits = $_POST['remaining_credits'];
                    $updated_cleaning_credit = $remaining_credits - $credit_to_use;
                    $q = $pdo->prepare('UPDATE `members` SET `cleaning_credits`=? WHERE `id`=?');
                    $q->execute(array($updated_cleaning_credit,  $member['id']));
                    $member['cleaning_credits'] = $updated_cleaning_credit;

                    echo '
              <div class="alert alert-success" role="alert">
                Total sent contacts for cleaning : '.$total_sent.'
              </div>
              ';
                }


                if( isset($_POST['add_contact_list_id']) ){
                    $email_checker = $pdo->prepare('SELECT * FROM `contacts` WHERE `list_id`=? AND `email`=?');
                    $email_checker->execute(array($_POST['add_contact_list_id'],$_POST['email']));
                    if($email_checker->rowcount()<1){

                        if (empty($_POST['data']))
                            $_POST['data'] = '';

                        list($username, $domain) = explode('@', $_POST['email']);

                        // Check if dns entry is cached
                        if (!empty($domain))
                        {
                            if (checkdnsrr($domain, 'MX'))
                            {
                                $status = 1;
                            } else {
                                $status = 2;
                            }
                        }

                        $q = $pdo->prepare('INSERT INTO `contacts` (list_id,firstName,lastName,email,data,status,mailclick_status)  VALUES (?,?,?,?,?,?,?)');
                        $q->execute(array($_POST['add_contact_list_id'], $_POST['firstName'], $_POST['lastName'], $_POST['email'], json_encode($_POST['data']), $status, 'Unverified'));
                        $contact_id = $pdo->lastInsertId();
                        //  print_r($q->errorInfo());

                        $action_msg = '
                <div class="alert alert-success" role="alert">
                  Contact '.$_POST['firstName'].' has been added.
                </div>
                ';

                        // recaculate the list totals
                        UpdateListTotals($_POST['add_contact_list_id']);

                    }else{
                        $action_msg = '
                <div class="alert alert-warning" role="alert">
                  Contact '.$_POST['email'].' already in the list. Cannot add duplicate email.
                </div>
                ';

                        // recaculate the list totals
                        UpdateListTotals($_POST['add_contact_list_id']);
                    }
                }

                if( isset($_POST['edit_contact_id']) ){
                    $q = $pdo->prepare('UPDATE `contacts` SET `firstName`=?, `lastName`=?, `email`=?, `data`=? WHERE `id`=?');
                    $q->execute(array($_POST['firstName'], $_POST['lastName'], $_POST['email'], json_encode($_POST['data']), $_POST['edit_contact_id']));

                    $action_msg = '
              <div class="alert alert-success" role="alert">
                Contact '.$_POST['firstName'].' has been updated.
              </div>
              ';
                }

                if( isset($_POST['delete_contact_id']) ){
                    $q = $pdo->prepare('DELETE FROM `contacts` WHERE `list_id`=? AND `id`=?');
                    $q->execute(array($_SEO[2], $_POST['delete_contact_id']));

                    $action_msg = '
              <div class="alert alert-success" role="alert">
                Contact was successfully deleted.
              </div>
              ';

                    // recaculate the list totals
                    UpdateListTotals($_SEO[2]);
                }



                $q = $pdo->prepare('SELECT * FROM `lists` WHERE `member_id`=? AND `id`=?');
                $q->execute(array($member['id'], $_SEO[2]));
                $list = $q->fetch(PDO::FETCH_ASSOC);
                if(!isset($list['member_id'])){
                    header('Location: '.$root.'/lists/');
                }


                /* if(isset($_GET['remove']))
                {

                  $q = $pdo->prepare('SELECT * FROM `contacts` WHERE `list_id`=?');
                  $q->execute(array($list['id']));
                  $contacts = $q->fetchAll();

                  if(count($contacts) == 1)
                  {
                    $q = $pdo->prepare('INSERT INTO `contacts` VALUES (?,?,?,?,?,?)');
                    $q->execute(array($_SEO[2], '', '', '', $contacts[0]['data'], NULL));
                  }

                  $q = $pdo->prepare('DELETE FROM `contacts` WHERE `list_id`=? AND `id`=?');
                  $q->execute(array($list['id'], $_GET['remove']));

                } */

                $_SESSION['dt_list_contact']['list_id'] = $list['id'];
                $q = $pdo->prepare('SELECT * FROM `contacts` WHERE list_id = '.$list['id'].'');
                $q->execute();
                $contacts = $q->fetchAll();
                // print_r($contacts);die;
                $contacts_count = $q->rowcount();
                ?>

                <?php

                $firstNameKey = '';
                $lastNameKey = '';
                $keys = array('emailKey' => '','firstNameKey' => '', 'lastNameKey' => '');


                if( isset($_POST['csvHeaderMap']) ){

                    foreach ($_POST['csvHeaderMap'] as $key => $value) {
                        if(strpos(strtolower($value), 'first name') !== false || strpos(strtolower($value), 'firstname') !== false){
                            $firstNameKey = $key;
                        }
                        if(strpos(strtolower($value), 'last name') !== false || strpos(strtolower($value), 'lastname') !== false){
                            $lastNameKey = $key;
                        }
                        if(strpos(strtolower($value), 'email') !== false || strpos(strtolower($value), 'e-mail') !== false || strpos(strtolower($value), 'emailaddress') !== false){
                            $emailKey = $key;
                        }

                        if(isset($firstNameKey)){
                            $keys = array(
                                'firstNameKey' => $firstNameKey,
                                'lastNameKey' => $lastNameKey,
                                'emailKey' => $emailKey
                            );
                        }
                    }

                    if ($keys['emailKey'] === '')
                        die("No email column assigned");


                    $count = 0;
                    $customFields = array();
                    $domainStatus = array();
                    $contactsData = array();
                    $contactsQuestionMarks = array();

                    foreach ($_SESSION['csv_data'] as $key => $value) {
                        if(!in_array($value[$_POST['emailkey']], $_POST['email_remove_dupplicate'])){
                            $data = array();
                            if(count($customFields)<1){
                                //  $customFields = $value;
                            }

                            if(strtolower($value[$keys['emailKey']]) !== 'email'){
                                foreach ($value as $valueKey => $field) {
                                    if(!in_array($valueKey, $keys))
                                    {
                                        $data[$customFields[$valueKey]] = $field;
                                    }
                                }

                                $email = $value[$keys['emailKey']];
                                $email = trim($email);

                                if (IsValidEmail($email) == false)
                                    $status = 2;
                                else
                                {

                                    list($username, $domain) = explode('@', $email);

                                    if (in_array($domain,array('gmail.com','yahoo.com','aol.com','outlook.com','live.com','rr.com','comcast.net','hotmail.com','cox.net','bellsouth.net')))
                                    {
                                        $status = 1;
                                        $domainStatus[$domain] =  $status;

                                    }

                                    // Check if dns entry is cached
                                    if (empty($domainStatus[$domain]))
                                    {
                                        if (checkdnsrr($domain, 'MX'))
                                        {
                                            $status = 1;
                                            $domainStatus[$domain] = $status;

                                        } else

                                        {
                                            $status = 2;
                                            $domainStatus[$domain] = $status;
                                        }
                                    } else
                                        $status = $domainStatus[$domain];

                                }


                                if (empty($value[$keys['firstNameKey']]))
                                    $value[$keys['firstNameKey']] = "";

                                if (empty($value[$keys['lastNameKey']]))
                                    $value[$keys['lastNameKey']] = "";

                                $condition = array(
                                    $list['id'],
                                    $value[$keys['emailKey']],
                                );


                                if($value[$keys['emailKey']] <> "")
                                {

                                    $contactsQuestionMarks[] = '(?,?,?,?,?,?,?)';
                                    array_push($contactsData,$list['id'],$value[$keys['firstNameKey']],$value[$keys['lastNameKey']],$value[$keys['emailKey']],json_encode($data),$status,'Unverified');

                                    /*
                                    $q = $pdo->prepare('INSERT IGNORE INTO `contacts` (list_id,firstName,lastName,email,data,status,mailclick_status)  VALUES (?,?,?,?,?,?,?)');
                                    $q->execute(array(
                                      $list['id'],
                                      $value[$keys['firstNameKey']],
                                      $value[$keys['lastNameKey']],
                                      $value[$keys['emailKey']],
                                      json_encode($data),
                                      $status,
                                      'Unverified'
                                    ));
                                  }
                                  */

                                }

                                $count++;

                                // Execute query every 100 records
                                if ($count > 100)
                                {
                                    if( !empty($contactsData) )
                                    {


                                        $q = $pdo->prepare('INSERT IGNORE INTO `contacts` (list_id,firstName,lastName,email,data,status,mailclick_status)  VALUES ' . implode(",", $contactsQuestionMarks));
                                        $q->execute($contactsData);

                                        $contactsData = array();
                                        $contactsQuestionMarks = array();
                                        $count = 0;
                                    }
                                }
                            }
                        }


                    }


                    // Insert any remaning data
                    if( !empty($contactsData) ){
                        $q = $pdo->prepare('INSERT IGNORE INTO `contacts` (list_id,firstName,lastName,email,data,status,mailclick_status)  VALUES ' . implode(",", $contactsQuestionMarks));
                        $q->execute($contactsData);
                    }


                    foreach ($keys as $key => $value) {
                        unset($customFields[$value]);
                    }

                    $q = $pdo->prepare('UPDATE `lists` SET `fields`=? WHERE `id`=?');
                    $q->execute(array(
                        json_encode($customFields),
                        $list['id']
                    ));

                    // recaculate the list totals
                    UpdateListTotals($list['id']);


                    unset($_SESSION['csv_data']);
                    header('Location: '.$root.'/list/'.$list['id']);
                    exit();
                }

                if(isset($_POST['update-list'])){
                    unset($_SESSION['csv_data']);
                    $file_size       = $_FILES['file']['size'];
                    $array = explode('.', $_FILES['file']['name']);
                    $extension = end($array);
                    if($extension == "csv" || $extension == "txt"){
                        if( $file_size <= UPLOAD_MAX_FILE_SIZE ){

                            $csvData = array_map('str_getcsv', file($_FILES['file']['tmp_name']));
                            $keys = array();
                            $col_count = count($csvData[0]);
                            if($col_count <= 50){

                                $_SESSION['csv_data'] = $csvData;
                                $list_name = $list['name'];
                                $csv_headers = array();

                                foreach ($csvData[0] as $key => $value) {
                                    $csv_headers[] = $value;
                                    $to_find = '@';
                                    $pos .= strpos($value, $to_find);
                                }

                                if($pos){
                                    unset($csv_headers);

                                    // Remove file
                                    if (!empty($_FILES['file']['tmp_name']))
                                        @unlink($_FILES['file']['tmp_name']);
                                    $error_code = 1;

                                }
                            }else{

                                // Remove file
                                if (!empty($_FILES['file']['tmp_name']))
                                    @unlink($_FILES['file']['tmp_name']);
                                $error_code = 2;
                            }
                        }else{

                            // Remove file
                            if (!empty($_FILES['file']['tmp_name']))
                                @unlink($_FILES['file']['tmp_name']);
                            $error_code = 3;
                        }
                    }else{

                        // Remove file
                        if (!empty($_FILES['file']['tmp_name']))
                            @unlink($_FILES['file']['tmp_name']);
                        $error_code = 4;
                    }
                }

                ?>
                <?php if( !empty($csv_headers) ){ ?>
                    <div class="container">
                        <div class="row duplicate-email-container">
                            <form action="" method="post" enctype="multipart/form-data">
                                <div class="col-md-12">
                                    <h1 class="panel-title" style="font-size: 25px;">Below are the emails that already exists in other list. Check to remove from import.</h1>
                                    <ul class="list-email-duplicate">
                                        <?php
                                        $is_with_duplicate = false;
                                        foreach ($_SESSION['csv_data'][0] as $key => $value) {
                                            $c = "emai";
                                            if (strpos(strtolower($value), $c) !== false) {
                                                $emailkey = $key;
                                            }
                                        }


                                        $csv_x = 0;
                                        foreach ($_SESSION['csv_data'] as $key => $value) {
                                            if($csv_x == 0){
                                                $csv_x = 1;
                                            }else{
                                                $q = $pdo->prepare('SELECT id, FROM `contacts` WHERE `member_id`=? AND `id`=?');

                                                $q  = $pdo->prepare('SELECT l.id, l.member_id, c.email FROM (`contacts` as c) LEFT JOIN lists as l ON (l.id = c.list_id) WHERE l.member_id =? AND c.email =? ');
                                                $q->execute(array($member['id'], $value[$emailkey]));
                                                if($q->rowcount()){ $is_with_duplicate = true;?>
                                                    <li>
                                                        <label class="checkbox"><input type="checkbox" name="email_remove_dupplicate[]" value="<?php echo $value[$emailkey]; ?>" />&nbsp;<?php echo $value[$emailkey]; ?></label>
                                                    </li>
                                                <?php }

                                            }
                                        }
                                        ?>
                                    </ul>
                                    <input type="hidden" name="emailkey" value="<?php echo $emailkey; ?>">
                                    <br />
                                    <?php if( !$is_with_duplicate ){ ?>
                                        <script>
                                            $(function(){
                                                $(".duplicate-email-container").hide();
                                            });
                                        </script>
                                    <?php } ?>
                                </div>
                                <hr />
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <h1 class="panel-title"><?php echo $list['name']; ?></h1>
                                <p class="panel-subtitle">Map CSV Header - Can only set 1 Email, First Name and Last Name as header.</p>
                                <?php $total_columns = count($csv_headers); ?>
                                <input type="hidden" name="list_name" value="<?php echo $list_name; ?>">
                                <div style="overflow:auto;">
                                    <ul class="field-map">
                                        <?php foreach($csv_headers as $key => $value){ ?>
                                            <li>
                                                <?php
                                                $is_active = '';
                                                $assigned  = '';

                                                $a = "firs";
                                                if (strpos(strtolower($value), $a) !== false) {
                                                    $first = "selected" ;
                                                    $assigned  = "assigned";
                                                    $is_active = 'active';
                                                }else{
                                                    $first = "";
                                                }
                                                $b = "las";
                                                if (strpos(strtolower($value), $b) !== false) {
                                                    $last = "selected" ;
                                                    $assigned  = "assigned";
                                                    $is_active = 'active';
                                                }else{
                                                    $last = "";
                                                }
                                                $c = "emai";
                                                if (strpos(strtolower($value), $c) !== false) {
                                                    $email = "selected" ;
                                                    $assigned  = "assigned";
                                                    $is_active = 'active';
                                                }else{
                                                    $email = "";
                                                }

                                                $class_identifier = str_replace(" ", "", $value);
                                                $class_identifier = strtolower($class_identifier);
                                                $label_class_identifier = "label-" . $class_identifier;
                                                $div_class_identifier   = "container-" . $class_identifier;
                                                $cmb_class_identifier   = $class_identifier;

                                                ?>
                                                <div class="form-group <?php echo $assigned; ?> <?php echo $div_class_identifier; ?>">
                                                    <div class="label <?php echo $is_active; ?> <?php echo $label_class_identifier; ?>"><i class="fas fa-check-circle"></i> <?php echo $value; ?></div>
                                                    <select class="form form-control csv-field" data-key="<?php echo $cmb_class_identifier; ?>" name="csvHeaderMap[]" required="">
                                                        <!-- <option value="">- Select Field -</option> -->
                                                        <option value="Unassign">Unassign</option>
                                                        <option <?php echo $email; ?> value="Email">Email</option>
                                                        <option <?php echo $first; ?> value="First Name">First Name</option>
                                                        <option <?php echo $last; ?> value="Last Name">Last Name</option>
                                                    </select>
                                                </div>
                                            </li>
                                        <?php } ?>
                                    </ul>
                                </div>
                                <div class="form-actions text-center">
                                    <button type="submit" class="btn btn-success">Next</button>
                                </div>
                                </form>
                            </div>
                        </div>
                    </div>

                <?php }else{ ?>
                <div class="panel-header">
                    <div class="float-left">
                        <h1 class="panel-title"><?php echo $list['name']; ?></h1>
                    </div>
                    <div class="float-right">
                        <a href="javascript:void(0);" class="btn btn-sm btn-primary btn-table-add-row">Add contact</a>
                        <a href="#" data-toggle="modal" data-target="#addbulkContactModal" class="btn btn-sm btn-primary">Add bulk contact</a>
                        <!-- <a href="#" data-toggle="modal" data-target="#addContactModal" class="btn btn-sm btn-primary">Add contact</a> -->
                        <a href="javascript:void(0);" data-key="<?php echo $list['id']; ?>" class="btn btn-sm btn-primary btn-list-clean">List Cleaner</a>
                        <a href="<?php echo $root.'/_export.php?list='.$list['id'].'&type=csv'; ?>" target="_blank" class="btn btn-sm btn-primary">Export as CSV</a>
                        <a href="#" attr-optinmonster="<?php echo $root.'/_optinmonsterhook.php?list='.$list['id'].'&member_id='.$member['id'].'&hash='.sha1(SITE_ENCRYPTION_KEY . $member['id']); ?>" class="btn btn-sm btn-secondary" data-toggle="modal" data-target="#optinmonsterModal">Optinmonster Integration</a>
                        <a href="#" attr-zapier="<?php echo $root.'/_zapier.php?list='.$list['id'].'&member_id='.$member['id'].'&hash='.sha1(SITE_ENCRYPTION_KEY . $member['id']); ?>" attr-zapieradd="<?php echo $root.'/_zapier.php?action=add&list='.$list['id'].'&member_id='.$member['id'].'&hash='.sha1(SITE_ENCRYPTION_KEY . $member['id']); ?>" class="btn btn-sm btn-secondary" data-toggle="modal" data-target="#zapierModal">Zapier Integration</a>

                    </div>
                    <div class="clearfix"></div>
                </div>
                <?php
                if( $action_msg != '' ){
                    echo $action_msg;
                }
                ?>

                <!-- Modal -->
                <div class="modal fade" id="addbulkContactModal" tabindex="-1" role="dialog" aria-labelledby="addbulkContactModal" aria-hidden="true">
                    <div class="modal-dialog modal-lg" role="document">
                        <div class="modal-content">
                            <div class="modal-body">
                                <!-- <h4 class="modal-heading" id="editLabel">Add Bulk Contact</h4> -->
                                <div class=" text-center">
                                    <div style="display: block;" class="upload-list-msg"></div>

                                    <?php if($error_code==1){ ?>
                                        <div class="alert alert-warning"> Import error: no header on the csv.</div>
                                    <?php }?>
                                    <?php if($error_code==2){ ?>
                                        <div class="alert alert-warning"> Import error: limit your fields to 50 only.</div>
                                    <?php }?>
                                    <?php if($error_code==3){ ?>
                                        <div class="alert alert-warning"> Import error: Filesize is limit to <?php echo  format_size(UPLOAD_MAX_FILE_SIZE); ?> </div>
                                    <?php }?>
                                    <?php if($error_code==4){ ?>
                                        <div class="alert alert-warning"> Invalid file format. Click <a href="<?php echo $root_assets; ?>/sample.csv" target="_blank">here</a> to download the correct template.  </div>
                                    <?php }?>

                                    <form action="" method="post" enctype="multipart/form-data">
                                        <div class="drop-upload">


                                            <a class="float-right btn-sm btn-default btn-download-template" href="<?php echo $root_assets; ?>/sample.csv">Download Template</a>
                                            <div id="dropContainer">

                                                <i class="fas fa-cloud-upload-alt"></i>
                                                <big>Drop a file here or click to upload</big>
                                                <label>Upload *.csv file. Maximum filesize: <?php echo format_size(UPLOAD_MAX_FILE_SIZE); ?>.</label>
                                                <a class="btn btn-sm btn-secondary btn-select-upload" href="javascript:void();">Select files to upload</a>
                                            </div>
                                        </div>
                                        <input type="file" id="fileInput" name="file" style="display: none;">
                                        <div class="upload-notes">
                                            All lists must have a "first name", "last name", and "email" field. <br/>Any other field will also be added and can be dynamically inserted to emails using tags, example: {company}, {phone_number}.
                                        </div>

                                        <div class="modal-footer" style="display: block;text-align: center;">
                                          <button type="button" class="btn btn-default" data-dismiss="modal" style="width:200px;background-color:#c1c1c1;color:#ffffff;font-size: 21px;">Close</button>
                                          <button type="submit" class="btn btn-md btn-success btn-upload-list" style="width:200px;font-size: 21px;" name="update-list" value="update">Upload Contacts</button>
                                        </div>

                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


                <!-- Modal -->
                <div class="modal fade modal-danger modal-enhanced" id="errorImportModal" tabindex="-1" role="dialog" aria-labelledby="errorImportModal" aria-hidden="true">
                    <div class="modal-dialog modal-md" role="document">
                        <div class="modal-content">
                            <div class="modal-body">
                                <h4 class="modal-heading" id="editLabel">Import Error </h4>
                                <div class=" text-center">

                                    <?php if($error_code==1){ ?>
                                        <div class="alert alert-warning"> Import error: no header on the csv.</div>
                                    <?php }?>
                                    <?php if($error_code==2){ ?>
                                        <div class="alert alert-warning"> Import error: limit your fields to 50 only.</div>
                                    <?php }?>
                                    <?php if($error_code==3){ ?>
                                        <div class="alert alert-warning"> Import error: Filesize is limit to <?php echo  format_size(UPLOAD_MAX_FILE_SIZE); ?> </div>
                                    <?php }?>
                                    <?php if($error_code==4){ ?>
                                        <div class="alert alert-warning"> Invalid file format. Click <a href="<?php echo $root_assets; ?>/sample.csv" target="_blank">here</a> to download the correct template.  </div>
                                    <?php }?>

                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal fade modal-danger modal-enhanced" id="errorModal" tabindex="-1" role="dialog" aria-labelledby="errorModal" aria-hidden="true">
                    <div class="modal-dialog modal-lg" role="document">
                        <div class="modal-content">
                            <div class="modal-body">
                                <h4 class="modal-heading" id="editLabel">Error </h4>
                                <div class="error-modal-body"></div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


                <!-- Modal -->
                <div class="modal fade" id="addContactModal" tabindex="-1" role="dialog" aria-labelledby="addContactModal" aria-hidden="true">
                    <div class="modal-dialog modal-lg" role="document">
                        <div class="modal-content">
                            <form action="" method="post">
                                <div class="modal-body">
                                    <h4 class="modal-heading" id="editLabel">Add Contact</h4>
                                    <input type="hidden" name="add_contact_list_id" value="<?php echo $list['id']; ?>">
                                    <?php
                                    $q = $pdo->prepare('SELECT `id`,`list_id`,`firstName`,`lastName`,`email`,`data`,`status`,`mailclick_status` FROM `contacts` WHERE `list_id`=? ORDER BY `id` DESC');
                                    $q->execute(array($list['id']));
                                    $contact = $q->fetch(PDO::FETCH_ASSOC);
                                    ?>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <input type="text" name="firstName" class="form-control" value="" autocomplete="off" required>
                                                <label>First name</label>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <input type="text" name="lastName" class="form-control" value="" autocomplete="off" required>
                                                <label>Last name</label>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <input type="email" name="email" class="form-control" value="" autocomplete="off" required>
                                                <label>Email</label>
                                            </div>
                                        </div>
                                        <?php
                                        // $customFields = json_decode($contact['data'], 1);
                                        // if (!empty($customFields))
                                        // foreach ($customFields as $key => $value) {
                                        //   echo '
                                        //   <div class="col-md-4">
                                        //     <div class="form-group">
                                        //       <input type="text" name="data['.$key.']" class="form-control" value="" autocomplete="off">
                                        //       <label>'.$key.'</label>
                                        //     </div>
                                        //   </div>
                                        //   ';
                                        // }
                                        ?>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                        <button type="submit" class="btn btn-success">Save</button>
                                    </div>

                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="modal fade" id="zapierModal" tabindex="-1" role="dialog" aria-labelledby="zapierModalLabel" aria-hidden="true">
                    <div class="modal-dialog modal-lg" role="document">
                        <div class="modal-content">
                            <div class="modal-body">
                                <img src="<?php echo $root; ?>/img/zapier-small-orange-logo.png">


                                <p><strong>Push Data into your Lists from Zapier</strong></p>
                                <ol style="margin-left:0;">
                                    <li>
                                        Login to <a href="https://zapier.com/app/zaps" target="_blank">Zapier</a> and click the button <strong>Make a Zap!</strong>
                                    </li>
                                    <li>
                                        Use app <strong>Webhooks by Zapier</strong> and select <strong>Post as the method</strong> Guide video can be found <a href="https://softwaredemos.tinytake.com/tt/NDExNTkwNl8xMjY3MDE5Mw" target="_blank">here</a>.
                                    </li>
                                    <li>
                                        Paste the Webhook <strong>URL</strong> generated below:
                                    </li>
                                </ol>

                                <div class="p-2">
                                    <input type="text" name="" class="form-control" readonly id="zapieradd">


                                    <p class="mt-2">Last: Payload Type use "Form" and for Data enter in the name "email", We also support the fields firstName,lastName and any custom field name you have in your list </p>


                                    <p class="mt-2">
                                        Once the above steps are done you will be able to insert emails directly into your contact lists.
                                    </p>
                                </div>



                                <p><strong>Pull Data from your Lists including Email Opens and Replies</h1></strong></p>
                                <ol style="margin-left:0;">
                                    <li>
                                        Login to <a href="https://zapier.com/app/zaps" target="_blank">Zapier</a> and click the button <strong>Make a Zap!</strong>
                                    </li>
                                    <li>
                                        Use app <strong>Webhooks by Zapier</strong> and select <strong>Retrieve Poll</strong>.
                                    </li>
                                    <li>
                                        Paste the <strong>URL</strong> generated below:
                                    </li>
                                </ol>

                                <div class="p-2">
                                    <input type="text" name="" class="form-control" readonly id="zapier">

                                    <p class="mt-2">
                                        Once the above steps are done you should then be able to add an <strong>Action Step</strong> and push all your contacts information (replies, opens, etc) to other apps such as Google Sheets, Trello or any other available app automatically.
                                    </p>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>






                <div class="modal fade" id="optinmonsterModal" tabindex="-1" role="dialog" aria-labelledby="optinmonsterModalLabel" aria-hidden="true">
                    <div class="modal-dialog modal-lg" role="document">
                        <div class="modal-content">
                            <div class="modal-body">
                                <img src="<?php echo $root; ?>/img/optinmonster.png">
                                <ol style="margin-left:0;">
                                    <li>
                                        Login to <a href="https://app.optinmonster.com/login/" target="_blank">OptinMonster</a> and edit your project
                                    </li>
                                    <li>
                                        Add an Integration  then select <strong>Webhook</strong> from the dropdown.
                                    </li>
                                    <li>
                                        Under Webhook Url paste the <strong>URL</strong> generated below:
                                    </li>
                                </ol>

                                <div class="p-2">
                                    <input type="text" name="" class="form-control" readonly id="optinmonster">

                                    <p class="mt-2">
                                        That's it! You’ve successfully connected your Webhook to OptinMonster and any new email contacts will be added to Automailer automatically.
                                    </p>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>

             <div class="modal fade modal-enhanced" id="modal-mailclick-confirmation" tabindex="-1" role="dialog" aria-labelledby="addLabel" aria-hidden="true">
                    <div class="modal-dialog" role="document">
                        <div class="modal-content">                            
                            <div class="row">
                                <div class="col-12" style="text-align: center;margin-top: 36px;">
                                    <img src="<?php echo $root; ?>/img/check-icon.png" style="width:100px;">
                                    <p style="margin-top: 20px; font-size: 30px;margin-bottom: -18px;">Confirmation</p>
                                    <p style="margin-top: 20px; font-size: 18px;margin-bottom: 13px;">Would you like to continue cleaning your list?</p>
                                </div>
                            </div>
                            <form action="" method="post" enctype="multipart/form-data">
                                <input type="hidden" name="lid" class="lid" value="" />
                                <input type="hidden" name="credit_to_use" class="credit_to_use" value="<?php echo $contacts_count; ?>" />
                                <input type="hidden" name="remaining_credits" class="remaining_credits" value="<?php echo $member['cleaning_credits'];?>" />
                                <div class="modal-body">
                                    <div class="footer-confirm" style="text-align:center;">
                                        <p class="list-details" style="display: inline-block; width: 45%;">
                                            <small>Credits to be used</small>
                                            <big><span class="credit-to-use"><?php echo $contacts_count; ?></span></big>
                                        </p>
                                        <p class="list-details" style="display: inline-block; width: 45%;">
                                            <small>Remaining credits</small>
                                            <big><?php echo $member['cleaning_credits'];?></big>
                                        </p>
                                        <div class="modal-footer" style="display: block;text-align: center;">
                                          <button type="button" class="btn btn-default" data-dismiss="modal" style="width:200px;background-color:#c1c1c1;color:#ffffff;font-size: 21px;">No</button>
                                          <button type="submit" class="btn btn-success" name="action" value="send-list-cleaner" style="width:200px;font-size: 21px;">Yes</button>
                                        </div>
                                    </div>
                            </form>
                        </div>
                    </div> 



               <!--     <div class="modal fade modal-enhanced" id="modal-mailclick-confirmation" tabindex="-1" role="dialog" aria-labelledby="addLabel" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header" style="display:none;">
                                    <h5 class="modal-title"></h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">×</span>
                                    </button>
                                </div>
                                <form action="" method="post" enctype="multipart/form-data">
                                <input type="hidden" name="lid" class="lid" value="" />
                                <input type="hidden" name="credit_to_use" class="credit_to_use" value="<?php echo $contacts_count; ?>" />
                                <input type="hidden" name="remaining_credits" class="remaining_credits" value="<?php echo $member['cleaning_credits'];?>" />
                                <div class="modal-body" style="padding:1.5rem;margin-bottom: 50px;">
                                    <i class="fa fa-check-circle modal-confirm-icon"></i><br />
                                    <h2 style="font-size: 38px;text-align: center;">Confirmation</h2>
                                    <p class="message modal-confirm-message">Would you like to continue cleaning your list?</p>
                                    <div class="footer-confirm" style="text-align:center;">
                                        <p class="list-details modal-list-details">
                                            <big><span class="credit-to-use">3,000</span> <small style="display:inline-block;">Credits to be used</small></big>
                                        </p>
                                        <p class="list-details modal-list-details">
                                            <big><?php echo $member['cleaning_credits'];?> <small style="display:inline-block;">Remaining credits</small></big>
                                        </p>
                                    </div>
                                    <div class="footer-error-confirm">
                                        <p class="list-details modal-list-details">
                                            <big><span class="credit-to-use">3,000</span> <small style="display:inline-block;">Credits to be used</small></big>
                                        </p>
                                        <p class="list-details modal-list-details">
                                            <big><?php echo $member['cleaning_credits'];?> <small style="display:inline-block;">Remaining credits</small></big>
                                        </p>
                                    </div>
                                </div>
                                <div class="modal-footer custom-modal-footer" style="margin-top:-2.5rem;">
                                    <button type="button" style="background-color:#C1C1C1;color:#ffffff;" class="btn btn-default" data-dismiss="modal">No</button>
                                    <button type="submit" class="btn btn-success" name="action" value="send-list-cleaner">Yes</button>
                                </div>

                               </form>
                            </div>
                        </div>
                    </div>  -->



                </div>
            </div>


            <div class="row">

                <div class="col-sm-12">
                    <!-- <div class="dataTables_wrapper"> -->
                    <div class="dataTables_wrapper">
                        <table class="table" id="list-ajax-datatable" style="width:100%">
                            <thead>
                            <tr>
                                <th scope="col">ID</th>
                                <th scope="col">First Name</th>
                                <th scope="col">Last Name</th>
                                <th scope="col">Email</th>
                                <th scope="col">Status</th>
                                <?php
                                $i = 0;
                                $tableCustomFields = array();
                                foreach ($contacts as $contact) {
                                    $custom_fields =  json_decode($contacts[0]['data']);
                                    $customFields = json_decode($contact['data'], 1);
                                    if (!empty($custom_fields)) {
                                        foreach ($custom_fields as $key => $value) {
                                            if ($i == 0) {
                                                $tableCustomFields[] = ['key' => $i, 'colname' => $key, 'colvalue' => $value];
                                                echo '<th scope="col">' . $key . '</th>';
                                            }
                                        }
                                        $i++;
                                    }
                                }
                                ?>
                                <th scope="col">Verification Status</th>
                                <th scope="col">Actions</th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                    <!-- </div> -->

                </div>

            </div>

        </div>

        <div class="modal fade" id="editContactModal" tabindex="-1" role="dialog" aria-labelledby="editContactModal" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <form action="" method="post">
                        <div class="modal-body">
                            <h4 class="modal-heading" id="editLabel">Edit Contact</h4>
                            <div class="modal-body-contact-edit"></div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-success">Save Changes</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

       <!-- <div class="modal fade modal-enhanced modal-danger" id="modalDelete" tabindex="-1" role="dialog" aria-labelledby="modalDelete" aria-hidden="true">
            <div class="modal-dialog modal-md" role="document">
                <div class="modal-content">
                    <form action="" method="post">
                        <input type="hidden" name="delete_contact_id" class="delete_contact_id" value="">
                        <div class="modal-body">
                            <h4 class="modal-heading">Confirmation</h4>
                            <div class="modal-body-contact-delete">
                                <p>Are you sure you want to delete selected entry?</p>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-danger">Delete</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>  -->

        <!-- Modal Delete Confirmation -->
        <div class="modal fade modal-enhanced modal-danger" id="modalDelete" tabindex="-1" role="dialog" aria-labelledby="modalDelete" aria-hidden="true">
            <div class="modal-dialog modal-md" role="document">
                <form action="" method="post">
                    <input type="hidden" value="" name="delete_contact_id" class="delete_contact_id">
                    <div class="modal-content">
                        <div class="modal-body">
                            <div class="col-md-12">
                                <img src="<?php echo $root; ?>/img/delete-icon.png" class="img-delete">
                                <h3 class="hdr-delete" style="font-size:29px; font-weight: bold;">Are you sure</h3>
                                <div class="list-selected-msg" style="text-align:center;font-size: 18px;">Do you really want to Delete selected entry?<br />This process cannot be undone</div>
                            </div>
                            <div class="modal-footer" style="display: block;text-align: center;">
                                <button type="button" class="btn btn-default" data-dismiss="modal" style="width:200px;background-color:#c1c1c1;color:#ffffff;font-size: 21px;">Cancel</button>
                                <button type="submit" class="btn btn-danger" name="action" value="delete" style="width:200px;font-size: 21px;">Delete</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <!-- /.container-fluid -->

        <div class="startup-actions text-center" style="margin-top:-30px;">
            <a href="<?php echo $root.'/lists'; ?>" class="btn btn-lg btn-outline-secondary">Back</a>
        </div>


        <div class="clearfix"></div>
        <?php } ?>


    </div>
    <!-- End of Main Content -->    
    <script>
        $(function(){
            $(".csv-field").change(function(){
                var selected   = $(this).val();
                var identifier = $(this).attr("data-key");
                if( selected != 'Unassign' ){
                    $(".label-"+identifier).addClass("assigned");
                    $(".container-"+identifier).addClass("assigned");
                }else{
                    $(".label-"+identifier).removeClass("assigned");
                    $(".container-"+identifier).removeClass("assigned");
                }
            });
            <?php if($error_code >= 1 ){  ?>
            $("#addbulkContactModal").modal("show");
            <?php  } ?>
        });
    </script>

    <!-- Footer -->
    <footer class="sticky-footer bg-white">
        <div class="container my-auto">
            <div class="copyright text-center my-auto">
                <span>Copyright &copy; <?php echo date('Y'); ?></span>
            </div>
        </div>
    </footer>
    <!-- End of Footer -->

</div>
<!-- End of Content Wrapper -->

</div>
<!-- End of Page Wrapper -->

<!-- Scroll to Top Button-->
<a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
</a>
<script>
    $(function(){
        $(".btn-table-add-row").click(function(){
            <?php echo "var customFields = ". json_encode($tableCustomFields) . ";"; ?>
            //console.log(customFields);
            var tableRowCount = $('#list-ajax-datatable tr').length;
            var html = '<tr class="insert-row-'+tableRowCount+'">';
            html += '<td></td>';
            /*html += '<td></td>';
            html += '<td id="data1"><input type="text" class="form-control" /></td>';
            html += '<td id="data2"><input type="text" class="form-control" /></td>';
            html += '<td id="data3"><input type="text" class="form-control" /></td>';
            html += '<td>-</td>';
            html += '<td>Unverified</td>';
            html += '<td><button type="button" name="insert"><i class="fa fa-check"></i> Save</button></td>';
            html += '</tr>';*/

            //html += '<td></td>';
            html += '<td contenteditable class="editable-cell" id="data1-'+tableRowCount+'"></td>';
            html += '<td contenteditable class="editable-cell" id="data2-'+tableRowCount+'"></td>';
            html += '<td contenteditable class="editable-cell" id="data3-'+tableRowCount+'"></td>';
            var keydata = 4;
            $.each( customFields, function( key, value ) {
                //console.log(value);
                html += '<td contenteditable class="editable-cell cf-row-id-'+tableRowCount+'"" data-col="'+value.colname+'" id="data'+keydata+'-'+tableRowCount+'"></td>';
                keydata++;
            });
            html += '<td>-</td>';
            html += '<td>Unverified</td>';
            html += '<td><button type="button" class="btn btn-default btn-sm btn-list-save-row" data-id="'+tableRowCount+'" name="insert"><i class="fa fa-check"></i></button><button type="button" class="btn btn-default btn-sm btn-list-cancel-row" data-id="'+tableRowCount+'" name="insert"><i class=" fa fa-window-close"></i></button></td>';
            html += '</tr>';

            $('#list-ajax-datatable tbody').prepend(html);
            $("#list-ajax-datatable_wrapper").scrollTop();

            //scroll back up on add contact
            $(".dataTables_scrollBody").animate({
                scrollTop: 0
            }, 100);
        });

        $(document).on('click', '.btn-list-save-row', function(){
            var rowId = $(this).attr("data-id");
            var list_id =  <?php echo $_SEO[2]; ?>;
            var dataCustomFields = {};

            var customFields = document.getElementsByClassName("cf-row-id-" + rowId);
            $('.cf-row-id-' + rowId).each(function(){
                dataCustomFields[$(this).attr('data-col')] = $(this).text();
            });

            var postdata = {
                list_id : list_id,
                firstname : $("#data1-"+rowId).text(),
                lastname : $("#data2-"+rowId).text(),
                email : $("#data3-"+rowId).text(),
                dataCustomFields : dataCustomFields,
            };

            var keydata = 4;
            var is_valid = 1;
            var error_msg = '';

            /*if( $("#data1-"+rowId).text() == '' ){
                is_valid = 0;
                error_msg += '<li>Firstname cannot be empty</li>';
            }

            if( $("#data2-"+rowId).text() == '' ){
                is_valid = 0;
                error_msg += '<li>Lastname cannot be empty</li>';
            }*/

            if( $("#data3-"+rowId).text() == '' ){
                is_valid = 0;
                error_msg += '<li>Email cannot be empty</li>';
            }


            /*$.each( customFields, function( key, value ) {
                if( $("#data"+keydata+"-"+rowId).text() != '' ){
                    postdata[value.colname] =   $("#data"+keydata+"-"+rowId).text() //value.colvalue;
                }else{
                    error_msg += '<li>'+value.colname+' cannot be empty</li>';
                    is_valid = 0;
                }
                keydata++;
            });*/

            if( $("#data3-"+rowId).text() != '' ){
                if(!isValidEmailAddress($("#data3-"+rowId).text())) {
                    is_valid = 0;
                    error_msg += '<li>Not a valid email</li>';
                }else{
                    var url = root_dir + "/_check_email_exist";
                    $.ajax({
                        type: "POST",
                        url: url,
                        data: postdata,
                        success: function(o)
                        {    var obj = JSON.parse(o);
                            if(obj.exist > 0){
                                is_valid = 0;
                                error_msg += '<li>Email already exist</li>';
                            }
                        }
                    });
                }
            }

            setTimeout(function(){
                if( is_valid == 1 ){
                    var url = root_dir + "/_save_list_data";
                    $.ajax({
                        type: "POST",
                        url: url,
                        data: postdata,
                        success: function(o)
                        {
                            $('#list-ajax-datatable').DataTable().ajax.reload();
                        }
                    });
                }else{
                    $(".error-modal-body").html('<ul class="error-list">' + error_msg + '</ul>');
                    $("#errorModal").modal('show');
                }

            }, 1000);

        });

        function isValidEmailAddress(emailAddress) {
            var pattern = new RegExp(/^(("[\w-+\s]+")|([\w-+]+(?:\.[\w-+]+)*)|("[\w-+\s]+")([\w-+]+(?:\.[\w-+]+)*))(@((?:[\w-+]+\.)*\w[\w-+]{0,66})\.([a-z]{2,6}(?:\.[a-z]{2})?)$)|(@\[?((25[0-5]\.|2[0-4][\d]\.|1[\d]{2}\.|[\d]{1,2}\.))((25[0-5]|2[0-4][\d]|1[\d]{2}|[\d]{1,2})\.){2}(25[0-5]|2[0-4][\d]|1[\d]{2}|[\d]{1,2})\]?$)/i);
            return pattern.test(emailAddress);
        };

        $(document).on('click', '.btn-edit-contact-row', function(){
            var rowId = $(this).attr("data-key");
            $(".cell-input-" + rowId).show();
            $(".cell-edit-" + rowId).hide();

            $(".update-action-" + rowId).show();
            $(".cancel-update-action-" + rowId).show();

            $(".edit-action-" + rowId).hide();
            $(".delete-action-" + rowId).hide();

        });

        $(document).on('click', '.cell-edit-custom', function(){
            var rowId = $(this).attr("data-id");
            $(".edit-action-" + rowId).click();
        });

        $(document).on('click', '.btn-cancel-update-contact-row', function(){
            var rowId = $(this).attr("data-key");
            $(".cell-input-" + rowId).hide();
            $(".cell-edit-" + rowId).show();

            $(".update-action-" + rowId).hide();
            $(".cancel-update-action-" + rowId).hide();

            $(".edit-action-" + rowId).show();
            $(".delete-action-" + rowId).show();
        });

        $(document).on('click', '.btn-update-contact-row', function(){
            var rowId = $(this).attr("data-key");
            var postData = {
                contact_id : rowId
            };

            var is_valid = 1;
            var error_msg = '';
            $('.cell-input-' + rowId).each(function(index, element) {
                if( $(this).val() != '' ){
                    var colName  = $(this).attr('data-col');
                    var colValue = $(this).val();
                    postData[colName] = colValue;
                }else{
                    var dtcol = $(this).attr('data-col');
                    //alert(dtcol);
                    if($(this).attr('data-col')=="email"){
                        if($(this).val() == ''){
                            error_msg += '<li>'+$(this).attr('data-col')+' cannot be empty</li>';
                            is_valid = 0;
                        }
                    }
                }

            });

            if( is_valid == 1 ){
                var url = root_dir + "/_update_list_data";
                $.ajax({
                    type: "POST",
                    url: url,
                    data: postData,
                    success: function(o)
                    {
                        $('#list-ajax-datatable').DataTable().ajax.reload();
                    }
                });
            }else{
                $(".error-modal-body").html('<ul class="error-list">' + error_msg + '</ul>');
                $("#errorModal").modal('show');
            }


            // console.log(postData);
        });

        $(document).on('click', '.btn-list-cancel-row', function(){
            var rowId = $(this).attr("data-id");
            $(".insert-row-" + rowId).remove();
        });
    });
</script>