  <title><?php echo SITE_NAME; ?> - View List</title>
</head>

<body id="page-top">

  <!-- Page Wrapper -->
  <div id="wrapper">

    <?php include_once("nav_wrapper.php"); ?>

    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column">

      <!-- Main Content -->
      <div id="content">

        <!-- Topbar Navbar -->
        <?php include_once("nav/right_nav.php"); ?>

        <!-- Begin Page Content -->
        <div class="container-fluid dashboard">

          <?php

             $action_msg = '';

            if( isset($_POST['add_contact_list_id']) ){
              $email_checker = $pdo->prepare('SELECT * FROM `contacts` WHERE `list_id`=? AND `email`=?');
              $email_checker->execute(array($_POST['add_contact_list_id'],$_POST['email']));
              if($email_checker->rowcount()<1){
                $q = $pdo->prepare('INSERT INTO `contacts` (list_id,firstName,lastName,email,data,status,mailclick_status) VALUES (?,?,?,?,?,?,?)');
                $q->execute(array($_POST['add_contact_list_id'], $_POST['firstName'], $_POST['lastName'], $_POST['email'], json_encode($_POST['data']), 0, 'Unverified'));
                
                $action_msg = '
                <div class="alert alert-success" role="alert">
                  Contact '.$_POST['firstName'].' has been added.
                </div>
                ';
                
              }else{
                $action_msg = '
                <div class="alert alert-warning" role="alert">
                  Contact '.$_POST['email'].' already in the list. Cannot add duplicate email.
                </div>
                ';
              }
            }



          $q = $pdo->prepare('SELECT * FROM `lists` WHERE `member_id`=? AND `id`=?');
          $q->execute(array($member['id'], $_SEO[2]));
          $list = $q->fetch(PDO::FETCH_ASSOC);

          if(isset($_GET['remove']))
          {

            $q = $pdo->prepare('SELECT * FROM `contacts` WHERE `list_id`=?');
            $q->execute(array($list['id']));
            $contacts = $q->fetchAll();

            if(count($contacts) == 1)
            {
              $q = $pdo->prepare('INSERT INTO `contacts` (list_id,firstName,lastName,email,data) VALUES (?,?,?,?,?)');
              $q->execute(array($_SEO[2], '', '', '', $contacts[0]['data']));
            }

           echo '
                <div class="alert alert-danger" role="alert">
                  Contact successfully deleted!
                </div>
                ';

          }

          $q = $pdo->prepare('SELECT * FROM `contacts` WHERE `list_id`=? AND (`status`=? OR `status`=?)');
          $q->execute(array($list['id'],2,0));
          $contacts = $q->fetchAll();


          

          if(isset($_POST['exclusionContactPass_id']))
          {
                       
            //Add to exclusions
            $data_exclusions = array(
              $member['id'],
              $_POST['exclusionContactEmail'],
              exclusionEmail(),
              strtotime(date("Y-m-d H:i:s"))
            );
            $q = $pdo->prepare('INSERT INTO `exclusions` (member_id,exclusion,type,created) VALUES (?,?,?,?)');
            $q->execute($data_exclusions);
         
             echo '
                <div class="alert alert-danger" role="alert">
                  Contact successfully excluded!
                </div>
                ';

          }

          if(isset($_POST['deleteContactPass_id']))
          {
            $q = $pdo->prepare('DELETE FROM `contacts` WHERE `list_id`=? AND `id`=?');
            $q->execute(array($_POST['deleteContactList_id'], $_POST['deleteContactPass_id']));
             
             header('Location: '.$root.'/list-cleaner/'.$_POST['deleteContactList_id'].'/?remove='.$_POST['deleteContactPass_id'] );
             exit;
         

          }


          if( $action_msg != '' ){
            echo $action_msg;
          }
       
          
          ?>
          <a class="btn-default btn btn-back btn-sm" href="javascript:history.back()"><i class="fas fa-chevron-left"></i> Back</a>
          <!-- Page Heading -->
          <div class="panel-header">
            <div class="float-left">
              <h1 class="panel-title"><small class="blue">Unverified and Bad Email List</small> <?php echo $list['name']; ?></h1>
            </div>
            <div class="float-right">
              <a href="<?php echo $root.'/clean-email/'.$list['id']; ?>" class="btn btn-sm btn-primary">Clean Email</a>
              <a href="#" data-toggle="modal" data-target="#addContactModal" class="btn btn-sm btn-primary">Add contact</a>
              <a href="<?php echo $root.'/_export.php?list='.$list['id'].'&type=csv'; ?>" target="_blank" class="btn btn-sm btn-primary">Export as CSV</a>
              <a href="#" attr-zapier="<?php echo $root.'/_zapier.php?list='.$list['id'].'&member_id='.$member['id'].'&hash='.sha1(SITE_ENCRYPTION_KEY . $member['id']); ?>" attr-zapieradd="<?php echo $root.'/_zapier.php?action=add&list='.$list['id'].'&member_id='.$member['id'].'&hash='.sha1(SITE_ENCRYPTION_KEY . $member['id']); ?>" class="btn btn-sm btn-secondary" data-toggle="modal" data-target="#zapierModal">Zapier Integration</a>
            </div>
            <div class="clearfix"></div>
          </div>

          <!-- Modal -->
          <div class="modal fade" id="zapierModal" tabindex="-1" role="dialog" aria-labelledby="zapierModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document" style="margin-top: 10vw;">
              <div class="modal-content">
                <div class="modal-body">
                <img src="<?php echo $root; ?>/img/zapier-small-orange-logo.png">
                  <ol style="margin-left:0;">
                    <li>
                      Login to <a href="https://zapier.com/app/zaps" target="_blank">Zapier</a> and click the button <strong>Make a Zap!</strong>
                    </li>
                    <li>
                      Use app <strong>Webhooks by Zapier</strong> and select <strong>Retrieve Poll</strong>.
                    </li>
                    <li>
                      Paste the <strong>URL</strong> generated below:
                    </li>
                  </ol>

                  <div class="p-2">
                    <input type="text" name="" class="form-control" readonly id="zapier">

                    <p class="mt-2">
                      Once the above steps are done you should then be able to add an <strong>Action Step</strong> and push all your contacts information (replies, opens, etc) to other apps such as Google Sheets, Trello or any other available app automatically.
                    </p>
                  </div>

                  <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                  </div>

                </div>                
              </div>
            </div>
          </div>
          

          <div class="row">

            <div class="col-sm-12">

            <div class="dataTables_wrapper">

              <table class="table datatable">
                <thead>
                  <tr>
                    <th scope="col">ID</th>
                    <th scope="col" style="width: 20%;">First name</th>
                    <th scope="col" style="width: 20%;">Last name</th>
                    <th scope="col" style="width: 20%;">Email</th>
                    <?php
                    $i = 0;
                    foreach ($contacts as $contact) {
                      $customFields = json_decode($contact['data'], 1);
                      foreach ($customFields as $key => $value) {
                        if($i == 0)
                        {
                          echo '<th scope="col">'.$key.'</th>';
                        }
                      }
                      $i++;
                    }
                    ?>                    
                    <th scope="col">Status</th>
                    <th scope="col" style="width:15%;">Actions</th>
                  </tr>
                </thead>
                <tbody>
                  <?php
                  foreach ($contacts as $contact) {

                    echo '
                    <tr>
                      <td scope="col">'.$contact['id'].'</td>
                      <td scope="col">'.$contact['firstName'].'</td>
                      <td scope="col">'.$contact['lastName'].'</td>
                      <td scope="col">'.$contact['email'].'</td>';
                      $customFields = json_decode($contact['data'], 1);
                      foreach ($customFields as $key => $value) {
                        echo '<td scope="col">'.$value.'</td>';
                      }
                      //if($contact['status']==1 || $contact['status']==0){
                      if($contact['status']==0){
                        $email_status = "<label class='text-warning'><big>&bull;</big> Unverified</label>";
                      }else{
                        $email_status = "<label class='text-danger'><big>&bull;</big> Bad</label>";
                      }

                      echo '
                      <td scope="col">'. $email_status .'</td>
                      <td scope="col">
                      <a href="javascript:void(0);" class="btn btn-default btn-sm" data-toggle="modal" data-target="#deleteMember'.$contact['id'].'" title="Delete"><i class="fas fa-trash-alt"></i></a>
                      <a href="javascript:void(0);" class="btn btn-default btn-sm" data-toggle="modal" data-target="#exclusionContact'.$contact['id'].'" title="Exclude"><i class="fas fa-eraser"></i></a>
                      '; ?>

                         <!-- Modal for Delete Member -->
                          <div class="modal fade modal-enhanced modal-danger" id="deleteMember<?php echo $contact['id']; ?>" tabindex="-1" role="dialog" aria-labelledby="addPOP3Label" aria-hidden="true">
                            <div class="modal-dialog modal-md" role="document" style="margin-top: 10vw;">
                              <div class="modal-content">
                                <div class="modal-body">
                                  <h4 class="modal-heading">Delete Contact</h4>
                                  <form action="" method="post">
                                    <input type="hidden" name="deleteContactPass_id" class="form-control" value="<?php echo $contact['id']; ?>">
                                    <input type="hidden" name="deleteContactList_id" class="form-control" value="<?php echo $list['id']; ?>">
                                    
                                    <div class="row">
                                      <div class="col-md-6">
                                        <?php echo 'Are you sure you want to delete contact? <div class="text-danger"><strong>'.$contact['firstName'].' '.$contact['lastName'] ."</strong> - ". $contact['email'] ; ?></div>
                                      </div>
                                                                       </div>

                                  <div class="modal-footer">
                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                    <button type="submit" class="btn btn-danger">Delete</button>
                                  </div>
                                </form>
                                </div>                                
                              </div>
                            </div>
                          </div>

                          <!-- Modal for Add to contact email to exclusions -->
                          <div class="modal fade" id="exclusionContact<?php echo $contact['id']; ?>" tabindex="-1" role="dialog" aria-labelledby="addPOP3Label" aria-hidden="true">
                            <div class="modal-dialog modal-md" role="document" style="margin-top: 10vw;">
                              <div class="modal-content">
                                <div class="modal-body">
                                  <h4 class="modal-heading">Exclude Contact</h4>
                                  <form action="" method="post">
                                    <input type="hidden" name="exclusionContactPass_id" class="form-control" value="<?php echo $contact['id']; ?>">
                                    <input type="hidden" name="exclusionContactList_id" class="form-control" value="<?php echo $list['id']; ?>">
                                    <input type="hidden" name="exclusionContactEmail" class="form-control" value="<?php echo $contact['email']; ?>">
                                    <div class="row">
                                      <div class="col-md-6">
                                        <?php echo 'Are you sure you want to Exclude this contact? <div class="blue"><strong>'.$contact['firstName'].' '.$contact['lastName'] ."</strong> - ". $contact['email'] ; ?></div>
                                      </div>
                                      <div class="col-sm-12">
                                        <br/>
                                        
                                      </div>
                                    </form>
                                    </div>

                                  <div class="modal-footer">
                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                    <button type="submit" class="btn btn-success">Exclude</button>
                                  </div>
                                </div>
                                
                              </div>
                            </div>
                          </div>

         <?php  echo '</td>
                    </tr>
                    ';
                  // }
                  }
                  ?>
                </tbody>
              </table>
            </div>

            </div>

          </div>

        </div>
        <!-- /.container-fluid -->


        <!-- Modal -->
        <div class="modal fade" id="addContactModal" tabindex="-1" role="dialog" aria-labelledby="addContactModal" aria-hidden="true">
          <div class="modal-dialog modal-lg" role="document" style="margin-top: 10vw;">
            <div class="modal-content">              
              <div class="modal-body">
                <h4 class="modal-heading">Add Contact</h4>
                <form action="" method="post">
                  <input type="hidden" name="add_contact_list_id" value="<?php echo $list['id']; ?>">
                  <?php 
                    $q = $pdo->prepare('SELECT * FROM `contacts` WHERE `list_id`=? ORDER BY `id` DESC');
                    $q->execute(array($list['id']));
                    $contact = $q->fetch(PDO::FETCH_ASSOC);
                  ?>
                  <div class="row">
                    <div class="col-md-4">
                      <div class="form-group">
                        <input type="text" name="firstName" class="form-control" value="" autocomplete="off" required>
                        <label>First name</label>
                      </div>
                    </div>
                    <div class="col-md-4">
                      <div class="form-group">
                        <input type="text" name="lastName" class="form-control" value="" autocomplete="off" required>
                        <label>Last name</label>
                      </div>
                    </div>
                    <div class="col-md-4">
                      <div class="form-group">
                        <input type="email" name="email" class="form-control" value="" autocomplete="off" required>
                        <label>Email</label>
                      </div>
                    </div>
                    <?php
                    $customFields = json_decode($contact['data'], 1);
                    foreach ($customFields as $key => $value) {
                      echo '
                      <div class="col-md-4">
                        <div class="form-group">  
                          <input type="text" name="data['.$key.']" class="form-control" value="" autocomplete="off">
                          <label>'.$key.'</label>
                        </div>
                      </div>
                      ';
                    }
                    ?>
                  </div> 

                  <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-success">Save</button>
                  </div>  
              
                </form>                 

              </div>
            </div>
          </div>
        </div>

        <!-- <div class="startup-actions text-center" style="margin-top:-30px;">
          <a href="<?php echo $root.'/lists'; ?>" class="btn btn-lg btn-outline-secondary">Back</a>
        </div> -->

      </div>
      <!-- End of Main Content -->

      <!-- Footer -->
      <footer class="sticky-footer bg-white">
        <div class="container my-auto">
          <div class="copyright text-center my-auto">
            <span>Copyright &copy; <?php echo date('Y'); ?></span>
          </div>
        </div>
      </footer>
      <!-- End of Footer -->

    </div>
    <!-- End of Content Wrapper -->

  </div>
  <!-- End of Page Wrapper -->

  <!-- Scroll to Top Button-->
  <a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
  </a>