  <title>Login</title>
</head>

<body class="bg-gradient-primary">

  <nav class="navbar navbar-expand-lg navbar-dark" style="background: #0089FF; padding: 1rem 5rem;">
    <a href="<?php echo $root; ?>" class="navbar-brand">
      <img src="<?php echo $root; ?>/img/logo-placeholder.png">
    </a>
    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarText" aria-controls="navbarText" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navbarText">
      <ul class="navbar-nav ml-auto">
        <li class="nav-item active">
          <a class="btn btn-outline-secondary text-white ml-4" href="<?php echo $root; ?>">Home <span class="sr-only">(current)</span></a>
        </li>
        <li class="nav-item">
          <a class="btn btn-outline-secondary text-white ml-4" href="#" data-toggle="modal" data-target="#pricingModal">Pricing</a>
        </li>
        <li class="nav-item">
          <a class="btn btn-success ml-4" href="<?php echo $root; ?>/login">Login</a>
        </li>
      </ul>
    </div>
  </nav>

  <div class="container">

    <!-- Outer Row -->
    <div class="row justify-content-center">

      <div class="col-xl-10 col-lg-12 col-md-9">

        <div class="card o-hidden border-0 shadow-lg" style="margin-top: 4vw;">
          <div class="card-body p-0">
            <!-- Nested Row within Card Body -->
            <div class="row">
              <div class="col-sm-12">
                <div class="p-5">
                  <div class="text-center">
                    <h1 class="h4 text-gray-900 mb-4">Login to your account</h1>
                  </div>
                  <?php
                  /*
                  $q = $pdo->prepare('SELECT * FROM `members` WHERE `id`=?');
                  $q->execute(array(2));
                  $row = $q->fetch(PDO::FETCH_ASSOC);
                  $_SESSION = $row;
                  header('Location: '.$root);
                  exit();
                  */

                  if(!empty($_POST['user_email']))
                  {

                    foreach ($_POST as $key => $value) {
                      $_POST[$key] = htmlspecialchars($value, ENT_QUOTES);
                    }

                    $q = $pdo->prepare('SELECT * FROM `users` WHERE super_admin = 1 AND (`email`=? || `username`=?) LIMIT 1');
                    $q->execute(array($_POST['user_email'], $_POST['user_email']));
                    $row = $q->fetch(PDO::FETCH_ASSOC);

                    if($q->rowcount()>0 && password_verify($_POST['password'], $row['password']))
                    {                      
                      $_SESSION = $row;
                      header('Location: '.$root.'/user-management/');
                      exit();
                        
                    }
                    else
                    {
                      echo '<p class="text-danger mb-4">Error: Incorrect login details provided.</p>';
                    }

                  }
                  ?>
                  <form class="user" action="" method="post">
                    <div class="form-group">
                      <input type="text" name="user_email" class="form-control form-control-user" id="exampleInputEmail" aria-describedby="emailHelp" placeholder="Email address or username" required>
                    </div>
                    <div class="form-group">
                      <input type="password" name="password" class="form-control form-control-user" id="exampleInputPassword" placeholder="Password" required>
                    </div>
                    <div class="form-group">
                      <div class="custom-control custom-checkbox small">
                        <input type="checkbox" class="custom-control-input" id="customCheck">
                        <label class="custom-control-label" for="customCheck">Remember Me</label>
                      </div>
                    </div>
                    <button type="submit" class="btn btn-success btn-user btn-block">Login</button>
                    <hr>
                  </form>
                  <div class="text-center">
                    <a class="small" href="<?php echo $root; ?>/forgot-password">Forgot Password?</a>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

      </div>

    </div>

  </div>