<title><?php echo SITE_NAME; ?> - Prospect Finder</title>
</head>
<style>
    .tabsBtns{
        width: 100%;
        display: inline-block;
        background: white;
        text-align: center;
        color: black;
        padding: 10px;
        transition: 0.7s;
        border-radius: 5px;
    }
    .tabsBtns:hover{
        text-decoration: none;
        color: white;
        background: #0a93fe;
        box-shadow: 7px 8px 6px 2px #00000040;
    }
    .tabsBtns.active{
        background: #0a93fe;
        color: white;
    }
</style>
<?php
require_once 'vendor/stripe/stripe-php/init.php';
$stripe = \Stripe\Stripe::setApiKey($new_stripe_sk);
?>

<!-- create or update subscription -->
<?php
if(isset($_POST['subscription']))
{
    if(!empty($_POST['stripe_token']))
    {

        $customer = \Stripe\Customer::create(array(
            'email' => $member['email'],
            'source'  => $_POST['stripe_token']
        ));
        $customer_id = $customer->id;
        $data_member = array(
            $customer_id,
            $_POST['cc_4digits'],
            $_POST['cc_month'],
            $_POST['cc_year'],
            $_POST['stripe_card_brand'],
            $member['id']
        );
        $q = $pdo->prepare('UPDATE `members` SET  `stripe_customer_id`=?, `cc_4digits`=?, `cc_month`=?, `cc_year`=?,`stripe_card_brand`=? WHERE `id`=?');
        $q->execute($data_member);
    }else{
        $customer_id = $_POST['cutomer_id'];
    }
    $credites = !empty($member['search_credit']) ? $member['search_credit']  : 0;
    $credites = $credites + $_POST['credites_to_add'];
    if(empty($member['prospect_stripe'])) //create subscription
    {
        $subscription = \Stripe\Subscription::create(array(
            "customer" => $customer_id,
            "items" => array(
                array(
                    "plan" => $_POST['stripe_plan_id'],
                ),
            ),
        ));

    }else{          // update subscription
        $stripe = json_decode($member['prospect_stripe']);
        $old_sub_id = $stripe->id;
        $retrive_subscription = \Stripe\Subscription::retrieve($old_sub_id);
        $subscription = \Stripe\Subscription::update($old_sub_id, [
            'cancel_at_period_end' => false,
            'proration_behavior' => 'create_prorations',
            'items' => [
                [
                    'id' => $retrive_subscription->items->data[0]->id,
                    'price' => $_POST['stripe_plan_id'],
                ],
            ],
        ]);
    }

    if(isset($subscription->id))
    {
        $data_member = array(
            json_encode($subscription),
            $_POST['selected_plan_id'],
            $credites,
            $member['id']

        );
        $q = $pdo->prepare('UPDATE `members` SET  `prospect_stripe`=?, `prospect_selected_plan`=?, `search_credit`=? WHERE `id`=?');
        $q->execute($data_member);
        echo '
            <div class="alert alert-success" role="alert">
              Subscription Plan was successfully updated!
            </div>
            ';
    }else{
        echo '
            <div class="alert alert-danger" role="alert">
            some thing went wring please try again later!
            </div>
            ';
    }
}

if(isset($_POST['credites_to_add_drop_after']))
{
    $credites = !empty($member['search_credit']) ? $member['search_credit']  : 0;
    $credites = $credites + $_POST['credites_to_add_drop_after'];
    $data_member = array(
        $_POST['prospect_stripe'],
        $_POST['selected_plan_id_after'],
        $credites,
        $_POST['selected_state'],
        $_POST['selected_country'],
        $_POST['selected_city'],
        $_POST['selected_postal_code'],
        $_POST['selected_address'],
        $_POST['cc_4digits'],
        $_POST['cc_month'],
        $_POST['cc_year'],
        $_POST['stripe_card_brand'],
        $member['id']
    );
    $q = $pdo->prepare('UPDATE `members` SET  `prospect_stripe`=?, `prospect_selected_plan`=?, `search_credit`=?, `selected_state`=?,`country_id`=?,`selected_city`=?,`selected_postal_code`=?, `address`=?, `cc_4digits`=?, `cc_month`=?, `cc_year`=?, `stripe_card_brand`=? WHERE `id`=?');
    $q->execute($data_member);
    echo '
        <div class="alert alert-success" role="alert">
          Subscription Plan was successfully updated!
        </div>
        ';
}

if( isset($_POST['update-payment-information']) ){
    $data_member = array(
        $_POST['country_id'],
        $_POST['address'],
        $_POST['city'],
        $_POST['state'],
        $_POST['postal_code'],
        $member['id']
    );
    $q = $pdo->prepare('UPDATE `members` SET `country_id`=?, `address`=?, `selected_city`=?, `selected_state`=?, `selected_postal_code`=? WHERE `id`=?');
    $q->execute($data_member);

    $q = $pdo->prepare('SELECT * FROM `members` WHERE `id`=? LIMIT 1');
    $q->execute(array($member['id']));
    $member = $q->fetch(PDO::FETCH_ASSOC);

    echo '
        <div class="alert alert-success" role="alert">
            Payment Information was successfully updated!
        </div>
        ';
}

$plans = $pdo->prepare('SELECT * FROM `prospect_plans` ');
$plans->execute();
$countries = $pdo->prepare('SELECT * FROM `countries` ORDER BY `name` ASC');
$countries->execute();

$states = $pdo->prepare('SELECT * FROM `states` WHERE `country_id` = ? ORDER BY `name` ASC');
$states->execute(array(225));
$cus_id = "";
if(!empty($member['stripe_customer_id']))
{
    $cus_id = $member['stripe_customer_id'];
}else{
    if(!empty($member['stripe']) && $member['stripe']!=0)
    {
        $stripe = json_decode($member['stripe']);
        $cus_id = $stripe->customer;
    }
}
$q = $pdo->prepare('SELECT * FROM `members` WHERE `id`=? LIMIT 1');
$q->execute(array($_SESSION['id']));
$member = $q->fetch(PDO::FETCH_ASSOC);

$price = 0;
$credit = 0;
if(!empty($member['prospect_selected_plan']))
{
    $selected_plan_record = $pdo->prepare('SELECT * FROM `prospect_plans` WHERE `id`=? LIMIT 1');
    $selected_plan_record->execute(array($member['prospect_selected_plan']));
    $selected_plan_record = $selected_plan_record->fetch(PDO::FETCH_ASSOC);
    $price = $selected_plan_record['price_per_month'];
    $credit = $selected_plan_record['credit'];
}
?>


<body id="page-top">

<!-- Page Wrapper -->
<div id="wrapper">

    <?php include_once("nav_wrapper.php"); ?>
    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column">

        <!-- Main Content -->
        <div id="content">

            <!-- Topbar Navbar -->
            <?php include_once("nav/right_nav.php"); ?>

            <!-- Begin Page Content -->
            <div class="container-fluid">

                <div class="container">
                    <div class="row">
                        <div class="col-12" style="margin-bottom: 40px;">
                            <div class="row">
                                <div class="col-sm-6">
                                    <a class="tabsBtns " href="<?= $root ?>/billing">Email Plans</a>
                                </div>
                                <div class="col-sm-6">
                                    <a class="tabsBtns active" href="#">Prospect Finder</a>
                                </div>
                            </div>
                            <!-- <ul class="nav nav-tabs" id="myTab" role="tablist">
                                <li class="nav-item">
                                    <a class="nav-link active show"  id="home-tab" data-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="true">Home</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" id="profile-tab" data-toggle="tab" href="#" onclick="window.location.href = '<?= $root ?>'" role="tab" aria-controls="profile" aria-selected="false">Profile</a>
                                </li>
                            </ul> -->
                        </div>
                        <div class="col-sm-12">
                            <!-- Page Heading -->
                            <div class="panel-header">
                                <div class="float-left">
                                    <h1 class="panel-title">PROSPECT FINDER</h1>
                                </div>
                                <div class="clearfix"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div id="">
                    <div class="container">
                        <div class="current-plan-details">
                            <div class="row">
                                <div class="col-md-6">
                                    <form method="POST" id="update_sub_form" action="">
                                        <input type="hidden" name="subscription">
                                        <input type="hidden" name="cutomer_id" id="customer_id" value="<?= $cus_id ?>">
                                        <input type="hidden" name="stripe_plan_id" id="stripe_plan" value="" >
                                        <input type="hidden" name="selected_plan_id" id="plan_id" value="">
                                        <input type="hidden" name="credites_to_add" id="credites_to_add">
                                        <input type="hidden" name="stripe_token" id="stripe_token_create">
                                        <input type="hidden" name="stripe_card_brand" id="stripe_card_brand_create">
                                        <input type="hidden" name="cc_year" id="cc_year_create">
                                        <input type="hidden" name="cc_month" id="cc_month_create">
                                        <input type="hidden" name="cc_4digits" id="cc_4digits_create">
                                        <p style="font-size:13px; color:#888888;">Find Emails addresses for targeted prospects. You’ll get access to our database of 100+ million b2b contacts and their emails. Use custom filters to build your highly targeted prospects list.</p>
                                        <div class="form-group">
                                            <select class="form-control plans-list prospect_plans" id="plan_id" name="plan_id" style="width:100%;">
                                                <option disabled selected>Please Choose a Plan</option>
                                                <?php if($plans->rowcount()>0){ ?>
                                                    <?php foreach ($plans as $row) { ?>
                                                        <option <?php if($row['id'] == $member['prospect_selected_plan']) { echo "selected"; } else{echo "";}; ?> data-planid = '<?= $row['id'] ?>' data-stripeid = '<?= $row['stripe_plan_id_monthly'] ?>' data-credit='<?= $row['credit'] ?>' data-price='<?= $row['price_per_month'] ?>'><?= $row['plan_name'] .'    $'.   $row['price_per_month'].'/'.$row['credit'] ?></option>
                                                    <?php } } ?>
                                            </select>
                                            <div>
                                                <span class=""></span><br>
                                                <span>Billed Today:</span><span class="ml-2" id="price">$<?= $price ?></span><br>
                                                <span>Email CreditsPerMonth:</span><span class="ml-2" id="credits"><?= $credit ?></span><br>
                                                <span>Recurring :</span><span class="ml-2" id="">Annually/Monthly</span>

                                            </div>
                                            <span class="err-plans alert-danger"></span>
                                        </div>
                                        <button disabled class="btn btn-primary cnfrm_btn" type="button"  style="width: 44%;">Confirm</button>
                                    </form>
                                </div>
                                <div class="col-md-5 offset-md-1">
                                    <p><strong>PAYMENT METHOD</strong></p>
                                    <p class="card-info"><img src="<?php  if(empty($member['stripe_card_brand'])){echo $root.'/img/visa'; }else{ echo $root.'/img/'.$member['stripe_card_brand']; }; ?>.png" alt="<?= $member['stripe_card_brand'] ?>"> ****&nbsp;****&nbsp;****&nbsp;<?php echo $member['cc_4digits']; ?> </p>
                                    <a href="#" class="btn btn-md btn-dark btn-update-details"  data-toggle="modal" data-target="#modal-credit-card-info" >Update Details</a>
                                    <div><img class="secure mb-4 mt-2" width="220" src="<?php echo $root; ?>/img/secure-logo.png" alt="norton stripe mcaffee 100% guarantee" /></div>
                                    <p style="font-size:13px; color:#888888;"><strong style="font-size:18px; color:#333333;">100% Satisfaction Guarantee</strong><br/>You are fully protected by our 100% No-Risk Guarantee. Give us a try, and if you aren't completely satisfied, we'll refund 100% of your purchase - no question asked. You have everything to gain by starting with Automailer today!</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php
                $plans = $pdo->prepare('SELECT * FROM `prospect_plans` ');
                $plans->execute();
                ?>
            </div>
            <!-- /.container-fluid -->


        </div>
        <!-- End of Main Content -->
        <?php
        $plans = $pdo->prepare('SELECT * FROM `prospect_plans` ');
        $plans->execute();
        ?>

        <!-- form update all data from modal  -->
        <form method="POST" action="" id="after_update_form">
            <input type="hidden" name="selected_country" id="selected_country">
            <input type="hidden" name="selected_state" id="selected_state">
            <input type="hidden" name="selected_address" id="selected_address">
            <input type="hidden" name="selected_postal_code" id="selected_postal_code">
            <input type="hidden" name="selected_city" id="selected_city">
            <input type="hidden" name="cc_4digits" id="cc_4digits">
            <input type="hidden" name="cc_month" id="cc_month">
            <input type="hidden" name="cc_year" id="cc_year">
            <input type="hidden" name="stripe_card_brand" id="stripe_card_brand">
            <input type="hidden" name="prospect_stripe" id="prospect_stripe">
            <input type="hidden" name="selected_plan_id_after" id="selected_plan_id_after">
            <input type="hidden" name="credites_to_add_drop_after" id="credites_to_add_drop_after">
        </form>
        <!-- end form -->
        <!-- Modal start -->
        <!-- Modal -->
        <div class="modal fade" id="modal-credit-card-info" tabindex="-1" role="dialog" aria-labelledby="edit" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-body">
                        <h4 class="modal-heading">Payment Information</h4>
                        <form action="" id="update-all-info-form" method="post" class="">
                            <input type="hidden" name="update-payment-information">
                            <input type="hidden" name="stripe_plan_id" id="stripe_plan_drop" value="" >
                            <input type="hidden" name="selected_plan_id" id="plan_id_drop" value="">
                            <input type="hidden" name="credites_to_add" id="credites_to_add_drop">
                            <div class="credit-card">
                                <div>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <select class="form-control country-list" id="country_id" name="country_id" style="width:100%;">
                                                    <?php foreach($countries as $c){ ?>
                                                        <option  value="<?php echo $c['id']; ?>" <?php echo $c['id'] == $member['country_id'] ? "selected='selected'" : ''; ?>><?php echo $c['name']; ?></option>
                                                    <?php } ?>
                                                </select>
                                                <label for="">Country</label>
                                                <span class="err-country alert-danger"></span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-7">
                                            <div class="form-group">
                                                <input type="text" name="address" id="address" class="form-control form-control-user" value="<?php echo $member['address']; ?>" required>
                                                <label for="">Street Address</label>
                                                <span class="err-fname alert-danger"></span>
                                            </div>
                                        </div>
                                        <div class="col-md-5">
                                            <div class="form-group">
                                                <input type="text" name="city" id="city" class="form-control form-control-user" value="<?php echo $member['selected_city']; ?>" required>
                                                <label for="">City</label>
                                                <span class="err-fname alert-danger"></span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-7">
                                            <div class="form-group">
                                                <div class="state-input">
                                                    <?php if($member['country_id'] == 225){ ?>
                                                        <select class="form-control state-list" id="state" name="state" style="width:100%;">
                                                            <?php foreach($states as $s){ ?>
                                                                <option value="<?php echo $s['name']; ?>" <?php echo $s['name'] == $member['selected_state'] ? "selected='selected'" : ''; ?> ><?php echo $s['name']; ?></option>
                                                            <?php } ?>
                                                        </select>
                                                    <?php }else{ ?>
                                                        <input type="text" name="state" id="state" class="form-control form-control-user" value="<?php echo $member['selected_state']; ?>">
                                                    <?php } ?>

                                                </div>
                                                <label for="">State</label>
                                                <span class="err-fname alert-danger"></span>
                                            </div>
                                        </div>
                                        <div class="col-md-5">
                                            <div class="form-group">
                                                <input type="text" name="postal_code" id="postal_code" class="form-control form-control-user" value="<?php echo $member['selected_postal_code']; ?>" required>
                                                <label for="">Postal Code</label>
                                            </div>
                                        </div>
                                    </div>
                                    <?php if(!empty($member['prospect_stripe'])){ ?>
                                        <input type="hidden" id="old_subscription" value="<?= json_decode($member['prospect_stripe'])->id; ?>">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <select class="form-control drop_plans"  id="" name="" style="width:100%;">
                                                        <?php if($plans->rowcount()>0){ ?>
                                                            <?php foreach ($plans as $row) { ?>
                                                                <option <?php if($row['id'] == $member['prospect_selected_plan']) { echo "selected"; } else{echo "";}; ?> data-planid = '<?= $row['id'] ?>' data-stripeid = '<?= $row['stripe_plan_id_monthly'] ?>' data-credit='<?= $row['credit'] ?>' data-price='<?= $row['price_per_month'] ?>'><?= $row['plan_name'] .'    $'.   $row['price_per_month'].'/'.$row['credit'] ?></option>
                                                            <?php } } ?>
                                                    </select>
                                                    <label for="">Plans</label>
                                                    <span class="err-country alert-danger"></span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row" id="stripe_card" style="display: none;">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <div id="card-element-drop" class="form-control"></div>
                                                    <label for="">Credit or Debit Card</label>
                                                    <div id="card-errors-drop" role="alert"></div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php } ?>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                <button type="button" onclick="payment_form()" class="btn btn-success btn-payment-information" name="">Save Changes</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- Modal End -->

        <!-- Modal -->
        <div class="modal fade" id="modal-credit-card-info-number" tabindex="-1" role="dialog" aria-labelledby="edit" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-body">
                        <h4 class="modal-heading">Card Information</h4>
                        <form action="" id="" method="post" class="">
                            <div class="credit-card">
                                <div>
                                    <div class="row" id="stripe_card">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <div id="card-element" class="form-control"></div>
                                                <label for="">Credit or Debit Card</label>
                                                <div id="card-errors-drop" role="alert"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                <button type="button" onclick="create_token()" class="btn btn-success btn-payment-information" name="">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- Modal End -->
        <!-- Footer -->
        <footer class="sticky-footer bg-white">
            <div class="container my-auto">
                <div class="copyright text-center my-auto">
                    <span>Copyright &copy; <?php echo date('Y'); ?></span>
                </div>
            </div>
        </footer>
        <!-- End of Footer -->

    </div>
    <!-- End of Content Wrapper -->

</div>
<!-- End of Page Wrapper -->

<!-- Scroll to Top Button-->
<a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
</a>
<script src="https://js.stripe.com/v3/"></script>

<script>
    var style = {
        base: {
            color: '#32325d',
            fontFamily: '"Helvetica Neue", Helvetica, sans-serif',
            fontSmoothing: 'antialiased',
            fontSize: '16px',
            '::placeholder': {
                color: '#aab7c4'
            }
        },
        invalid: {
            color: '#fa755a',
            iconColor: '#fa755a'
        }
    };
    var newStripe 		  = Stripe('<?php echo $new_stripe_pk; ?>');
    var newStripeElements = newStripe.elements();
    var newCard   = newStripeElements.create('card', {hidePostalCode: true,style: style});
    var displayError = document.getElementById('card-errors-drop');
    '<?php if(!empty($member['prospect_stripe'])){ ?>'
    newCard.mount('#card-element-drop');
    '<?php } ?>'



    $(".prospect_plans").change(function(){
        var price = $(this).find(':selected').data('price');
        var credit = $(this).find(':selected').data('credit');
        var plan_id = $(this).find(':selected').data('planid');
        var stripe_plan = $(this).find(':selected').data('stripeid');
        $("#price").text('$'+price);
        $("#credits").text(credit);
        $("#plan_id").val(plan_id);
        $("#stripe_plan").val(stripe_plan);
        $("#credites_to_add").val(credit);
        $(".cnfrm_btn").removeAttr('disabled');
    });
    $('.drop_plans').change(function(){
        $("#stripe_card").css('display','');
        var price = $(this).find(':selected').data('price');
        var credit = $(this).find(':selected').data('credit');
        var plan_id = $(this).find(':selected').data('planid');
        var stripe_plan = $(this).find(':selected').data('stripeid');
        newCard.unmount('#card-element');
        newCard.mount('#card-element-drop');
        $("#plan_id_drop").val(plan_id);
        $("#stripe_plan_drop").val(stripe_plan);
        $("#credites_to_add_drop").val(credit);
    });

    $(".plans_info").change(function(){
        var credit = $(this).find(':selected').data('credit');
        $("#plan_info_credits").text(credit);
    });
    $("#country_id").change(function(){
        var country_id = $("#country_id").val();
        var url = root_dir + "/ajax_state_input.php";
        $.ajax({
            type: "POST",
            url: url,
            data: {country_id:country_id},
            success: function(o)
            {
                $(".state-input").html(o);
                $(".state-list").select2();
            }
        });
    });

    newCard.addEventListener('change', function(event) {
        if (event.error) {
            displayError.textContent = event.error.message;
        } else {
            displayError.textContent = '';
        }
    });

    function payment_form()
    {
        if(!$("#stripe_card").is(":visible")){
            $("#update-all-info-form").submit();
        }
        newStripe.createToken(newCard).then(function(result) {
            if (result.error) {
                displayError.textContent = result.error.message;
            }else {
                $("#selected_country").val($("#country_id").val());
                $("#selected_state").val($("#state").val());
                $("#selected_address").val($("#address").val());
                $("#selected_postal_code").val($("#postal_code").val());
                $("#selected_city").val($("#city").val());
                $.post('<?php echo $root; ?>/_new_stripe_upgrade_downgrade.php', {
                    token: result.token.id,
                    plan: $('#stripe_plan_drop').val(),
                    plan_qty: 1,
                    sub_id: $("#old_subscription").val(),
                    cus_id: $("#customer_id").val()
                }).done(function(data){
                    if(data != 0)
                    {
                        data = jQuery.parseJSON(data)
                        $('#prospect_stripe').val(JSON.stringify(data.data));
                        $("#cc_4digits").val(result.token.card.last4);
                        $("#cc_month").val(result.token.card.exp_month);
                        $("#cc_year").val(result.token.card.exp_year);
                        $("#stripe_card_brand").val(result.token.card.brand);
                        $("#selected_plan_id_after").val($("#plan_id_drop").val());
                        $("#credites_to_add_drop_after").val($("#credites_to_add_drop").val());
                        setTimeout(function(){
                            $("#after_update_form").submit();
                        }, 1000);
                    }
                    else
                    {
                        alert('Error verifying your payment method, please double check and try again.');
                    }
                });
            }
        });
    }
    $(".cnfrm_btn").click(function(){
        if($("#customer_id").val()=="")
        {
            newCard.unmount('#card-element-drop');
            newCard.mount('#card-element');
            $("#modal-credit-card-info-number").modal('show');
            return false;
        }
        $("#update_sub_form").submit();
    });

    function create_token()
    {
        newStripe.createToken(newCard).then(function(result) {
            if (result.error) {
                displayError.textContent = result.error.message;
            }else {
                $("#cc_4digits_create").val(result.token.card.last4);
                $("#cc_month_create").val(result.token.card.exp_month);
                $("#cc_year_create").val(result.token.card.exp_year);
                $("#stripe_card_brand_create").val(result.token.card.brand);
                $("#stripe_token_create").val(result.token.id);
                $("#update_sub_form").submit();
            }
        });
    }
</script>

