  <title>Register</title>
</head>

<body class="bg-gradient-primary">

  <nav class="navbar navbar-expand-lg navbar-dark" style="background: #0089FF; padding: 1rem 5rem;">
    <a href="<?php echo $root; ?>" class="navbar-brand">
      <img src="<?php echo $root; ?>/img/logo-placeholder.png">
    </a>
    <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarText" aria-controls="navbarText" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navbarText">
      <ul class="navbar-nav ml-auto">
        <li class="nav-item active">
          <a class="btn btn-outline-secondary text-white ml-4" href="<?php echo $root; ?>">Home <span class="sr-only">(current)</span></a>
        </li>
        <li class="nav-item">
          <a class="btn btn-outline-secondary text-white ml-4" href="#" data-toggle="modal" data-target="#pricingModal">Pricing</a>
        </li>
        <li class="nav-item">
          <a class="btn btn-success ml-4" href="<?php echo $root; ?>/login">Login</a>
        </li>
      </ul>
    </div>
  </nav>

  <div class="container">

    <!-- Outer Row -->
    <div class="row justify-content-center">

      <div class="col-xl-10 col-lg-12 col-md-9">

        <div class="card o-hidden border-0 shadow-lg" style="margin-top: 4vw;">
          <div class="card-body p-5">
            <!-- Nested Row within Card Body -->
            <div class="row">
              <div class="col-sm-12">
                <div class="text-center">
                  <?php
                  if(isset($_POST['plan']))
                  {
                    switch ($_POST['plan']) {
                      case '1':
                        $plan = 'Professional';
                        $text = '$29/month';
                        break;
                      case '2':
                        $plan = 'Business';
                        $text = '$69/month';
                        break;
                      case '3':
                        $plan = 'Enterprise';
                        $text = '$109/month incl. 14 day free trial';
                        break;
                    }
                  }
                  else
                  {
                    $_POST['plan'] = 1;
                    $plan = 'Professional';
                    $text = '$29/month';
                  }
                  ?>
                  <h1 class="h4 text-gray-900 mb-4">Create an account - <span class="text-muted"><?php echo $plan.' '.$text; ?></span></h1>
                </div>
                <?php

                if(!empty($_POST['fname']))
                {
                  
                  foreach ($_POST as $key => $value) {
                    $_POST[$key] = htmlspecialchars($value, ENT_QUOTES);
                  }

                  if($_POST['rpassword'] == $_POST['password'])
                  {
                     //  A couple other signup checks
                     $validSignup = true;

                    if (empty($_POST['password']))
                    {
                        echo '<p class="text-danger mb-4">Error: Password is required.</p>';
                        $validSignup = false;
                    }

                    if (empty($_POST['email']))
                    {
                        echo '<p class="text-danger mb-4">Error: Email Address is required.</p>';
                        $validSignup = false;
                    }

                    if (empty($_POST['username']))
                    {
                        echo '<p class="text-danger mb-4">Error: Username is required.</p>';
                        $validSignup = false;
                    }

                      $isUsernameExists = $pdo->prepare('SELECT * FROM `members` WHERE `username`=?');
                      $isUsernameExists->execute(array($_POST['username']));
                      if( $isUsernameExists->rowcount() > 0)
                      {
                        echo '<p class="text-danger mb-4">Error: Username already exists.</p>';
                        $validSignup = false;

                      }
                      // Check if email exists for forgot password....
                      $isEmailExists = $pdo->prepare('SELECT * FROM `members` WHERE `email`=?');
                      $isEmailExists->execute(array($_POST['email']));

                      if( $isEmailExists->rowcount() > 0)
                      {
                            echo '<p class="text-danger mb-4">Error: Email already exists.</p>';
                            $validSignup = false;
                      }



                    if ($validSignup == true)
                    {
                        $q = $pdo->prepare('INSERT INTO `members` (fname,lname,email,username,password,plan,stripe,timezone,date_created,status,parent_id,account_type) VALUES (?,?,?,?,?,?,?,?,?,?)');
                        $q->execute(array(
                            $_POST['fname'],
                            $_POST['lname'],
                            $_POST['email'],
                            $_POST['username'],
                            password_hash($_POST['password'], PASSWORD_BCRYPT),
                            $_POST['plan'],
                            base64_decode($_POST['stripe']),
                            //$_SESSION['timezone'],
                            $_POST['user_timezone'],
                            strtotime(date("Y-m-d")),
                            1,
                            0,
                            0
                        ));

                        $_SESSION['id'] = $pdo->lastInsertId();
                        header('Location: ' . $root);

                        exit();
                    }

                  }
                  else
                  {
                    echo '<p class="text-danger mb-4">Error: Passwords do not match.</p>';
                  }
                }
                ?>
                <form class="user" action="" method="post" id="register_form">
                  <div class="row">
                    <div class="col-lg-6" style="margin-bottom: 10px;">
                      <?php 
                        $timezones = $pdo->prepare('SELECT * FROM `timezones`');
                        $timezones->execute();
                      ?>
                      <select class="form form-control timezone-list" name="user_timezone" required="">
                        <option value="">-- Select timezone --</option>
                        <?php foreach($timezones as $value){ ?>
                          <option value="<?php echo $value['timezone']; ?>"><?php echo $value['utc_gmt'] . " - " . $value['timezone']; ?></option>
                        <?php } ?>
                      </select>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-lg-6" style="margin-bottom: 10px;">
                      <input type="text" name="fname" class="form-control form-control-user" placeholder="First name" required>
                    </div>
                    <div class="col-lg-6" style="margin-bottom: 10px;">
                      <input type="text" name="lname" class="form-control form-control-user" placeholder="Last name" required>
                    </div>
                    <div class="col-lg-6" style="margin-bottom: 10px;">
                      <input type="text" name="email" class="form-control form-control-user" placeholder="Email" required>
                    </div>
                    <div class="col-lg-6" style="margin-bottom: 10px;">
                      <input type="text" name="username" class="form-control form-control-user" placeholder="Choose a username" required>
                    </div>
                    <div class="col-lg-6" style="margin-bottom: 10px;">
                      <input type="password" name="password" class="form-control form-control-user" placeholder="Choose a password" required>
                    </div>
                    <div class="col-lg-6" style="margin-bottom: 10px;">
                      <input type="password" name="rpassword" class="form-control form-control-user" placeholder="Repeat password" required>
                    </div>
                    <div class="col-sm-12">
                      <input type="hidden" name="plan" value="<?php echo @$_POST['plan']; ?>">
                      <input type="hidden" name="stripe" id="stripe">
                      <input type="submit" name="submitBtn" id="submitBtn" style="display: none;">
                      <button type="button" class="btn btn-danger btn-user btn-block" id="add_billing_info">Next - Billing Information</button>
                      <hr/>
                    </div>
                  </div>
                </form>

                <script src="https://js.stripe.com/v3/"></script>

                <form action="/charge" method="post" id="payment-form" class="user" style="display: none;">
                  <div class="form-row">
                    <label for="card-element">
                      Credit or debit card
                    </label>
                    <div id="card-element" class="form-control">
                      <!-- A Stripe Element will be inserted here. -->
                    </div>

                    <!-- Used to display form errors. -->
                    <div id="card-errors" role="alert"></div>
                  </div>
                  <button class="btn btn-danger btn-user btn-block mt-2" style="margin-left: -5px;" id="verify_payment_method">Complete registration</button>
                  <hr/>
                </form>

                <div class="text-center">
                  <small>Already have an account?</small><br/>
                  <a class="small" href="<?php echo $root; ?>/login">Login</a>
                </div>
              </div>
            </div>
          </div>
        </div>

      </div>

    </div>

  </div>