<?php
checkSuperAdmin();
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);
?>

<title><?php echo SITE_NAME; ?> - Tutorial Management</title>


<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.2.0/css/bootstrap.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.8.1/css/bootstrap-select.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.8.1/js/bootstrap-select.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.2.0/js/bootstrap.min.js"></script>

</head>

<body id="page-top">

<!-- Page Wrapper -->
<div id="wrapper">

    <?php include_once("nav_wrapper_admin.php"); ?>

    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column">

        <!-- Main Content -->
        <div id="content">

            <!-- Topbar -->
            <nav class="navbar navbar-expand navbar-light topbar mb-4 static-top shadow">

                <!-- Sidebar Toggle (Topbar) -->
                <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
                    <i class="fa fa-bars"></i>
                </button>



                <!-- Topbar Navbar -->
                <ul class="navbar-nav ml-auto">



                    <div class="topbar-divider d-none d-sm-block"></div>

                    <!-- Nav Item - User Information -->
                    <li class="nav-item dropdown no-arrow">
                        <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <span class="mr-2 d-none d-lg-inline text-white small"><?php echo $member['firstname'].' '.$member['lastname']; ?></span>
                        </a>
                        <!-- Dropdown - User Information -->
                        <div class="dropdown-menu dropdown-menu-right shadow animated--grow-in" aria-labelledby="userDropdown">
                            <a class="dropdown-item" href="<?php echo $root; ?>/settings">
                                <i class="fas fa-cogs fa-sm fa-fw mr-2 text-gray-400"></i>
                                Settings
                            </a>
                            <div class="dropdown-divider"></div>
                            <a class="dropdown-item" href="<?php echo $root; ?>/?logout=1">
                                <i class="fas fa-sign-out-alt fa-sm fa-fw mr-2 text-gray-400"></i>
                                Logout
                            </a>
                        </div>
                    </li>

                </ul>

            </nav>
            <!-- End of Topbar -->

            <!-- Begin Page Content -->
            <div class="container-fluid">

                <!-- Page Heading -->
                <div class="float-left">
                    <h1 class="h3 mb-4 text-gray-800">Tutorial Management</h1>
                </div>
                <div class="float-right" style="margin-right: 10vw;">

                </div>
                <div class="clearfix"></div>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="card shadow mb-4">
                            <div class="card-header bg-dark py-3">
                                <div class="float-left">
                                    <h6 class="m-0 font-weight-bold text-white">Tutorial Management</h6>
                                </div>
                                <div class="clearfix"></div>
                            </div>
                            <?php
                            if(isset($_POST['action'])){
                                if($_POST['action']=='tutorial_save'){
                                    $serial =  serialize($_POST['categorypic']);
                                    $tutorial_data = array(
                                        $_POST['title'],
                                        $_POST['description'],
                                        $serial,
                                        $_POST['yt_embed_code'],
                                        $_POST['yt_id'],
                                        time(),
                                        time()
                                    );
                                    $q = $pdo->prepare('INSERT INTO `tutorial` (title,description,category_id,yt_embed_code,yt_id,date_created,date_modified) VALUES (?,?,?,?,?,?,?)');
                                    $q->execute($tutorial_data);

                                    echo '
                      <div class="alert alert-success" role="alert">
                        New tutorial was successfully added!
                      </div>
                      ';
                                }elseif($_POST['action']=='tutorial_update'){
                                    $serial =  serialize($_POST['selectpic_edit']);
                                    $tutorial_data = array(
                                        $_POST['tutorial_title'],
                                        $_POST['tutorial_description'],
                                        $serial,
                                        $_POST['tutorial_yt_embed_code'],
                                        $_POST['tutorial_yt_preview_image'],
                                        time(),
                                        $_POST['tutorial_id']
                                    );
                                    $q = $pdo->prepare('UPDATE `tutorial` SET `title`=?,`description`=?, `category_id`=?, `yt_embed_code`=?, `yt_id`=?, `date_modified`=?  WHERE `id`=?');
                                    $q->execute($tutorial_data);

                                    echo '<div class="alert alert-success">
                       Tutorial was successfully updated.
                      </div>';
                                }elseif($_POST['action']=='tutorial_delete'){
                                    $q = $pdo->prepare('DELETE FROM `tutorial` WHERE `id`=?');
                                    $q->execute(array($_POST['hid']));
                                    echo '<div style="margin-bottom:2rem;">';
                                    echo '<div class="alert alert-success" role="alert"> Tutorial was successfully deleted</div></div>';
                                }
                            }

                            ?>
                            <div class="card-body">
                                <button class="btn btn-primary" style="margin-top: 15px;" data-toggle="modal" data-target="#addTutorial">Add New Tutorial</button>
                                <?php
                                $q = $pdo->prepare('SELECT id,title,description,category_id,yt_id,yt_embed_code,date_created FROM `tutorial` ORDER by id DESC');
                                $q->execute();
                                ?>
                                <?php if($q->rowcount()>0){ ?>
                                <br/><br/>
                                <table class="table admin-help-datatable datatable">
                                    <thead class="bg-default text-dark">
                                    <tr>
                                        <th scope="col" style="width: 70%;">TURORIAL TITLE</th>
                                        <th scope="col">DATE CREATED</th>
                                        <th scope="col">ACTION</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php foreach ($q as $row) { ?>
                                        <tr>
                                            <td scope="col"><?php echo $row['title']; ?></td>
                                            <td scope="col"><?php echo date("Y-m-d",$row['date_created']); ?></td>
                                            <td scope="col">
                                                <div class="dropdown">
                                                    <button class="btn btn-primary dropdown-toggle" type="button" data-toggle="dropdown">Action
                                                        <span class="caret1"></span></button>
                                                    <ul class="dropdown-menu">
                                                        <li>
                                                            <a href="javascript:void(0)" class="btn  btn-sm btn-tutorial-delete dropdown-item" data-key="<?php echo $row['id']; ?>" title="Delete"><i class="fas fa-trash-alt"></i> Delete</a>
                                                        </li>
                                                        <li>
                                                            <a href="javascript:void(0);" class="btn  btn-sm dropdown-item" data-toggle="modal" data-target="#editTutorial<?php echo $row['id']; ?>" title="Edit"><i class="fas fa-pencil-alt"></i> Edit</a>
                                                    </ul>
                                                </div>

                                                <!-- Modal for Edituser -->
                                                <div class="modal fade" id="editTutorial<?php echo $row['id']; ?>" tabindex="-1" role="dialog" aria-labelledby="editTutorialLabel" aria-hidden="true">
                                                    <div class="modal-dialog modal-lg" role="document" style="margin-top: 10vw;">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 class="modal-title" id="addIMAPLabel">Edit Tutorial</h5>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <form action="" method="post">
                                                                <div class="modal-body">
                                                                    <input type="hidden" name="tutorial_id" value="<?php echo $row['id']; ?>" />
                                                                    <div class="row">
                                                                        <div class="col-md-12">
                                                                            <label style="display: block; margin-top: 10px;">Tutorial title: *</label>
                                                                            <input type="text" name="tutorial_title" class="form-control" value="<?php echo $row['title'];?>">
                                                                        </div>
                                                                    </div>
                                                                    <div class="row">
                                                                        <div class="col-md-12">
                                                                            <label style="display: block; margin-top: 10px;">Description: *</label>
                                                                            <textarea class="form-control ckeditor" rows="7" data-gramm="false" name="tutorial_description"><?php echo $row['description']; ?></textarea>
                                                                        </div>
                                                                    </div>

                                                                    <div class="row">
                                                                        <div class="col-md-12">
                                                                            <label style="display: block; margin-top: 10px;">Category Name: *</label>
                                                                            <?php
                                                                            $q = $pdo->prepare('SELECT id,category_name FROM `tutorial_category` ORDER by id DESC');
                                                                            $q->execute();
                                                                            ?>
                                                                            <select id="selectpic_edit[]" name="selectpic_edit[]" class="selectpicker form-control" multiple data-live-search="true">
                                                                                <?php
                                                                                $category_list = unserialize($row['category_id']);
                                                                                foreach ($q as $row_edit) {
                                                                                    $select = false;
                                                                                    foreach ($category_list as $key => $value) {
                                                                                        if($row_edit['id'] == $value){
                                                                                            $select = true;
                                                                                        }
                                                                                    }
                                                                                    ?>
                                                                                    <option <?php if($select){ ?> selected  <?php } ?> value="<?php echo $row_edit['id'] ?>"><?php echo $row_edit['category_name'] ?></option>
                                                                                <?php } ?>
                                                                            </select>
                                                                        </div>
                                                                    </div>

                                                                    <div class="row">
                                                                        <div class="col-md-12">
                                                                            <label style="display: block; margin-top: 10px;">Youtube Embed Code: *</label>
                                                                            <textarea class="form-control ckeditor" data-gramm="false" rows="7" name="tutorial_yt_embed_code"><?php echo $row['yt_embed_code']; ?></textarea>
                                                                        </div>
                                                                    </div>
                                                                    <div class="row">
                                                                        <div class="col-md-12">
                                                                            <label style="display: block; margin-top: 10px;">Youtube Preview link: *</label>
                                                                            <input type="text" name="tutorial_yt_preview_image" class="form-control" value="<?php echo $row['yt_id']; ?>">
                                                                        </div>
                                                                    </div>

                                                                </div>
                                                                <div class="modal-footer">
                                                                    <button type="submit" class="btn btn-primary" name="action" value="tutorial_update">Update</button>
                                                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <?php } ?>

                        <!-- Modal Add -->
                        <div class="modal fade" id="addTutorial" tabindex="-1" role="dialog" aria-labelledby="addTutorialLabel" aria-hidden="true">
                            <div class="modal-dialog modal-lg" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="addTutorialLabel">Add Tutorial Video</h5>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <form action="" method="post">
                                        <div class="modal-body">
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <label style="display: block; margin-top: 10px;">Tutorial title: *</label>
                                                    <input type="text" name="title" class="form-control">
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <label style="display: block; margin-top: 10px;">Description: *</label>
                                                    <textarea class="form-control ckeditor" rows="7" data-gramm="false" name="description"></textarea>
                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="col-md-12">
                                                    <label style="display: block; margin-top: 10px;">Category Name: *</label>
                                                    <?php
                                                    $q = $pdo->prepare('SELECT id,category_name FROM `tutorial_category` ORDER by id DESC');
                                                    $q->execute();
                                                    ?>
                                                    <select id="categorypic[]" name="categorypic[]" class="selectpicker form-control" multiple data-live-search="true">
                                                        <?php foreach ($q as $row) { ?>
                                                            <option value="<?php echo $row['id'] ?>"><?php echo $row['category_name'] ?></option>
                                                        <?php } ?>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="col-md-12">
                                                    <label style="display: block; margin-top: 10px;">Youtube Embed Code: *</label>
                                                    <textarea class="form-control ckeditor" rows="7" data-gramm="false" name="yt_embed_code"></textarea>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <label style="display: block; margin-top: 10px;">Youtube Preview link: *</label>
                                                    <input type="text" name="yt_id" class="form-control">
                                                </div>
                                            </div>

                                        </div>
                                        <div class="modal-footer">
                                            <button type="submit" class="btn btn-primary" name="action" value="tutorial_save">Save</button>
                                            <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                        <!-- Modal Delete Confirmation -->
                        <div class="modal fade modal-enhanced modal-danger" id="modalDeleteConfirmation" tabindex="-1" role="dialog" aria-labelledby="modalDeleteConfirmationlabel" aria-hidden="true">
                            <div class="modal-dialog modal-md" role="document">
                                <form action="#" method="post">
                                    <input type="hidden" value="" name="hid" class="hid">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title"><i class="far fa-trash-alt"></i> Delete</h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <div class="modal-body">
                                            <div class="autoreply-selected-msg">Delete selected Tutorial page?</div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-default" data-dismiss="modal">No</button>
                                                <button type="submit" class="btn btn-danger" name="action" value="tutorial_delete">Yes</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>

                    </div>

                </div>

            </div>
            <!-- /.container-fluid -->

        </div>
        <!-- End of Main Content -->



        <!-- Footer -->
        <footer class="sticky-footer bg-white">
            <div class="container my-auto">
                <div class="copyright text-center my-auto">
                    <span>Copyright &copy; <?php echo date('Y'); ?></span>
                </div>
            </div>
        </footer>
        <!-- End of Footer -->

    </div>
    <!-- End of Content Wrapper -->

</div>
<!-- End of Page Wrapper -->

<!-- Scroll to Top Button-->
<a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
</a>

<script>
    $(document).ready(function () {
        $("#selectpic").selectpicker();
        $("#selectpic_edit").selectpicker();
    });

    $(function(){
        $(".btn-tutorial-delete").click(function(){
            var hid = $(this).attr("data-key");
            $(".hid").val(hid);
            $("#modalDeleteConfirmation").modal('show');
        });
    });
</script>
