<?php 
//use PHPMailer\PHPMailer\PHPMailer;
//use PHPMailer\PHPMailer\Exception;
//use PhpImap\Exceptions\ConnectionException;

include 'config.php';
include 'functions.php';
//require_once 'PHPMailer/autoload.php';

$profile = get_oauth2_token($_POST['token'], $googleClientId, $googleSecretId);
$q = $pdo->prepare('SELECT * FROM `nylas_smtp` WHERE `identifier`=? AND `member_id`=? LIMIT 1');
$q->execute(array($profile['user']->id, $_SESSION['id']));
$gmail_account = $q->fetch(PDO::FETCH_ASSOC);

if($q->rowcount()<1)
{
    $mmember = $pdo->prepare('SELECT * FROM `members` WHERE `id`=? ');
    $mmember->execute(array($_SESSION['id']));
    $mmember = $mmember->fetch(PDO::FETCH_ASSOC);
    date_default_timezone_set($mmember['timezone']);

    //Default Settings
    $limit_per_day = 25;
    $allowed_time_from = strtotime("7:00 AM");
    $allowed_time_to   = strtotime("5:00 PM");
    $time_between_email_sent = 20;
    $max_email_per_time      = 1;





    $from_name = $profile['user']->given_name;
    $from_email = $profile['user']->email;
    $refresh_token = $profile['refreshToken'];

    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => "https://api.nylas.com/connect/authorize",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_POSTFIELDS =>"{\n    \"client_id\": \"".NYLAS_CLIENT_ID."\",\n    \"name\": \"$from_name\",\n    \"email_address\": \"$from_email\",\n    \"provider\": \"gmail\",\n    \"settings\": {\n        \"google_refresh_token\": \"$refresh_token\",\n        \"google_client_id\": \"$googleClientId\",\n        \"google_client_secret\": \"$googleSecretId\"\n    },\n    \"scopes\": \"email\"\n}",
        CURLOPT_HTTPHEADER => array(
            "Content-Type: application/json"
        ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);


    $res = json_decode($response);

    if(isset($res->code) && !empty($res->code)){


        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://api.nylas.com/connect/token",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "POST",
            CURLOPT_POSTFIELDS =>"{\n    \"client_id\": \"".NYLAS_CLIENT_ID."\",\n    \"client_secret\": \"".NYLAS_CLIENT_SECRET."\",\n    \"code\": \"$res->code\"\n}",
            CURLOPT_HTTPHEADER => array(
                "Content-Type: application/json"
            ),
        ));

        $response = curl_exec($curl);

        $res_token = json_decode($response);

        curl_close($curl);

        if(!empty($res_token->access_token)){

            //upgrade account if some issue like delete and again if you add issue
            $encode_auth = base64_encode(NYLAS_CLIENT_SECRET.':');

            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => "https://api.nylas.com/a/".NYLAS_CLIENT_ID."/accounts/".$res_token->account_id."/upgrade",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "POST",
                CURLOPT_HTTPHEADER => array(
                    "Content-Type: application/json",
                    "Authorization: Basic ".$encode_auth
                ),
            ));

            $response = curl_exec($curl);

            curl_close($curl);

            //end

            $nylas_access_token = $res_token->access_token;
            $nylas_account_id = $res_token->account_id;

        }else{

            $_SESSION['error_msg'] =  "Something wrong with gmail account, please try again!";
            echo json_encode(array('result' => 0));
        }


    }else{
        $_SESSION['error_msg'] =  "Something wrong with gmail account, please try again!";
        echo json_encode(array('result' => 0));
    }


    $q = $pdo->prepare('INSERT INTO `nylas_smtp` (smtp_type,name,
                                                        email,
                                                        username,
                                                        password,
                                                        server,
                                                        port,
                                                        imap_server,
                                                        imap_port,
                                                        created,
                                                        send_limit,
                                                        member_id,
                                                        digital_sign,
                                                        sending_limit_per_day,
                                                        allowed_time_send_from,
                                                        allowed_time_send_to,
                                                        time_between_email_send,
                                                        max_email_per_time,
                                                        nylas_account_id,nylas_access_token,usessltls,active,access_token,refresh_token,identifier) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)');
    $q->execute(
        array(
            'gmail',
            $profile['user']->given_name,
            $profile['user']->email,
            '',
            '',
            '',
            0,
            '',
            0,
            date('Y-m-d H:i:s'),
            200,
            $_SESSION['id'],
            NULL,
            $limit_per_day,
            $allowed_time_from,
            $allowed_time_to,
            $time_between_email_sent,
            $max_email_per_time,
            $nylas_account_id,
            $nylas_access_token,
            1,
            1,
            $profile['access_token'],
            $profile['refreshToken'],
            $profile['user']->id
        )
    );
    //print_r($q->errorInfo());

    //$_SESSION["gmail_id"] = $pdo->lastInsertId();
    $_SESSION["smtp_id"] = $pdo->lastInsertId();

    //$receiver = $profile['user']->email;
    //$receiver = 'jeniel.mangahis.work@gmail.com';
//    $message  = "<p>Hi</p><p>This email, <b>" . $receiver . "</b>, has been successfully connected to automailer.</p><br /><p>Thank you!</p>";
//
//    PhpMailerSendEmail($receiver,'Automailer : Email Connection',$message);
    /*
    $mail = new PHPMailer();
    $mail->IsSMTP();
    $mail->XMailer = ' ';
    $mail->Host = 'sourceitmarketing.com';
    $mail->SMTPAuth = true;
    $mail->Username = 'jeniel@sourceitmarketing.com';
    $mail->Password = 'DevEmail45!';
    $mail->Port = 587;
    $mail->IsHTML(true);                             
    $mail->setFrom('webmaster@sourceitmarketing.com');
    $mail->FromName = 'webmaster@sourceitmarketing.com';
    $mail->AddAddress($receiver);
    $mail->Body = $message;
    $mail->Subject = 'Automailer : Email Connection';
    $mail->Send();
    */
}else{
    if( $gmail_account['refresh_token'] == '' && $profile['refreshToken'] != '' ){
        $q = $pdo->prepare('UPDATE `nylas_smtp` SET `refresh_token`=?, `access_token`=?, active = 1 WHERE `identifier`=?');
        $q->execute(array($profile['refreshToken'], $profile['access_token'], $profile['user']->id));
    }    
}
$_SESSION['success_msg'] =  "Gmail account successfully added!";
echo json_encode(array('result' => 1, 'token' => $profile['access_token']));
?>