  <title><?php echo SITE_NAME; ?> - Integrations</title>
</head>

<body id="page-top">

  <!-- Page Wrapper -->
  <div id="wrapper">

    <?php include_once("nav_wrapper.php"); ?>

    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column">

      <!-- Main Content -->
      <div id="content">

        <!-- Topbar Navbar -->
        <?php include_once("nav/right_nav.php"); ?>

        <!-- Begin Page Content -->
        <div class="container-fluid">

          <!-- Page Heading -->
          <div class="float-left">
            <h1 class="h3 mb-4 text-gray-800">Integrations</h1>
          </div>
          <div class="float-right" style="margin-right: 10vw;">

          </div>
          <div class="clearfix"></div>
          

          <div class="row">

            <div class="col-sm-12">

              <?php

              $plan = 3; // $member['plan']

              if($plan<2)
              {
                ?>
                <div class="card shadow mb-4">
                  <div class="card-header bg-dark py-3">
                    <div class="float-left">
                      <h6 class="m-0 font-weight-bold text-white">SMTP and IMAP integration</h6>
                    </div>
                    <div class="float-right">
                      
                    </div>
                    <div class="clearfix"></div>
                  </div>
                  <div class="card-body">
                    SMTP and IMAP integration not available on this plan.
                    <br/>
                    <a class="btn btn-warning" style="margin-top: 15px;" href="<?php echo $root; ?>/settings/upgrade" data-toggle="tooltip" data-placement="right" title="To enable SMTP email, please upgrade your plan. This will allow you to send email from any email address you own.">Upgrade</a>
                  </div>
                </div>
                <?php
              }
              else
              {
 
              if(isset($_GET['removeIMAP']))
              {
                $q = $pdo->prepare('DELETE FROM `imap` WHERE `id`=? AND `member_id`=? LIMIT 1');
                $q->execute(array($_GET['removeIMAP'], $_SESSION['id']));
              }


              if(isset($_POST['from_name']))
              {
				        $passwordD = crypt_jm($_POST['password']);
                $q = $pdo->prepare('INSERT INTO `smtp` VALUES (?,?,?,?,?,?,?,?,?)');
                $q->execute(array($_POST['from_name'], $_POST['from_email'], $_POST['user'], $passwordD, $_POST['server'], $_POST['port'], 200, $member['id'],$_POST['is_ssl'], NULL));
                echo '
                <div class="alert alert-success" role="alert">
                  SMTP account successfully added!
                </div>
                ';
              }

              if(isset($_POST['IMAPuser']))
              {               
        				$passwordD = crypt_jm($_POST['password']);  
                $q = $pdo->prepare('INSERT INTO `imap` VALUES (?,?,?,?,?,?,?)');
                $q->execute(array($_POST['IMAPuser'], $passwordD, $_POST['server'], $_POST['port'], $member['id'], NULL, $_POST['is_ssl']));
                echo '
                <div class="alert alert-success" role="alert">
                  IMAP account successfully added!
                </div>
                ';
              }


              ?>

              <div class="card shadow mb-4">
                <div class="card-header bg-dark py-3">
                  <div class="float-left">
                    <h6 class="m-0 font-weight-bold text-white">IMAP Integration</h6>
                  </div>
                  <div class="float-right">
                     
                  </div>
                  <div class="clearfix"></div>
                </div>
                <div class="card-body">
                  Add IMAP (incoming mail server details) if you want to track incoming replies and bounces.<br/>
                  <button class="btn btn-primary" style="margin-top: 15px;" data-toggle="modal" data-target="#addIMAP">Add IMAP Integration</button>
                  <?php
                  $q = $pdo->prepare('SELECT * FROM `imap` WHERE `member_id`=?');
                  $q->execute(array($member['id']));
                  if($q->rowcount()>0)
                  {
                  ?>
                  <br/><br/>
                  <table class="table table-striped table-hover table-bordered">
                    <thead class="bg-default text-dark">
                      <tr>
                        <th scope="col">USER</th>
                        <th scope="col">SERVER</th>
                        <th scope="col">PORT</th>
                        <th scope="col">SSL</th>
                        <th scope="col">ACTIONS</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php
                      foreach ($q as $row) {
                        if($row['is_ssl'] == 0)
                        {
                          $is_ssl = "No"; 
                        }else{ 
                          $is_ssl = "Yes"; 
                        }

                        echo '
                        <tr>
                          <td scope="col">'.$row['user'] .'</td>
                          <td scope="col">'.$row['server'].'</td>
                          <td scope="col">'.$row['port'].'</td>
                          <td scope="col">'.$is_ssl.'</td>
                          <td scope="col"><a href="'.$root.'/integrations/?removeIMAP='.$row['id'].'" class="btn btn-danger btn-sm" onclick="return confirm(\'Confirm deletion of '.$row['server'].' '.$row['user'].'?\')"><i class="fas fa-trash-alt"></i></a></td>
                        </tr>
                        ';
                      }
                      ?>
                    </tbody>
                  </table>
                  <?php
                  }
                  ?>
                </div>
              </div>




              <!-- Modal -->
              <div class="modal fade" id="addIMAP" tabindex="-1" role="dialog" aria-labelledby="addIMAPLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document" style="margin-top: 10vw;">
                  <div class="modal-content">
                    <div class="modal-header">
                      <h5 class="modal-title" id="addIMAPLabel">IMAP Server Details<br/>
                        <small><p>This is optional unless you want to see the number of replies and bounces.</p></small></h5>
                      <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                      </button>
                    </div>
                    <div class="modal-body">
                      <form action="" method="post">
                        <div class="row">
                          <div class="col-md-6">
                            <label style="display: block; margin-top: 10px;">User: *</label>
                            <input type="text" name="IMAPuser" class="form-control">
                          </div>
                          <div class="col-md-6">
                            <label style="display: block; margin-top: 10px;">Password: *</label>
                            <input type="password" name="password" class="form-control">
                          </div>
                          <div class="col-md-6">
                            <label style="display: block; margin-top: 10px;">IMAP Server: *</label>
                            <input type="text" name="server" class="form-control">
                          </div>
                          <div class="col-md-6">
                            <label style="display: block; margin-top: 10px;">Port: *</label>
                            <input type="text" name="port" class="form-control">
                          </div>
                          <div class="col-md-6">
                            <label style="display: block; margin-top: 10px;">Is SSL: </label>
                            <select name="is_ssl" id="is_ssl" class="form-control">
                              <option value="0">No</option>
                              <option value="1">Yes</option>
                            </select> 
                          </div>
                          <div class="col-sm-12">
                            <br/>
                            <button type="submit" class="btn btn-primary">Save</button>
                          </div>
                        </div>
                      </form>
                    </div>
                    <div class="modal-footer">
                      <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    </div>
                  </div>
                </div>
              </div>

              <!-- Modal for pop3 -->
              <div class="modal fade" id="addPOP3" tabindex="-1" role="dialog" aria-labelledby="addPOP3Label" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document" style="margin-top: 10vw;">
                  <div class="modal-content">
                    <div class="modal-header">
                      <h5 class="modal-title" id="addIMAPLabel">POP3 Server Details<br/>
                        <small><p>This is optional unless you want to see the number of replies and bounces.</p></small></h5>
                      <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                      </button>
                    </div>
                    <div class="modal-body">
                      <form action="" method="post">
                        <div class="row">
                          <div class="col-md-6">
                            <label style="display: block; margin-top: 10px;">User: *</label>
                            <input type="text" name="POP3user" class="form-control">
                          </div>
                          <div class="col-md-6">
                            <label style="display: block; margin-top: 10px;">Password: *</label>
                            <input type="password" name="password" class="form-control">
                          </div>
                          <div class="col-md-6">
                            <label style="display: block; margin-top: 10px;">POP3 Server: *</label>
                            <input type="text" name="server" class="form-control">
                          </div>
                          <div class="col-md-6">
                            <label style="display: block; margin-top: 10px;">Port: *</label>
                            <input type="text" name="port" class="form-control">
                          </div>
                          <div class="col-md-6">
                            <label style="display: block; margin-top: 10px;">Is SSL: </label>
                            <select name="is_ssl" id="is_ssl" class="form-control">
                              <option value="0">No</option>
                              <option value="1">Yes</option>
                            </select> 
                          </div>
                          <div class="col-sm-12">
                            <br/>
                            <button type="submit" class="btn btn-primary">Save</button>
                          </div>
                        </div>
                      </form>
                    </div>
                    <div class="modal-footer">
                      <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    </div>
                  </div>
                </div>
              </div>


              <?php
              }
              ?>

            </div>

          </div>

        </div>
        <!-- /.container-fluid -->

      </div>
      <!-- End of Main Content -->

      <!-- Modal -->
      <div class="modal fade" id="edit" tabindex="-1" role="dialog" aria-labelledby="editLabel" aria-hidden="true">
        <div class="modal-dialog" role="document" style="margin-top: 10vw;">
          <form action="" method="post">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title" id="editLabel">Daily send limit</h5>
              <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div class="modal-body">
              <input type="hidden" name="update_limit" value="">
              <input type="number" class="form-control" name="limit" value="">
              <small class="d-block">0 for unlimited</small>
              <br/>
              <p><input type="checkbox" name="terms" required> I have read and agree to these <a href="javascript:void(0);" id="important_notes_toggle">important notes</a>.</p>
              <p id="important_notes" class="small" style="display: none;">
                When using <?php echo SITE_NAME; ?> you agree to ensure your sending account stays within Google's quota limits and across all email-sending apps.
                <br/><br/>
                By using <?php echo SITE_NAME; ?> you are responsible for sending authentic emails and following all pertinent spam laws. If our monitoring system flags your account's sending history we will block this email and disable your account.
              </p>
            </div>
            <div class="modal-footer">
              <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
              <button type="submit" class="btn btn-primary">Save changes</button>
            </div>
            </form>
          </div>
        </div>
      </div>

      <!-- Footer -->
      <footer class="sticky-footer bg-white">
        <div class="container my-auto">
          <div class="copyright text-center my-auto">
            <span>Copyright &copy; <?php echo date('Y'); ?></span>
          </div>
        </div>
      </footer>
      <!-- End of Footer -->

    </div>
    <!-- End of Content Wrapper -->

  </div>
  <!-- End of Page Wrapper -->

  <!-- Scroll to Top Button-->
  <a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
  </a>