$(function(){

  var adjustment;

  $("#drip-sortable").sortable({
    group: 'no-drop',
    items: 'li.drip-sortable',    
    handle: 'i.fa-envelope',
    onDragStart: function ($item, container, _super) {
      // Duplicate items of the no drop area
      if(!container.options.drop)
        $item.clone().insertAfter($item);
      _super($item, container);
    }
  });

  createDripElement();
  $(".btn-add-drip").click(function(){
    createDripElement();
  });

  function createDripElement()
  {
    var total_drip = $('ul#drip-sortable li.drip-header').length + 1;
    var member_id  = $("#member_id").val();
    var subject = $(".dripSubject1").val();
    var url_a = root_dir + "/create_campaign_drip_li.php";
    var url_b = root_dir + "/create_campaign_drip_element_li.php";
    var msg1 = '<div class="alert alert-info" role="alert"><img src="'+root_dir+'/img/spinner.gif" /> Creating template...</div>';
    var msg2 = '<div class="alert alert-info" role="alert"><img src="'+root_dir+'/img/spinner.gif" /> Creating drip element...</div>';
    //$(".campaign-drip-list").html(msg);
    
    $(".drip-01-loading").html(msg1);
    //$(".drip-02-loading").html(msg2);
    setTimeout(function () {
      $.ajax({
         type: "POST",
         url: url_a,      
         data: {"row_identifier":total_drip, "member_id":member_id},
         success: function(o)
         {
           var item = $(o).hide().fadeIn(1000);
           $(item).insertBefore(".drip-01-loading");
           $('[data-toggle="tooltip"]').tooltip();
         },
         complete: function() {
            $(".drip-01-loading").html("");
        }
      });

      $.ajax({
         type: "POST",
         url: url_b,      
         data: {"row_identifier":total_drip, "member_id":member_id, "subject":subject}, 
         success: function(o)
         {
            var item = $(o).hide().fadeIn(1000);
            $(".campaign-drip-properties").append(item);
         },
         complete: function() {
            //$(".drip-02-loading").html("");
         }
      });
    }, 1000);
  }

  $(".form-new-campaign").submit(function(e){
    e.preventDefault();
    var url = root_dir + "/ajax_preview_campaign.php";
    var msg = '<div class="alert alert-info" role="alert"><img src="'+root_dir+'/img/spinner.gif" /> Creating preview...</div>';
    $("#modal-preview-campaign").modal("show");
    $(".modal-preview-campaign-body").html(msg);

    setTimeout(function () {
      $.ajax({
         type: "POST",
         url: url,      
         data: $(".form-new-campaign").serialize(),
         success: function(o)
         {
           $(".modal-preview-campaign-body").html(o);
         }
      });
    }, 1000);

  });

  $(".form-preview-campaign").submit(function(e){
    e.preventDefault();
    var url = root_dir + "/ajax_save_campaign.php";
    var msg = '<div class="alert alert-info" role="alert"><img src="'+root_dir+'/img/spinner.gif" /> Saving campaign...</div>';
    var trigger_date = $("#preview-trigger-date").val();
    var trigger_time = $("#preview-trigger-time").val();

    $("#modal-preview-campaign").modal("show");
    $(".modal-preview-campaign-body").html(msg);

    setTimeout(function () {
      $.ajax({
         type: "POST",
         url: url,  
         dataType: "json",    
         data: $(".form-new-campaign").serialize() +"&trigger_date="+trigger_date+"&trigger_time="+trigger_time,
         success: function(o)
         {
           $(".modal-preview-campaign-body").html(o);
           if( o.is_success ){
            var msg = '<div class="alert alert-success" role="alert">Campaign was successfully created...</div>';
            $(".modal-preview-campaign-footer").hide();
            $(".modal-preview-campaign-body").html(msg);
            setTimeout(function () {
              location.href = root_dir + '/campaigns';

            }, 1000);
           }           
         }
      });
    }, 1000);
  });
});