<?php

define("IN_CRONTAB", 1);
require_once dirname(__FILE__) . '/config.php';
require_once dirname(__FILE__) . '/functions.php';
require_once dirname(__FILE__) . '/helper/cron_helper.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);
set_time_limit(900);


echo 'Running Cron Send';
flush();

$script_time_start = microtime(true);

$members = $pdo->prepare('SELECT m.id, m.fname, m.lname, m.timezone, m.parent_id, m.stripe FROM (`members` as m) WHERE m.status = 1 AND parent_id = 0');
$members->execute();

foreach ($members as $keyMember => $member) {
    //set timzone to the member's timezone

//    if( $member['parent_id'] > 0 ){
//        $smtp_member_id = $member['parent_id'];
//    }else{
//        $smtp_member_id = $member['id'];
//    }

    echo "<br /><br /> Member: " . $member['fname'] . " " . $member['lname'];
    //echo "<br /> Timezone: " . $member['timezone'] ;
    date_default_timezone_set($member['timezone']);
    $day = date("l");

    $stripe = json_decode($member['stripe'], 1);
    $sub_id = isset($stripe['subscription'])?$stripe['subscription']:$stripe['id'];
    if (isset($sub_id) && $sub_id !== '') {

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, 'https://api.stripe.com/v1/subscriptions/' . $sub_id);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
        curl_setopt($ch, CURLOPT_USERPWD, $new_stripe_sk . ':');
        $subscription = json_decode(curl_exec($ch), 1);
        curl_close($ch);

        $q = $pdo->prepare('UPDATE `members` SET `stripe_status`=? WHERE `id`=?');
        $q->execute(array($subscription['status'],  $member['id']));

        $flg = true;
        if($subscription['status'] != 'active'){
            $flg = false;
        }

        if($subscription['status'] != 'trialing'){
            $flg = false;
        }

        if($flg){

            $q = $pdo->prepare('UPDATE `campaigns` SET `status`=? WHERE `member_id`=?');
            $q->execute(array(CAMPAIGN_STATUS_PAUSED, $member['id']));

            //stop if they created sub account and its running any campaign
            $sub_members = $pdo->prepare('SELECT m.id, m.fname, m.lname, m.timezone, m.parent_id, m.stripe FROM (`members` as m) WHERE m.status = 1 AND parent_id = ?');
            $sub_members->execute($member['id']);

            foreach ($sub_members as $sub_member){
                $q = $pdo->prepare('UPDATE `campaigns` SET `status`=? WHERE `member_id`=?');
                $q->execute(array(CAMPAIGN_STATUS_PAUSED, $sub_member['id']));
            }

            //end
        }

        //$source = $customer['sources']['data'][0];

        //echo '<pre>';print_r($source);exit;
    }



} // end of the member




//exit();
$time_end = microtime(true);
$time = $time_end - $script_time_start;

echo ' <br/>End Cron Send - Time Taken: ' . $time . '<br>';
