<script type="text/javascript" src="<?php echo $root; ?>/js/ckeditor/ckeditor.js"></script>
<?php 
include 'config.php';
$member_id = $_POST['member_id'];

$q = $pdo->prepare('SELECT * FROM `smtp` WHERE `member_id`=?');
$q->execute(array($member_id));

$gmail_accounts = $pdo->prepare('SELECT * FROM `gmail_accounts` WHERE `member_id`=?');
$gmail_accounts->execute(array($member_id));
$emails = array();
foreach ($q as $row) {
  $emails[] = array(
    'name' => '<span style="display: inline-block;"></span>'.$row['from_name'],
    'from_name' => $row['from_name'],
    'from_email' => $row['from_email'],
    'email' => $row['user'],    
    'type' => 'SMTP',
    'send_limit' => $row['send_limit'],
    'id' => $row['id'],
    'server' => $row['server'],
    'port' => $row['port'],
    'digital_sign' => $row['digital_sign']
  );
}

foreach ($gmail_accounts as $row) {
  $emails[] = array(
    //'name' => '<span style="display: inline-block;"></span>'.$row['firstName'].' '.$row['lastName'],
    'name' => '<img src="'.$row['photoURL'].'" class="rounded-circle" style="height: 30px;"/> '.$row['firstName'].' '.$row['lastName'],
    'email' => $row['email'],
    'type' => 'Gmail',
    'send_limit' => $row['send_limit'],
    'id' => $row['id']
  );
}

$date_from = strtotime(date("Y-m-01"));
$date_to   = strtotime(date("Y-m-t"));

$sentEmails = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `member_id`=? AND (`last_activity` >= ? AND `last_activity` <= ?)');
$sentEmails->execute(array($member_id, $date_from, $date_to));

$lists = $pdo->prepare('SELECT * FROM `lists` WHERE `member_id`=?');
$lists->execute(array($member_id));

$list_ids = array();
foreach ($lists as $list) {
  $list_ids[$list['id']] = $list['id'];
}
$contacts = $pdo->prepare('SELECT * FROM `contacts` WHERE `list_id` IN ('. implode(",", $list_ids) .')');
$contacts->execute();
?>

<div class="row">
  <!-- Total sent emails for the month -->
  <div class="col-xl-6 col-md-6 mb-6">
    <div class="card border-left-danger shadow h-100 py-2">
      <div class="card-body">
        <div class="row no-gutters align-items-center">
          <div class="col mr-2">
            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Total Sent Emails for <b><?php echo date("F") ?></b></div>
            <div class="h1 mb-0 font-weight-bold text-gray-800"><?php echo $sentEmails->rowcount(); ?></div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Total contacts -->
  <div class="col-xl-6 col-md-6 mb-6">
    <div class="card border-left-danger shadow h-100 py-2">
      <div class="card-body">
        <div class="row no-gutters align-items-center">
          <div class="col mr-2">
            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Total Contacts</div>
            <div class="h1 mb-0 font-weight-bold text-gray-800"><?php echo $contacts->rowCount(); ?></div>
          </div>
        </div>
      </div>
    </div>
  </div>

</div>
<br />
<div class="row">
  <table class="table datatable table-striped table-hover table-bordered">
    <thead class="bg-dark text-white">
      <tr>
        <th colspan="4">GMAIL / SMTP ACCOUNTS</th>
      </tr>
      <tr>
        <th scope="col">NAME</th>
        <th scope="col">EMAIL</th>
        <th scope="col">TYPE</th>
        <th scope="col">DAILY SEND LIMIT</th>
      </tr>
    </thead>
    <tbody>
      <?php
      foreach ($emails as $email) {
        if($email['type'] == "Gmail") {
          echo '
            <tr>
              <td scope="col" align="left">'.$email['name'].'</td>
              <td scope="col" align="left">'.$email['email'].'</td>
              <td scope="col" align="left">'.$email['type'].'</td>
              <td scope="col" align="right">'.$email['send_limit'].'</td>
            </tr>
          ';
        }else{
          echo '
            <tr>
              <td scope="col" align="left"> <a href="javascript:void(0);" class="dropdown-item btn-edit-smtp-integration" data-toggle="tooltip" data-key="' .$email['id']. '" title="Edit"><i class="fas fa-pencil-alt"></i>   '.$email['name'].' </a></td>
              <td scope="col" align="left">'.$email['email'].'</td>
              <td scope="col" align="left">'.$email['type'].'</td>
              <td scope="col" align="left">'.$email['send_limit'].'' ; ?>

              <div class="modal fade" id="modal-smtp-edit-<?php echo $email['id']; ?>" data-focus="false" tabindex="-1" role="dialog" aria-labelledby="addLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                  <div class="modal-content">
                    <form action="" method="post" class="frm-edit-smtp-<?php echo $email['id']; ?>">
                    <div class="modal-body">
                      <div class="form">
                        <input type="hidden" name="edit_email_id" value="<?php echo $email['id']; ?>">
                        <input type="hidden" name="edit_member_id" value="<?php echo $email['member_id']; ?>">
                        
                        <input type="hidden" name="action" value="edit">
                        <h4 class="modal-heading"><i class="fas fa-envelope"></i> SMTP Settings (sending emails)</h4>
                        <div style="margin-bottom:30px;" class="modal-edit-smtp-msg"></div>
                        <div class="row">
                          <div class="col-md-6">
                            <div class="form-group">
                              <input type="text" name="edit_from_name" required="" value="<?php echo $email['from_name']; ?>" placeholder="Sender Name" class="form-control">
                              <label  data-toggle="tooltip" title="Name that will show on the sender name">From Name: *</label>
                            </div>
                          </div>
                          <div class="col-md-6">
                            <div class="form-group">
                              <input type="text" name="edit_from_email" required="" value="<?php echo $email['from_email'];  ?>" placeholder="sender@automailer.io" class="form-control">
                              <label data-toggle="tooltip" title="Email that will show on the sender" >From Email: *</label>
                            </div>
                          </div>
                          <div class="col-md-6">
                            <div class="form-group">
                              <input type="email" name="edit_user" required="" value="<?php echo $email['email'];  ?>" placeholder="youremail@domain.com" class="form-control">
                              <label data-toggle="tooltip" title="SMTP email that the system will use for sending email" >User (usually your email): *</label>
                            </div>
                          </div>
                          <div class="col-md-6">
                            <div class="form-group">
                              <input type="password" name="edit_password" required="" value="<?php echo $email['password'];  ?>" placeholder="Password" class="form-control">
                              <label data-toggle="tooltip" title="Your SMTP email password">Password: *</label>
                            </div>
                          </div>
                          <div class="col-md-6">
                            <div class="form-group">
                              <input type="text" name="edit_server" required="" value="<?php echo $email['server'];  ?>" placeholder="mail.automailer.io" class="form-control">
                              <label data-toggle="tooltip" title="SMTP server details can be found on you hosting email setting">SMTP Server: *</label>
                            </div>
                          </div>
                          <div class="col-md-6">
                            <div class="form-group">
                              <input type="text" name="edit_port" required="" value="<?php echo $email['port'];  ?>" placeholder="25" class="form-control">
                              <label data-toggle="tooltip" title="SMTP server port can be found on email settings on the cpanel">Port *:</label>
                            </div>
                          </div>

                          <?php   
                            $imap = $pdo->prepare('SELECT member_id,user,server,port FROM `imap` WHERE `member_id`=? AND `user`=? LIMIT 1' );
                            $imap->execute(array($email['member_id'],$email['email']));
                            foreach ($imap as $imap_info) {
                          ?>
                          <div class="col-md-6">
                            <div class="form-group">
                              <input type="text" name="edit_imap_server" id="edit_imap_server" value="<?php echo $imap_info['server']; ?>" required="" placeholder="mail.sampledomain.com" class="form-control">
                              <label  data-toggle="tooltip" title="IMAP server details can be found on you hosting email setting" >IMAP Server: *</label>
                            </div>
                          </div>
                          <div class="col-md-6">
                            <div class="form-group">
                              <input type="text" name="edit_imap_port" required="" placeholder="993" value="<?php echo $imap_info['port']; ?>" class="form-control">
                              <label data-toggle="tooltip" title="IMAP server port can be found on email settings on the cpanel">IMAP Port *:</label>
                            </div>
                          </div>
                          <?php } ?>
                        </div>
                        <div class="row">
                          <div class="col-md-12">
                            <div class="form-group">
                              <div class="custom-control custom-checkbox">
                                <input type="checkbox" class="custom-control-input" id="edit_usessltls_<?php echo $email['id']; ?>" name="edit_usessltls" value="1" <?php if($email['usessltls']==1){ ?> checked="checked" <?php } ?> >
                                <label class="custom-control-label" for="edit_usessltls_<?php echo $email['id']; ?>">Use SSL/TLS</label>
                              </div>
                            </div>
                          </div>
                        </div>
                        <div class="modal-footer">              
                          <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                          <button type="submit" class="btn btn-success btn-update-smtp" data-key="<?php echo $email['id']; ?>">Save Changes</button>
                        </div>
                      </div>
                    </div>
                    </form>
                  </div>
                </div>
              </div>

          <?php  echo  ' </td>
            </tr>                       
          ';
        }
      }
      ?>
    </tbody>
  </table>
</div>

<script type="text/javascript">
  $(document).ready(function(){
    CKEDITOR.replace( 'ckeditor', {
      width: '100'
    });
    CKEDITOR.config.allowedContent = true;

    $(".btn-edit-smtp-integration").click(function(){
      var data_id = $(this).attr('data-key');
      $(".modal-edit-smtp-msg").html("");
      $('#modal-smtp-edit-' + data_id).modal('show');
    });
  });
</script>
