<?php
$campaign_data = json_decode($campaign['data']);
$total_to_send = count($campaign_data);

$qSentMail = $pdo->prepare('SELECT COUNT(id) AS total_sent FROM `sent_mails` WHERE `campaign_id`=? AND `member_id`=?');
$qSentMail->execute(array($campaign['id'], $member['id']));
$progress_sent_mail = $qSentMail->fetch(PDO::FETCH_ASSOC);
?>
<?php foreach($campaign_data as $drip){ ?>
    <?php
    $total_sent    = 0;
    $total_opened  = 0;
    $total_bounced = 0;
    $total_replies = 0;
    $drip_total_pending = 0;

    $no_emojis = remove_emoji($drip->subject);

    if (preg_match('/{(.*?)}/s', $no_emojis, $regs)) {
        //With tags
        $contacts = $pdo->prepare('SELECT * FROM `contacts` WHERE `list_id`=? AND (status=? OR status=?)');
        $contacts->execute(array($campaign['list'],1,0));
        $contacts = $contacts->fetchAll();

        //Replace default tag in subject
        $tags = defaultTagsList();
        foreach ($contacts as $contact) {
            $subject = $no_emojis;
            foreach( $tags as $tag => $field ){
                if(strpos($subject, $tag) !== false){
                    $subject = str_replace($tag, $contact[$field], $subject);
                }
            }

            //get custom tag names
            $tagData = json_decode($contact['data'], 1);
            //replace all custom tags with contact values in subject
            if(is_array($tagData)){
                foreach ($tagData as $key => $value) {
                    $subject = str_replace('{'.$key.'}', $value, $subject);
                }
            }

            $sent = $pdo->prepare('SELECT id FROM `sent_mails` WHERE `subject` LIKE "%'.$subject.'%" AND `campaign_id`=? AND `to_email`=?  LIMIT 1');
            $sent->execute(array($campaign['id'], $contact['email'] ));

            $opened = $pdo->prepare('SELECT id FROM `sent_mails` WHERE `subject` LIKE "%'.$subject.'%" AND `campaign_id`=? AND `to_email`=? AND `opened`=1 LIMIT 1');
            $opened->execute(array($campaign['id'], $contact['email']));

//            $replies = $pdo->prepare('SELECT * FROM `sent_mails` WHERE `subject` LIKE "%'.$subject.'%" AND `campaign_id`=? AND `replied`=1 AND `id` NOT IN( SELECT `sent_mail_id` FROM auto_replies WHERE `member_id`=? ) LIMIT 1 ');
//            $replies->execute(array($campaign['id'], $member['id']));
            $replies = $pdo->prepare('SELECT id FROM `sent_mails` WHERE `subject` LIKE "%'.$subject.'%" AND `campaign_id`=? AND `to_email` =? AND `replied`=1  LIMIT 1 ');
            $replies->execute(array($campaign['id'], $contact['email']));

            $bounced = $pdo->prepare('SELECT id FROM `sent_mails` WHERE `subject` LIKE "%'.$subject.'%" AND `campaign_id`=? AND `to_email`=? AND `bounced`=1 LIMIT 1');
            $bounced->execute(array($campaign['id'], $contact['email']));
            $total_sent    += $sent->rowcount();
            $total_opened  += $opened->rowcount();
            $total_replies += $replies->rowcount();
            $total_bounced += $bounced->rowcount();
        }
    }else{
        //Without tags
        $sent = $pdo->prepare('SELECT id FROM `sent_mails` WHERE `subject` LIKE "%'.$no_emojis.'%" AND `campaign_id`=?');
        $sent->execute(array($campaign['id']));

        $opened = $pdo->prepare('SELECT id FROM `sent_mails` WHERE `subject` LIKE "%'.$no_emojis.'%" AND `campaign_id`=? AND `opened`=1');
        $opened->execute(array($campaign['id']));

        $replies = $pdo->prepare('SELECT id FROM `sent_mails` WHERE `subject` LIKE "%'.$no_emojis.'%" AND `campaign_id`=? AND `replied`=1 AND `id` NOT IN( SELECT `sent_mail_id` FROM auto_replies WHERE `member_id`=? )');
        $replies->execute(array($campaign['id'], $member['id']));

        $bounced = $pdo->prepare('SELECT id FROM `sent_mails` WHERE `subject` LIKE "%'.$no_emojis.'%" AND `campaign_id`=? AND `bounced`=1');
        $bounced->execute(array($campaign['id']));

        $total_sent    = $sent->rowcount();
        $total_opened  = $opened->rowcount();
        $total_replies = $replies->rowcount();
        $total_bounced = $bounced->rowcount();
    }

    /*$inEmail = str_repeat('?,', count($recipient_emails) - 1) . '?';
    $isSent  = $pdo->prepare("SELECT * FROM `sent_mails` WHERE `subject`=? AND `campaign_id`=? AND `to_email` IN ({$inEmail})");
    $isSent->execute(array($drip->subject, $campaign['id'])); */

    $drip_total_pending = $drip_total_recipients - $total_sent;

    ?>
    <!-- Page Heading -->


    <div class="float-left">
        <h1 class="panel-title">SUBJECT:</h1>
        <p class="panel-subtitle"><?php echo $drip->subject; ?></p>
    </div>
    <div class="clearfix"></div>

    <div class="row cards-row" style="margin:0 -1.5rem 0;">

        <div class="col-xl-3 col-md-6 mb-4">
            <?php if($total_sent > 0 ){?>
            <a href="javascript:void(0);" class="btn-report-details" data-key="sent" data-subject="<?php echo $drip->subject; ?>" data-id="<?php echo $campaign['id']; ?>">
                <?php } ?>
                <div class="card card-report">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="label">Total Sent</div>
                                <div class="h1 mb-0"><?php echo $total_sent; ?></div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php if($total_sent > 0 ){?>
            </a>
        <?php } ?>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <?php if($total_opened > 0 ){?>
            <a href="javascript:void(0);" class="btn-report-details" data-key="opened" data-subject="<?php echo $drip->subject; ?>" data-id="<?php echo $campaign['id']; ?>">
                <?php } ?>
                <div class="card card-report">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="label">Total Opened</div>
                                <div class="h1 mb-0"><?php echo $total_opened; ?></div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php if($total_opened > 0 ){?>
            </a>
        <?php } ?>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <?php if($total_replies > 0 ){?>
            <a href="javascript:void(0);" class="btn-report-details" data-key="replies" data-subject="<?php echo $drip->subject; ?>" data-id="<?php echo $campaign['id']; ?>">
                <?php } ?>
                <div class="card card-report">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="label">Total Replies</div>
                                <div class="h1 mb-0"><?php echo $total_replies; ?></div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php if($total_replies > 0 ){?>
            </a>
        <?php } ?>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <?php if($total_bounced > 0 ){?>
            <a href="javascript:void(0);" class="btn-report-details" data-key="bounces" data-subject="<?php echo $drip->subject; ?>" data-id="<?php echo $campaign['id']; ?>">
                <?php } ?>
                <div class="card card-report">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="label">Bounces</div>
                                <div class="h1 mb-0"><?php echo $total_bounced; ?></div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php if($total_bounced > 0 ){?>
            </a>
        <?php } ?>
        </div>

    </div>

    <div class="row widgets-row" style="margin:0 -1rem 3rem;">
        <div class="col-sm-12">
            <div class="progress" style="height:30px">
                <?php
                $style = '';
                $percent_progress = (($drip_total_recipients - $drip_total_pending) / $drip_total_recipients) *100;
                if( $percent_progress == 0 ){
                    $style = "color:#30D5CB;";
                }
                ?>
                <div class="progress-bar progress-bar-striped progress-bar-animated" role="progressbar" aria-valuenow="75" aria-valuemin="0" aria-valuemax="100" style="width: <?php echo $percent_progress; ?>%">
                    <span style="text-align:left; text-transform:uppercase; letter-spacing:1px;  font-size:0.9rem; padding:0 20px; <?php echo $style; ?>"><strong><?php echo $drip_total_recipients; ?> Recipients</strong> / <?php echo $drip_total_pending; ?> Pending</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>