<?php
    checkSuperAdmin();
    // ini_set('display_errors', 1);
    // ini_set('display_startup_errors', 1);
    // error_reporting(E_ALL);
  ?>

  <title><?php echo SITE_NAME; ?> - Help Management</title>
</head>

<body id="page-top">

  <!-- Page Wrapper -->
  <div id="wrapper">

    <?php include_once("nav_wrapper_admin.php"); ?>

    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column">

      <!-- Main Content -->
      <div id="content">

        <!-- Topbar -->
        <nav class="navbar navbar-expand navbar-light topbar mb-4 static-top shadow">

          <!-- Sidebar Toggle (Topbar) -->
          <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
            <i class="fa fa-bars"></i>
          </button>

          

          <!-- Topbar Navbar -->
          <ul class="navbar-nav ml-auto">

            

            <div class="topbar-divider d-none d-sm-block"></div>

            <!-- Nav Item - User Information -->
            <li class="nav-item dropdown no-arrow">
              <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <span class="mr-2 d-none d-lg-inline text-white small"><?php echo $member['firstname'].' '.$member['lastname']; ?></span>
              </a>
              <!-- Dropdown - User Information -->
              <div class="dropdown-menu dropdown-menu-right shadow animated--grow-in" aria-labelledby="userDropdown">
                <a class="dropdown-item" href="<?php echo $root; ?>/settings">
                  <i class="fas fa-cogs fa-sm fa-fw mr-2 text-gray-400"></i>
                  Settings
                </a>
                <div class="dropdown-divider"></div>
                <a class="dropdown-item" href="<?php echo $root; ?>/?logout=1">
                  <i class="fas fa-sign-out-alt fa-sm fa-fw mr-2 text-gray-400"></i>
                  Logout
                </a>
              </div>
            </li>

          </ul>

        </nav>
        <!-- End of Topbar -->

        <!-- Begin Page Content -->
        <div class="container-fluid">

          <!-- Page Heading -->
          <div class="float-left">
            <h1 class="h3 mb-4 text-gray-800">Help Management</h1>
          </div>
          <div class="float-right" style="margin-right: 10vw;">

          </div>
          <div class="clearfix"></div>
          <div class="row">
            <div class="col-sm-12">
              <div class="card shadow mb-4">
                <div class="card-header bg-dark py-3">
                  <div class="float-left">
                    <h6 class="m-0 font-weight-bold text-white">Help Management</h6>
                  </div>
                  <div class="clearfix"></div>
                </div>
                <?php 
                  if(isset($_POST['action'])){
                    if($_POST['action']=='help_save'){
                      $help_data = array(
                        $_POST['help_name'],
                        $_POST['help_content'],
                        time()
                      );
                      $q = $pdo->prepare('INSERT INTO `help` (name,content,created) VALUES (?,?,?)');
                      $q->execute($help_data);

                      echo '
                      <div class="alert alert-success" role="alert">
                        New help page was successfully added!
                      </div>
                      ';
                    }elseif($_POST['action']=='help_update'){
                      $help_data = array(
                        $_POST['help_name'],
                        $_POST['help_content'],
                        $_POST['help_id']                        
                      );
                      $q = $pdo->prepare('UPDATE `help` SET `name`=?,`content`=?  WHERE `id`=?');
                      $q->execute($help_data);

                      echo '<div class="alert alert-success">
                       Help page was successfully updated.
                      </div>';
                    }elseif($_POST['action']=='help_delete'){
                      $q = $pdo->prepare('DELETE FROM `help` WHERE `id`=?');
                      $q->execute(array($_POST['hid']));
                      echo '<div style="margin-bottom:2rem;">';
                      echo '<div class="alert alert-success" role="alert"> Help page was successfully deleted</div></div>';
                    }
                  }

                ?>
                <div class="card-body">
                  <button class="btn btn-primary" style="margin-top: 15px;" data-toggle="modal" data-target="#addHelp">Add New</button>
                  <?php
                  $q = $pdo->prepare('SELECT id,name,content,created FROM `help` ORDER by id DESC');
                  $q->execute();
                  ?>
                  <?php if($q->rowcount()>0){ ?>
                  <br/><br/>
                  <table class="table admin-help-datatable datatable">
                    <thead class="bg-default text-dark">
                      <tr>
                        <th scope="col" style="width: 70%;">PAGE NAME</th>
                        <th scope="col">DATE CREATED</th>
                        <th scope="col">ACTION</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php foreach ($q as $row) { ?>
                        <tr>
                          <td scope="col"><?php echo $row['name']; ?></td>
                          <td scope="col"><?php echo date("Y-m-d",$row['created']); ?></td>
                          <td scope="col">
                            <div class="dropdown">
                            <button class="btn btn-primary dropdown-toggle" type="button" data-toggle="dropdown">Action
                            <span class="caret"></span></button>
                            <ul class="dropdown-menu">
                              <li>
                                <a href="javascript:void(0)" class="btn btn-danger btn-sm btn-help-delete dropdown-item" data-key="<?php echo $row['id']; ?>" title="Delete"><i class="fas fa-trash-alt"></i> Delete</a>
                              </li>                              
                              <li>
                                <a href="javascript:void(0);" class="btn btn-info btn-sm dropdown-item" data-toggle="modal" data-target="#editHelp<?php echo $row['id']; ?>" title="Edit"><i class="fas fa-pencil-alt"></i> Edit</a>     
                            </ul>
                          </div>

                            <!-- Modal for Edituser -->
                            <div class="modal fade" id="editHelp<?php echo $row['id']; ?>" tabindex="-1" role="dialog" aria-labelledby="editHelpLabel" aria-hidden="true">
                              <div class="modal-dialog modal-lg" role="document" style="margin-top: 10vw;">
                                <div class="modal-content">
                                  <div class="modal-header">
                                    <h5 class="modal-title" id="addIMAPLabel">Edit Help Page</h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                      <span aria-hidden="true">&times;</span>
                                    </button>
                                  </div>
                                  <form action="" method="post">
                                  <div class="modal-body">                      
                                      <input type="hidden" name="help_id" value="<?php echo $row['id']; ?>" />
                                      <div class="row">
                                        <div class="col-md-12">
                                          <label style="display: block; margin-top: 10px;">Page Name: *</label>
                                          <input type="text" name="help_name" value="<?php echo $row['name']; ?>" class="form-control">
                                        </div>
                                      </div>
                                      <div class="row">
                                        <div class="col-md-12">
                                          <label style="display: block; margin-top: 10px;">Content: *</label>
                                          <textarea class="form-control ckeditor" rows="7" data-gramm="false" name="help_content"><?php echo $row['content']; ?></textarea>
                                        </div>  
                                      </div>                      
                                  </div>
                                  <div class="modal-footer">
                                    <button type="submit" class="btn btn-primary" name="action" value="help_update">Update</button>
                                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                                  </div>
                                  </form>
                                </div>
                              </div>
                            </div>
                          </td>
                        </tr>
                      <?php } ?>
                    </tbody>
                  </table>
                </div>
              </div>
              <?php } ?>

              <!-- Modal Add -->
              <div class="modal fade" id="addHelp" tabindex="-1" role="dialog" aria-labelledby="addHelpLabel" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                  <div class="modal-content">
                    <div class="modal-header">
                      <h5 class="modal-title" id="addHelpLabel">Add Help Page</h5>
                      <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                      </button>
                    </div>
                    <form action="" method="post">
                    <div class="modal-body">                                              
                        <div class="row">
                          <div class="col-md-12">
                            <label style="display: block; margin-top: 10px;">Page Name: *</label>
                            <input type="text" name="help_name" class="form-control">
                          </div>
                        </div>
                        <div class="row">
                          <div class="col-md-12">
                            <label style="display: block; margin-top: 10px;">Content: *</label>
                            <textarea class="form-control ckeditor" data-gramm="false" rows="7" name="help_content"></textarea>
                          </div>  
                        </div>                      
                    </div>
                    <div class="modal-footer">
                      <button type="submit" class="btn btn-primary" name="action" value="help_save">Save</button>
                      <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    </div>
                    </form>
                  </div>
                </div>
              </div>

              <!-- Modal Delete Confirmation -->
              <div class="modal fade modal-enhanced modal-danger" id="modalDeleteConfirmation" tabindex="-1" role="dialog" aria-labelledby="modalDeleteConfirmationlabel" aria-hidden="true">
                <div class="modal-dialog modal-md" role="document">
                  <form action="#" method="post">
                    <input type="hidden" value="" name="hid" class="hid">
                    <div class="modal-content">                      
                      <div class="modal-header">
                        <h5 class="modal-title"><i class="far fa-trash-alt"></i> Delete</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                          <span aria-hidden="true">&times;</span>
                        </button>
                      </div>
                      <div class="modal-body">
                        <div class="autoreply-selected-msg">Delete selected hel page?</div>
                        <div class="modal-footer">
                          <button type="button" class="btn btn-default" data-dismiss="modal">No</button>
                          <button type="submit" class="btn btn-danger" name="action" value="help_delete">Yes</button>
                        </div>
                      </div>
                    </div>
                  </form>
                </div>
              </div>

            </div>

          </div>

        </div>
        <!-- /.container-fluid -->

      </div>
      <!-- End of Main Content -->

   

      <!-- Footer -->
      <footer class="sticky-footer bg-white">
        <div class="container my-auto">
          <div class="copyright text-center my-auto">
            <span>Copyright &copy; <?php echo date('Y'); ?></span>
          </div>
        </div>
      </footer>
      <!-- End of Footer -->

    </div>
    <!-- End of Content Wrapper -->

  </div>
  <!-- End of Page Wrapper -->

  <!-- Scroll to Top Button-->
  <a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
  </a>

  <script>
    $(function(){
      $(".btn-help-delete").click(function(){
        var hid = $(this).attr("data-key");
        $(".hid").val(hid);
        $("#modalDeleteConfirmation").modal('show');
      });
    });
  </script>