<title><?php echo SITE_NAME; ?> - Leads</title>
</head>
<body id="page-top">

<!-- Page Wrapper -->
<div id="wrapper" class="campaign">

    <?php include_once("nav_wrapper.php"); ?>

    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column">

        <!-- Main Content -->
        <div id="content">

            <!-- Topbar Navbar -->
            <?php include_once("nav/right_nav.php"); ?>

            <!-- Begin Page Content -->
            <div class="container-fluid">

                <!-- Tab Nav -->
                <div class="panel-tab">
                    <ul class="tab-nav">
                        <li class="tab-active-nav"><a href="<?php echo $root."/leads"; ?>">Inbox</a></li>
                        <li><a href="<?php echo $root."/auto-replies"; ?>">Auto Reply</a></li>
                    </ul>
                </div>
                <a class="btn-default btn btn-back btn-sm" href="<?php echo $root."/leads"; ?>"><i class="fas fa-chevron-left"></i> Back</a>
                <?php
                if(isset($_POST['reply_message'])){
                    $data = array(
                        $_POST['lead_id'],
                        $_POST['campaign_id'],
                        $_POST['reply_message'],
                        strtotime(date("Y-m-d H:i:s")),
                        0,
                        0,
                        0
                    );
                    $qInsert = $pdo->prepare('INSERT INTO `lead_replies` (lead_id,campaign_id,msg,replied_date,is_with_reply,is_sent,mail_id) VALUES (?,?,?,?,?,?,?)');
                    $result = $qInsert->execute($data);

                    echo '
              <div class="alert alert-success" role="alert">
                Lead reply has been sent!
              </div>
              ';
                }

                $q = $pdo->prepare('SELECT `id`,`sent_mail_id`,`content`,`replied_date` FROM `leads` WHERE `id`=? LIMIT 1');
                $q->execute(array($_SEO[2]));
                $lead = $q->fetch(PDO::FETCH_ASSOC);

                $data = $pdo->prepare('SELECT `id`,`campaign_id`,`subject`,`opened_date`,`to_email`,`sent_date` FROM `sent_mails` WHERE `id`=?');
                $data->execute(array($lead['sent_mail_id']));
                $sent_mail = $data->fetch(PDO::FETCH_ASSOC);

                $data = $pdo->prepare('SELECT `id` , `data` ,`list` FROM `campaigns` WHERE `id`=?');
                $data->execute(array($sent_mail['campaign_id']));
                $campaign = $data->fetch(PDO::FETCH_ASSOC);
                ?>

                <div class="container-compose-message" style="margin-top:0;">
                    <div class="container">
                        <div class="row">


                            <div>
                                <!-- Page Heading -->
                                <div class="panel-header">
                                    <h1 class="panel-title">Leads - Send Reply</h1>
                                </div>
                                <div class="email-choice-content no-border">
                                    <form action="#" method="post">
                                        <input type="hidden" name="lead_id" value="<?php echo $lead['id']; ?>" />
                                        <input type="hidden" name="campaign_id" value="<?php echo $campaign['id']; ?>">
                                        <div class="form-group default">
                                            <input placeholder="Subject" type="text" name="email_subject" readonly="readonly" value="<?php echo $sent_mail['subject']; ?>" class="form-control">
                                        </div>
                                        <div class="form-group default">
                                            <textarea name="reply_message" class="form-control reply-msg ckeditor" data-gramm="false" rows="4"></textarea>
                                        </div>
                                        <div class="startup-actions text-right">
                                            <button type="submit" name="lead_send_reply" value="edit" class="btn btn-lg btn-success">Send</button>
                                        </div>
                                        <h4>LEAD MESSAGES</h4>
                                        <?php
                                        $lead_replies = $pdo->prepare('SELECT * FROM `lead_replies` WHERE `lead_id`=? ORDER BY `replied_date` DESC');
                                        $lead_replies->execute(array($lead['id']));

                                        $messages = "";
                                        foreach($lead_replies as $reply){

                                            $class   = '';
                                            $icon    = '';
                                            $caption = '';
                                            $class_caption = '';

                                            if($reply['mail_id'] !== 0 ){
                                                $class   = 'lead-reply reply-thread reply-sent';
                                                $icon    = 'fab fa-telegram-plane';
                                                $caption = 'Replied';
                                                $class_caption = 'reply';
                                            }

                                            if($reply['mail_id'] <> "0"){
                                                $class   = 'automailer-reply reply-thread reply-reply';
                                                $class_caption = 'sent';
                                                $icon    = 'fas fa-reply';
                                                $caption = 'Sent';
                                            }

                                            $reply_content = "";
                                            $days  = array("On Mon", "On Tue", "On Wed", "On Thu", "On Fri", "On Sat", "On Sun");
                                            $x = 0;
                                            foreach ($days as $day) {
                                                $reply_msg = strpos($reply['msg'], $day);
                                                if ($reply_msg) {
                                                    if($x==0){
                                                        $reply_content = strstr($reply['msg'], $day, true);
                                                        $x=1;
                                                    }
                                                }
                                            }

                                            if($reply_content == ""){
                                                $reply_content = $reply['msg'];
                                            }

                                            $messages .= "<div class='".$class."'><p class='heading'><i class='".$icon."'></i>" . date("F j Y H:i:s", $reply['replied_date']) . "</small></p>" . strip_tags($reply_content) . "</div>";
                                        }


                                        if(!is_null($sent_mail['opened_date'])){
                                            $messages .= "<div class='lead-reply reply-thread reply-sent'><p class='heading'><i class='fab fa-telegram-plane'></i> Opened date " . date("F j Y H:i:s", $sent_mail['opened_date']) . "</small></p> </div>";
                                        }


                                        $contacts = $pdo->prepare('SELECT * FROM `contacts` WHERE `list_id`=? AND email=? LIMIT 1');
                                        $contacts->execute(array($campaign['list'],$sent_mail['to_email']));
                                        $contact = $contacts->fetch(PDO::FETCH_ASSOC);


                                        $emails = json_decode($campaign['data'], 1);
                                        foreach ($emails as $email) {
                                            $email['body'] = linkify($email['body']);

                                            //replace all default tags with contact values in body of email
                                            $email['body'] = str_replace('{FirstName}', $contact['firstName'], $email['body']);
                                            $email['body'] = str_replace('{LastName}', $contact['lastName'], $email['body']);
                                            $email['body'] = str_replace('{Email}', $contact['email'], $email['body']);

                                            $email['body'] = str_replace('{firstName}', $contact['firstName'], $email['body']);
                                            $email['body'] = str_replace('{lastName}', $contact['lastName'], $email['body']);
                                            $email['body'] = str_replace('{email}', $contact['email'], $email['body']);

                                            //replace all default tags with contact values in subject of email
                                            $email['subject'] = str_replace('{FirstName}', $contact['firstName'], $email['subject']);
                                            $email['subject'] = str_replace('{LastName}', $contact['lastName'], $email['subject']);
                                            $email['subject'] = str_replace('{Email}', $contact['email'], $email['subject']);

                                            $email['subject'] = str_replace('{firstName}', $contact['firstName'], $email['subject']);
                                            $email['subject'] = str_replace('{lastName}', $contact['lastName'], $email['subject']);
                                            $email['subject'] = str_replace('{email}', $contact['email'], $email['subject']);

                                            if($sent_mail['subject'] == $email['subject']){
                                                $initial_subject = $email['subject'];
                                                $initial_body = $email['body'];
                                            }
                                        }


                                        if(!is_null($sent_mail['sent_date'])){
                                            $sent_date = "Initial sent date " . date("F j Y H:i:s", $sent_mail['sent_date']);
                                        }else{
                                            $sent_date = "Initial sent";
                                        }

                                        $messages .= "<div class='lead-reply reply-thread reply-sent'><p class='heading'><i class='fab fa-telegram-plane'></i> ".  $sent_date ." </small></p>
                          <div class='message-content'>" . $initial_subject ."</div>
                          <div class='message-content'>" . $initial_body . "</div> 

                        </div>";



                                        ?>
                                        <table class="table">
                                            <!-- <tr>
                                              <td>Lead ID : </td>
                                            </tr> -->
                                            <tr>
                                                <td colspan="2" style="color:#ffffff;padding: 0px;"><?php echo $messages; ?></td>
                                            </tr>
                                        </table>
                                    </form>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
            <!-- /.container-fluid -->
        </div>
        <!-- End of Main Content -->

        <!-- Footer -->
        <footer class="sticky-footer bg-white">
            <div class="container my-auto">
                <div class="copyright text-center my-auto">
                    <span>Copyright &copy; <?php echo date('Y'); ?></span>
                </div>
            </div>
        </footer>
        <!-- End of Footer -->

    </div>
    <!-- End of Content Wrapper -->

</div>
<!-- End of Page Wrapper -->

<!-- Scroll to Top Button-->
<a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
</a>