<title><?php echo SITE_NAME; ?> - Lists</title>
<style>
    .dataTables_length, .dataTables_wrapper .dataTables_filter{
        display: block !important;
    }
    .list-email-duplicate{
        list-style: none;
        margin: 0px;
        padding: 0px;
        margin-left: 31px;
        margin-top: 27px;
    }
    .list-email-duplicate li{
        font-size:18px;
        margin-bottom: 12px;
    }
    .duplicate-email-container{
        margin-bottom: 23px;
        border-bottom: 1px solid;
    }
    .modal-confirm-icon{
        font-size: 66px;
        color: #29D283;
        margin: 0px !important;
        display: block;
        text-align: center;
    }
    .modal-confirm-message{
        text-align: center;
        font-size: 18px;
    }
    .modal-list-details{
        display: inline-block;
        width: 49%;
    }
    .custom-modal-footer{
        /* -webkit-box-pack: end; */
        -ms-flex-pack: center;
        /* justify-content: flex-end; */
        padding: 1rem;
        text-align: center;
        display: inline;
    }

    .custom-modal-footer .btn{
        width: 126px;
    }
    .img-duplicate, .img-delete{
        margin: 0 auto;
        display: block;
        height: 127px;
    }
    .hdr-duplicate, .hdr-delete{
        width: 100%;
        text-align: center;
        font-size: 25px;
        margin: 29px 0px;
    }
</style>
</head>
<body id="page-top">
<?php

error_reporting(E_ALL);

require_once('Hashid/vendor/autoload.php');
?>
<!-- Page Wrapper -->
<div id="wrapper">

    <?php include_once("nav_wrapper.php"); ?>

    <!-- Content Wrapper -->
    <div id="content-wrapper" class="d-flex flex-column">

        <!-- Main Content -->
        <div id="content">

            <!-- Topbar Navbar -->
            <?php include_once("nav/right_nav.php"); ?>

            <!-- Begin Page Content -->
            <div class="container-fluid email-accounts dashboard">

                <div class="row">

                    <div class="col-sm-12">

                        <?php

                        if( isset($_POST['search']) ){
                            if( $_POST['search'] == 'search' ){
                                $_SESSION['list_filter']['date_from'] = $_POST['search_string_date_from'];
                                $_SESSION['list_filter']['date_to'] = $_POST['search_string_date_to'];
                            }else{
                                $_POST['search_string_date_from'] = '';
                                $_POST['search_string_date_to']   = '';
                                unset($_SESSION['list_filter']);
                            }
                        }
                        if(isset($_POST['action'])){
                            if($_POST['action'] == 'send-list-cleaner'){

                                require_once 'config.php';
                                require_once 'functions.php';
                                require_once 'ApiMailClickConvert.php';

                                $total_sent = 0;

                                foreach( $_POST['mailClickList'] as $key => $list_id ){
                                    $contacts = $pdo->prepare("SELECT email,firstName,lastName,status FROM `contacts` WHERE `list_id` =?"); //Unverified status
                                    $contacts->execute(array($list_id));

                                    if( $contacts->rowcount() > 0 ){
                                        $file = 'csv/automailer_list_' . $list_id . '.csv';
                                        $csv_handler = fopen($file,'w');

                                        $csv = "firstname,lastname,email \n";
                                        fwrite ($csv_handler,$csv);

                                        foreach( $contacts as $contact ){
                                            $csv = $contact['firstName'] . "," . $contact['lastName'] . "," . $contact['email'] . "\n";
                                            fwrite ($csv_handler,$csv);
                                        }


                                        fclose ($csv_handler);

                                        $url = 'https://devtest.automailer.io/' . $file;

                                        $mailClick = new ApiMailClickConvert();
                                        $mailClickResponse = $mailClick->uploadlistbyurl($url);
                                        if( $mailClickResponse->listid > 0 ){
                                            //Insert list id
                                            $data_mail_click_list = array(
                                                NULL,
                                                $member['id'],
                                                $mailClickResponse->importid,
                                                $mailClickResponse->listid,
                                                $list_id,
                                                $mailClickResponse->status,
                                                0,
                                                0,
                                                time()
                                            );
                                            $q = $pdo->prepare('INSERT INTO `mail_click_convert_list` VALUES (?,?,?,?,?,?,?,?,?)');
                                            $q->execute($data_mail_click_list);

                                            $total_sent++;
                                        }
                                    }

                                    $q = $pdo->prepare('UPDATE `lists` SET `verification`=? WHERE `id`=?');
                                    $q->execute(array(1,  $list_id));
                                }

                                $credit_to_use = $_POST['credit_to_use'];
                                $remaining_credits = $_POST['remaining_credits'];
                                $updated_cleaning_credit = $remaining_credits - $credit_to_use;
                                $q = $pdo->prepare('UPDATE `members` SET `cleaning_credits`=? WHERE `id`=?');
                                $q->execute(array($updated_cleaning_credit,  $member['id']));
                                $member['cleaning_credits'] = $updated_cleaning_credit;

                                echo '
                  <div class="alert alert-success" role="alert">
                    Total updated sent list : '.$total_sent.'
                  </div>
                  ';
                            }elseif($_POST['action'] == 'delete'){
                                if( checkPermissionByTable('lists1', $member['id'], $_POST['lid']) ){
                                    $q = $pdo->prepare('DELETE FROM `lists` WHERE `id`=? AND `member_id`=? LIMIT 1');
                                    $q->execute(array($_POST['lid'], $_SESSION['id']));

                                    $q = $pdo->prepare('DELETE FROM `contacts` WHERE `list_id`=?');
                                    $q->execute(array($_POST['lid']));

                                    echo '
                        <div class="alert alert-success" role="alert">
                          List has been deleted!
                        </div>
                        ';
                                }else{
                                    echo '
                        <div class="alert alert-danger" role="alert">
                          No permission!
                        </div>
                        ';
                                }
                            }elseif( $_POST['action'] == 'duplicate-list' ){
                                require_once('Hashid/vendor/autoload.php');

                                $q = $pdo->prepare('SELECT * FROM `lists` WHERE `member_id`=? AND `id`=?');
                                $q->execute(array($member['id'], $_POST['list_id']));
                                $list = $q->fetch(PDO::FETCH_ASSOC);

                                if( $list ){
                                    $q = $pdo->prepare('INSERT INTO `lists` (`name`,fields,member_id,total_contacts,temp_filename) VALUES (?,?,?,?,?)');
                                    $q->execute(array($_POST['duplicate_list_name'], $list['fields'], $member['id'], $list['total_contacts'], $list['temp_filename']));
                                    $listID = $pdo->lastInsertId();

                                    $contacts = $pdo->prepare("SELECT * FROM `contacts` WHERE `list_id` =?"); //Unverified status
                                    $contacts->execute(array($_POST['list_id']));

                                    $contacts_data = array();
                                    $contacts_fields = array();
                                    foreach( $contacts as $c ){
                                        $contacts_fields[] = '(?,?,?,?,?,?,?)';
                                        array_push($contacts_data,$listID,$c['firstName'],$c['lastName'],$c['email'],$c['data'],$c['status'],$c['mailclick_status']);
                                    }

                                    if( !empty($contacts_fields) ){
                                        $q = $pdo->prepare('INSERT IGNORE INTO `contacts` (list_id,firstName,lastName,email,data,status,mailclick_status)  VALUES ' . implode(",", $contacts_fields));
                                        $q->execute($contacts_data);
                                    }

                                    $hashids = new Hashids\Hashids();
                                    $eid = $hashids->encode($listID);

                                    header('Location: '.$root.'/list/'.$eid);
                                    exit();

                                }else{
                                    echo '
                        <div class="alert alert-danger" role="alert">
                          Cannot duplicate list
                        </div>
                        ';
                                }
                            }
                        }

                        if(isset($_POST['edit_list']))
                        {

                            if (checkPermissionByTable("listsB",$member['id'],$_POST['edit_list']) == false)
                                die("No permission");


                            $q = $pdo->prepare('UPDATE `lists` SET `name`=? WHERE `id`=?');
                            $q->execute(array($_POST['list_name'], $_POST['edit_list']));

                        }

                        if(isset($_GET['remove']))
                        {

                            if (checkPermissionByTable("lists",$member['id'],$_GET['remove']) == false)
                                die("No permission");

                            $q = $pdo->prepare('DELETE FROM `lists` WHERE `id`=? AND `member_id`=? LIMIT 1');
                            $q->execute(array($_GET['remove'], $_SESSION['id']));

                            $q = $pdo->prepare('DELETE FROM `contacts` WHERE `list_id`=?');
                            $q->execute(array($_GET['remove']));

                            header('Location: '.$root.'/lists');
                            exit();

                        }

                        if( isset($_POST['csvHeaderMap']) ){

                            $list_name = htmlspecialchars($_POST['list_name'],ENT_QUOTES);
                            $member_id = (int) $member['id'];
                            $q = $pdo->prepare("SELECT * FROM lists WHERE `member_id` =". $member_id . " AND `name` = '". $list_name ."' ORDER BY name ASC");
                            $q->execute();
                        
                            $last_list_name = $list_name;
                        
                            $row_count = $q->rowcount();
                            for($x = 0; $x <= $row_count; $x++){
                                if($x == 0){
                                    $last_list_name = $list_name;
                                }else{
                                    $last_list_name = $list_name .' ('.$x.')';
                                }
                            }
                        
                            $firstNameKey = '';
                            $lastNameKey = '';
                            $keys = array('emailKey' => '','firstNameKey' => '', 'lastNameKey' => '');
                            foreach ($_POST['csvHeaderMap'] as $key => $value) {
                               
                                if(strpos(strtolower($value), 'first name') !== false || strpos(strtolower($value), 'firstname') !== false){
                                    $firstNameKey = $key;
                                }
                                if(strpos(strtolower($value), 'last name') !== false || strpos(strtolower($value), 'lastname') !== false){
                                    $lastNameKey = $key;
                                }
                                if(strpos(strtolower($value), 'email') !== false || strpos(strtolower($value), 'e-mail') !== false || strpos(strtolower($value), 'emailaddress') !== false){
                                    $emailKey = $key;
                                }


                                $q = $pdo->prepare('INSERT INTO `csv_headers` (`file_id`,header, header_key) VALUES (?,?,?)');
                                $q->execute(array( $_SESSION['fileId'], $value, $key));
                                if(isset($emailKey)){
                                    $keys = array(
                                        'firstNameKey' => $firstNameKey,
                                        'lastNameKey' => $lastNameKey,
                                        'emailKey' => $emailKey
                                    );
                                }
                            }
                            // die;
                            if ($keys['emailKey'] === '')
                                die("No email column assigned");
                        
                            //echo "INSERT INTO `lists` (`name`,fields,member_id) VALUES ('$last_list_name',''," . $member['id'] . ")";
                            ignore_user_abort(true);
                        
                            $q = $pdo->prepare('INSERT INTO `lists` (`name`,fields,member_id,date_created) VALUES (?,?,?,?)');
                            $q->execute(array($last_list_name, '', $member['id'], date("Y-m-d H:i:s")));
                            $listID = $pdo->lastInsertId();
                            $q = $pdo->prepare('UPDATE `csv_files` SET `list_id`=? WHERE `id`=?');
                            $q->execute(array($listID,  $_SESSION['fileId']));
                            // $listID = $pdo->lastInsertId();
                            //echo $q->errorInfo();
                            $count = 0;
                            $customFields = array();
                            $domainStatus = array();
                            $contactsData = array();
                            $contactsQuestionMarks = array();
                            // print_r($_SESSION['csv_data']);die;
                            // foreach ($_SESSION['csv_data'] as $key => $value) {
                            //     // sleep(3);
                            //    // if(!in_array($value[$_POST['emailkey']], $_POST['email_remove_dupplicate'])){
                            //         $data = array();
                            //         if(count($customFields)<1){
                            //             $customFields = $value;
                            //         }
                            //         if(strtolower($value[$keys['emailKey']]) !== 'email'){
                            //             if (filter_var($value[$keys['emailKey']], FILTER_VALIDATE_EMAIL)) {
                            //                 foreach ($value as $valueKey => $field) {
                            //                     if(!in_array($valueKey, $keys))
                            //                     {
                            //                         $data[$customFields[$valueKey]] = $field;
                            //                     }
                            //                 }

                            //                 $email = $value[$keys['emailKey']];
                            //                 $email = trim($email);



                            //                 $status = 2;
                            //                 if (IsValidEmail($email) == false)
                            //                     $status = 2;
                            //                 else
                            //                 {

                            //                     $status = 2;
                            //                     list($username, $domain) = explode('@', $email);


                            //                     if (in_array($domain,array('gmail.com','yahoo.com','aol.com','outlook.com','live.com','rr.com','comcast.net','hotmail.com','cox.net','bellsouth.net')))
                            //                     {
                            //                         $status = 1;
                            //                         $domainStatus[$domain] =  $status;

                            //                     }

                            //                     // Check if dns entry is cached
                            //                     if (empty($domainStatus[$domain]))
                            //                     {
                            //                         if (checkdnsrr($domain, 'MX'))
                            //                         {

                            //                             $status = 1;
                            //                             $domainStatus[$domain] = $status;

                            //                         } else

                            //                         {
                            //                             $status = 2;
                            //                             $domainStatus[$domain] = $status;
                            //                         }
                            //                     } else
                            //                         $status = $domainStatus[$domain];

                            //                 }


                            //                 if($value[$keys['emailKey']] <> ""){

                            //                     if (empty($value[$keys['firstNameKey']])){
                            //                         $value[$keys['firstNameKey']] = "";
                            //                     }

                            //                     if (empty($value[$keys['lastNameKey']])){
                            //                         $value[$keys['lastNameKey']] = "";
                            //                     }

                            //                     $contactsQuestionMarks[] = '(?,?,?,?,?,?,?)';

                            //                     array_push($contactsData,$listID,$value[$keys['firstNameKey']],$value[$keys['lastNameKey']],$value[$keys['emailKey']],json_encode($data),$status,'Unverified');

                            //                     /*$q = $pdo->prepare('INSERT INTO `contacts` (list_id,firstName,lastName,email,data,status,mailclick_status)  VALUES (?,?,?,?,?,?,?)');
                            //                     $q->execute(array(
                            //                       $listID,
                            //                       $value[$keys['firstNameKey']],
                            //                       $value[$keys['lastNameKey']],
                            //                       $value[$keys['emailKey']],
                            //                       json_encode($data),
                            //                       $status,
                            //                       'Unverified'
                            //                     ));*/
                            //                     // $errMsg = $q->errorInfo();
                            //                     //  echo print_r($errMsg);
                            //                 }
                            //             }
                            //         }

                            //         $count++;

                            //         // Execute query every 100 records
                            //         if ($count > 100)
                            //         {
                            //             if( !empty($contactsData) )
                            //             {


                            //                 $q = $pdo->prepare('INSERT IGNORE INTO `contacts` (list_id,firstName,lastName,email,data,status,mailclick_status)  VALUES ' . implode(",", $contactsQuestionMarks));
                            //                 $q->execute($contactsData);
                            //                 $contact_id = $pdo->lastInsertId();

                            //                 $contactsData = array();
                            //                 $contactsQuestionMarks = array();
                            //                 $count = 0;
                            //             }
                            //         }
                            //    // } // email_remove_dupplicate
                            // }



                            // if( !empty($contactsData) ){
                            //     $q = $pdo->prepare('INSERT IGNORE INTO `contacts` (list_id,firstName,lastName,email,data,status,mailclick_status)  VALUES ' . implode(",", $contactsQuestionMarks));
                            //     $q->execute($contactsData);
                            //     $contact_id = $pdo->lastInsertId();
                            //     $q = $pdo->prepare('INSERT INTO `contacts_by_lists` (list_id,contact_id) VALUES (?,?)');
                            //     $q->execute(array($listID, $contact_id));
                            // }
                            foreach ($keys as $key => $value) {
                                unset($customFields[$value]);
                            }
                        
                            $q = $pdo->prepare('UPDATE `lists` SET `fields`=? WHERE `id`=?');
                            $q->execute(array(
                                json_encode($customFields),
                                $listID
                            ));
                        
                            unset($_SESSION['csv_data']);
                            unset($_SESSION['list_name']);
                            // recaculate the list totals
                            UpdateListTotals($listID);
                            header('Location: '.$root.'/list/'.$listID);
                            exit();
                        }


                        ?>

                        <?php
                        if(!empty($_SEO[2]))
                        {
                        if( !empty($_SESSION['csv_headers']) ){
                        $csv_headers = $_SESSION['csv_headers'];
                        unset($_SESSION['csv_headers']);
                        ?>
                        <form action="" id="map_csv_form" method="post" enctype="multipart/form-data">
                            <div class="container">

                                <div class="row">
                                    <div class="col-md-12">
                                        <h1 class="panel-title">Map CSV Header</h1>
                                        <p class="panel-subtitle">Map CSV Header - Can only set 1 Email, First Name and Last Name as header.</p>
                                        <?php $total_columns = count($csv_headers); ?>
                                        <input type="hidden" name="list_name" value="<?php echo $_SESSION['list_name']; ?>">
                                        <div style="overflow:auto;">

                                            <ul class="field-map">
                                                <?php foreach($csv_headers as $key => $value){ ?>
                                                    <li>
                                                        <?php
                                                        $is_active = '';
                                                        $assigned  = '';

                                                        $a = "firs";
                                                        if (strpos(strtolower($value), $a) !== false) {
                                                            $first = "selected" ;
                                                            $assigned  = "assigned";
                                                            $is_active = 'active';
                                                        }else{
                                                            $first = "";
                                                        }
                                                        $b = "las";
                                                        if (strpos(strtolower($value), $b) !== false) {
                                                            $last = "selected" ;
                                                            $assigned  = "assigned";
                                                            $is_active = 'active';
                                                        }else{
                                                            $last = "";
                                                        }
                                                        $c = "emai";
                                                        if (strpos(strtolower($value), $c) !== false) {
                                                            $email = "selected" ;
                                                            $assigned  = "assigned";
                                                            $is_active = 'active';
                                                        }else{
                                                            $email = "";
                                                        }

                                                        $class_identifier = str_replace(" ", "", $value);
                                                        $class_identifier = strtolower($class_identifier);
                                                        $label_class_identifier = "label-" . $class_identifier;
                                                        $div_class_identifier   = "container-" . $class_identifier;
                                                        $cmb_class_identifier   = $class_identifier;

                                                        ?>
                                                        <div class="form-group <?php echo $assigned; ?> <?php echo $div_class_identifier; ?>">
                                                            <div class="label <?php echo $is_active; ?> <?php echo $label_class_identifier; ?>"><i class="fas fa-check-circle"></i> <?php echo $value; ?></div>
                                                            <select class="form form-control csv-field" data-key="<?php echo $cmb_class_identifier; ?>" name="csvHeaderMap[]" required="">
                                                                <!-- <option value="">- Select Field -</option> -->
                                                                <option value="Unassign">Unassign</option>
                                                                <option <?php echo $email; ?> value="Email">Email</option>
                                                                <option <?php echo $first; ?> value="First Name">First Name</option>
                                                                <option <?php echo $last; ?> value="Last Name">Last Name</option>
                                                            </select>
                                                        </div>
                                                    </li>
                                                <?php } ?>
                                            </ul>
                                        </div>

                                        <div class="row duplicate-email-container">
                                            <div class="col-md-12">
                                                <h1 class="panel-title" style="font-size: 25px;">Below are the emails that already exists in other list. Check to remove from import.</h1>
                                                <!-- <ul class="list-email-duplicate"> -->
                                                <?php
                                                $is_with_duplicate = false;
                                                foreach ($_SESSION['csv_data'][0] as $key => $value) {
                                                    $c = "emai";
                                                    if (strpos(strtolower($value), $c) !== false) {
                                                        $emailkey = $key;
                                                    }
                                                } ?>


                                                <div class="dataTables_wrapper">
                                                    <table class="table list-duplicate-contact-datatable datatable">
                                                        <thead>
                                                        <tr>
                                                            <th scope="col">
                                                                <input type="checkbox" class="dupe-select-all" />
                                                            </th>
                                                            <th scope="col">Email</th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>

                                                        <?php   $csv_x = 0;
                                                        foreach ($_SESSION['csv_data'] as $key => $value) {
                                                            if($csv_x == 0){
                                                                $csv_x = 1;
                                                            }else{
                                                                $q = $pdo->prepare('SELECT id, FROM `contacts` WHERE `member_id`=? AND `id`=?');

                                                                $q  = $pdo->prepare('SELECT l.id, l.member_id, c.email FROM (`contacts` as c)
                                     LEFT JOIN lists as l ON (l.id = c.list_id) WHERE l.member_id =? AND c.email =? ');
                                                                $q->execute(array($member['id'], $value[$emailkey])); ?>


                                                                <?php if($q->rowcount()){ $is_with_duplicate = true;?>
                                                                    <tr>
                                                                        <td style="width:5%;" ><input type="checkbox" name="email_remove_dupplicate[]" class="dupe-email-chk" value="<?php echo $value[$emailkey]; ?>" /></td>
                                                                        <td class="email">
                                                                            <?php echo $value[$emailkey]; ?>
                                                                        </td>
                                                                    </tr>
                                                                <?php }
                                                            }
                                                        }
                                                        ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                                <!-- </ul> -->
                                                <input type="hidden" name="emailkey" value="<?php echo $emailkey; ?>">
                                                <br />
                                                <?php if( !$is_with_duplicate ){ ?>
                                                    <script>
                                                        $(function(){
                                                            $(".duplicate-email-container").hide();
                                                        });
                                                    </script>
                                                <?php } ?>
                                            </div>
                                            <hr />
                                        </div>

                                        <div class="form-actions text-center">
                                            <button type="submit" class="btn btn-success"><span id="map_csv_submit">Next</span>
                                            </button>
                                        </div>
                        </form>
                    </div>
                </div>
            </div>
        <?php
        }else{
            switch ($_SEO[2]) {
                case 'create':
                    ?>
                    <a class="btn-default btn btn-back btn-sm" href="<?php echo $root.'/lists'; ?>"><i class="fas fa-chevron-left"></i> Back</a>
                    <?php if(isset($upload_error) ? $upload_error == 1 : '' ){ ?>
                    <div class="alert alert-warning"> Invalid file format. Click <a href="<?php echo $root_assets; ?>/sample.csv" target="_blank">here</a> to download the correct template.  </div>
                <?php } ?>
                    <div class=" text-center">
                        <h3 class="panel-title">Create a new list</h3>
                        <div style="display: block;margin: 0 auto;max-width: 500px;" class="upload-list-msg"></div>
                        <form action="<?= $root ?>/csv_file_upload" method="post" id="upload_file_form" enctype="multipart/form-data">
                            <div class="form-group" style="margin:0 auto; max-width:500px;">
                                <input type="text" name="name" id="list-name" class="form-control" required>
                                <label>List name</label>
                            </div>

                            <div class="drop-upload">
                                <a class="float-right btn-sm btn-default btn-download-template" href="<?php echo $root_assets; ?>/sample.csv">Download Template</a>
                                <div id="dropContainer">

                                    <i class="fas fa-cloud-upload-alt"></i>
                                    <big>Drop a file here or click to upload</big>
                                    <label>Upload *.csv file. Maximum filesize: <?php echo format_size(UPLOAD_MAX_FILE_SIZE); ?>.</label>
                                    <a class="btn btn-sm btn-secondary btn-select-upload" href="javascript:void();">Select files to upload</a>
                                </div>
                            </div>
                            <input type="file" id="fileInput" name="file" style="display: none;">
                            <div class="upload-notes">
                                All lists must have a "first name", "last name", and "email" field. <br/>Any other field will also be added and can be dynamically inserted to emails using tags, example: {company}, {phone_number}.
                            </div>

                            <div class="startup-actions text-center" style="margin-top:-30px;">
                                <button type="submit" onclick="upload_file()" class="btn btn-md btn-success btn-upload-list" name="action" value="csv_list">Create List</button>
                                <!-- <a href="<?php echo $root; ?>/lists" class="btn btn-lg btn-outline-secondary" style="font-size:1rem;"> Back</a>  -->
                            </div>
                            <div class="">
                                <div class="progress mt-3"  style="width:50%; margin:auto;display:none" id="progress_div" >
                                    <div class="progress-bar" id="bar1" style="width: 0%;" role="progressbar"   aria-valuemin="0" aria-valuemax="100"></div>
                                    <div class='percent' id='percent1'>0%</div>
                                </div>
                            </div>
                        </form>

                        <!-- Modal Upload info -->
                        <!-- <div class="modal fade modal-enhanced" id="modalInformation" tabindex="-1" role="dialog" aria-labelledby="modalInformationlabel" aria-hidden="true">
                            <div class="modal-dialog modal-md" role="document">
                                <form action="" method="post">
                                    <input type="hidden" value="" name="lid" class="lid">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title">List</h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <div class="modal-body">
                                            <div class="list-selected-msg">List Upload In Progress..<br /><small>(This may take few minutes)</small></div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div> -->

                    </div>



                    <div class="card shadow mb-4">
                        <div class="card-body">

                        </div>
                    </div>
                    <?php
                    break;
            }
        }
        }
        else
        {
            ?>

            <?php if( in_array("add", $list_roles) || $member['account_type'] == 0 ){ ?>
            <!-- Page Heading -->
            <div class="panel-header">
                <div class="float-left">
                    <h1 class="panel-title">Lists</h1>
                    <p class="panel-subtitle">Create a list and add contacts using a CSV file <a href="<?php echo $root; ?>/sample.csv" target="_blank">see sample</a>.</p>
                    <a class="btn btn-success" style="margin-bottom:30px;" href="<?php echo $root; ?>/lists/create">Create list</a>
                </div>
                <div class="float-right">
                    <form action="" method="post" class="search-form">
                        <i class="fas fa-search"></i>
                        <input type="text" placeholder="Date From" name="search_string_date_from" class="default-datepicker" style="display:inline-block;width: 30%;" id="search_string_date_from" value="<?php echo  isset($_POST['search_string_date_from']) ? htmlspecialchars($_POST['search_string_date_from']) : ''; ?>">
                        <input type="text" placeholder="Date To" name="search_string_date_to" class="default-datepicker" style="display:inline-block;width: 30%;" id="search_string_date_to" value="<?php echo  isset($_POST['search_string_date_to']) ? htmlspecialchars($_POST['search_string_date_to']) : ''; ?>">
                        <button type="submit" class="btn btn-success btn-sm" name="search" value="search" style="display: inline-block;">Search</button>
                        <button type="submit" class="btn btn-info btn-sm" name="search" value="clear" style="display: inline-block;">Reset</button>
                    </form>
                </div>
                <div class="clearfix"></div>
                <!-- <div class="float-left" style="margin-top: 30px;">
                      <form action="" method="post" class="search-form">
                        <i class="fas fa-search"></i>
                        <input type="text" placeholder="Search" name="search_string" id="search_string" value="<?php echo  isset($_POST['search_string']) ? htmlspecialchars($_POST['search_string']) : ''; ?>">
                      </form>
                    </div> -->
                <div class="clearfix"></div>
            </div>
        <?php } ?>
            <form action="#" method="post">
                <div class="dataTables_wrapper">

                    <table class="table datatable" id="lists-datatable">
                        <thead>
                        <tr>
                            <th scope="col">Name</th>
                            <th scope="col">Contacts</th>
                            <th scope="col">Good</th>
                            <th scope="col">Bad</th>
                            <th scope="col">Status</th>
                            <th scope="col">Date Created</th>
                            <th scope="col">Actions</th>
                        </tr>
                        </thead>
                        <tbody></tbody>
                    </table>

                    <div class="modal fade modal-enhanced" id="modal-mailclick-confirmation" tabindex="-1" role="dialog" aria-labelledby="addLabel" aria-hidden="true">
                        <div class="modal-dialog" role="document">
                            <div class="modal-content">
                                <div class="modal-header" style="display:none;">
                                    <h5 class="modal-title"></h5>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">×</span>
                                    </button>
                                </div>
                                <input type="hidden" name="credit_to_use" id="credit_to_use" class="credit_to_use" value="0" />
                                <input type="hidden" name="remaining_credits" id="remaining_credits" class="remaining_credits" value="<?php echo $member['cleaning_credits'];?>" />
                                <div class="modal-body" style="padding:1.5rem;margin-bottom: 50px;">
                                    <i class="fa fa-check-circle modal-confirm-icon"></i><br />
                                    <h2 style="font-size: 38px;text-align: center;">Confirmation</h2>
                                    <p class="message modal-confirm-message">Would you like to continue cleaning your list?</p>
                                    <div class="footer-confirm" style="text-align:center;">
                                        <p class="list-details modal-list-details">
                                            <big><span class="credit-to-use">3,000</span> <small style="display:inline-block;">Credits to be used</small></big>
                                        </p>
                                        <p class="list-details modal-list-details">
                                            <big><?php echo $member['cleaning_credits'];?> <small style="display:inline-block;">Remaining credits</small></big>
                                        </p>
                                    </div>
                                    <div class="footer-error-confirm">
                                        <p class="list-details modal-list-details">
                                            <big><span class="credit-to-use">3,000</span> <small style="display:inline-block;">Credits to be used</small></big>
                                        </p>
                                        <p class="list-details modal-list-details">
                                            <big><?php echo $member['cleaning_credits'];?> <small style="display:inline-block;">Remaining credits</small></big>
                                        </p>
                                    </div>
                                </div>
                                <div class="modal-footer custom-modal-footer" style="margin-top:-2.5rem;">
                                    <button type="button" style="background-color:#C1C1C1;color:#ffffff;" class="btn btn-default" data-dismiss="modal">No</button>
                                    <button type="submit" class="btn btn-success" name="action" value="send-list-cleaner">Yes</button>
                                </div>

                               
                            </div>
                        </div>
                    </div>


                </div>
            </form>

            <div class="modal fade modal-enhanced" id="modal-list-duplicate" tabindex="-1" role="dialog" aria-labelledby="addLabel" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <form action="" method="post" id="frm-duplicate-list">
                            <input type="hidden" name="list_id" class="list-id" value="0" />
                            <div class="modal-body">
                                <div class="footer-confirm">
                                    <div class="col-md-12">
                                        <img src="<?php echo $root; ?>/img/duplicate.png" class="img-duplicate">
                                        <h3 class="hdr-duplicate">Duplicate List Contact</h3>
                                        <div class="">
                                            <label for="exampleInputEmail1">List Name</label>
                                            <input type="text" name="duplicate_list_name" required="" value="" placeholder="" class="duplicate-list-name form-control">
                                        </div>
                                    </div>
                                </div>
                                <div class="modal-footer" style="display: block;text-align: center;">
                                    <button type="button" class="btn btn-default" data-dismiss="modal" style="width:200px;background-color:#c1c1c1;color:#ffffff;font-size: 21px;">Cancel</button>
                                    <button type="submit" class="btn btn-success" name="action" value="duplicate-list" style="width:200px;font-size: 21px;">Duplicate</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <?php
        }
        ?>

        </div>

    </div>

    <!-- Modal Delete Confirmation -->
    <div class="modal fade modal-enhanced modal-danger" id="modalDeleteConfirmation" tabindex="-1" role="dialog" aria-labelledby="modalDeleteConfirmationlabel" aria-hidden="true">
        <div class="modal-dialog modal-md" role="document">
            <form action="" method="post">
                <input type="hidden" value="" name="lid" class="lid">
                <div class="modal-content">
                    <div class="modal-body">
                        <div class="col-md-12">
                            <img src="<?php echo $root; ?>/img/delete-icon.png" class="img-delete">
                            <h3 class="hdr-delete" style="font-size:29px; font-weight: bold;">Are you sure</h3>
                            <div class="list-selected-msg" style="text-align:center;font-size: 18px;">Do you really want to delete the selected list?<br />This process cannot be undone</div>
                        </div>
                        <div class="modal-footer" style="display: block;text-align: center;">
                            <button type="button" class="btn btn-default" data-dismiss="modal" style="width:200px;background-color:#c1c1c1;color:#ffffff;font-size: 21px;">Cancel</button>
                            <button type="submit" class="btn btn-danger" name="action" value="delete" style="width:200px;font-size: 21px;">Delete</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<!-- /.container-fluid -->

</div>
<!-- End of Main Content -->

<script>
    function upload_file()
    {
        var bar = $("#bar1");
        // return false;
        var percentVal = 0+'%';
        var percent = $("#percent1");
        $("#upload_file_form").ajaxForm({
            beforeSubmit: function() {
                $("#progress_div").css('display', '');
                bar.css('width',percentVal)
                bar.css('background-color', '#4e73df');
                percent.html(percentVal);
            },

            uploadProgress: function(event, position, total, percentComplete) {
                var percentVal = percentComplete + '%';
                bar.css('width',percentVal);
                bar.css('background-color', '#4e73df');
                percent.html(percentVal);
            },
            complete:function()
            {
                if(percent>=100+"%"){
                   // window.location.href = "<?= $root ?>/lists/create";
                }
            }
        });
    }
    $(function(){
        var intervalId;
        $('table.list-duplicate-contact-datatable').DataTable({
            "pageLength": 10,
            filter: false,
            "columnDefs": [
                { "width": "5%", "targets": 0 }
            ],
        });

        $(".dupe-select-all").change(function(){
            if($('.dupe-select-all').is(':checked')) {
                $('.dupe-email-chk').attr('checked',true);
            }else{
                $('.dupe-email-chk').removeAttr('checked');
            }
        });

        $(".csv-field").change(function(){
            var selected   = $(this).val();
            var identifier = $(this).attr("data-key");
            if( selected != 'Unassign' ){
                $(".label-"+identifier).addClass("assigned");
                $(".container-"+identifier).addClass("assigned");
            }else{
                $(".label-"+identifier).removeClass("assigned");
                $(".container-"+identifier).removeClass("assigned");
            }
        });

        $(".btn-list-delete").click(function(){
            var lid = $(this).attr("data-key");
            $(".lid").val(lid);
            alert(1);
            $("#modalDeleteConfirmation").modal('show');

        });

        // $(".list-check-row").click(function(){
        //   var credit_to_use = $(".credit_to_use").val();
        //   var c_qty = $(this).attr("data-contacts");
        //   if (this.checked == true) {
        //       //this add the total email to be cleaned that is checked
        //       var total_credit_to_use = parseFloat(credit_to_use) + parseFloat(c_qty);
        //       $(".credit_to_use").val(total_credit_to_use);
        //       $(".credit-to-use").html(total_credit_to_use);
        //       alert(total_credit_to_use);
        //   } else{
        //       //This deduct the value of the unchecked checkbox
        //       var total_credit_to_use = parseFloat(credit_to_use) - parseFloat(c_qty);
        //       $(".credit_to_use").val(total_credit_to_use);
        //       $(".credit-to-use").html(total_credit_to_use);
        //   }
        // });

    });
</script>

<!-- Footer -->
<footer class="sticky-footer bg-white">
    <div class="container my-auto">
        <div class="copyright text-center my-auto">
            <span>Copyright &copy; <?php echo date('Y'); ?></span>
        </div>
    </div>
</footer>
<!-- End of Footer -->

</div>
<!-- End of Content Wrapper -->

</div>
<!-- End of Page Wrapper -->

<!-- Scroll to Top Button-->
<a class="scroll-to-top rounded" href="#page-top">
    <i class="fas fa-angle-up"></i>
</a>